/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.hashmaps;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class TraitsManager
implements INBTSerializable<CompoundTag> {
    public boolean analysed = false;
    protected final Map<CropTraitsTypes, Integer> traits = new HashMap<CropTraitsTypes, Integer>();

    public TraitsManager(CompoundTag nbt) {
        this();
        this.deserializeNBT(nbt);
    }

    public TraitsManager() {
        this.defaultStats();
    }

    public void defaultStats() {
        for (CropTraitsTypes trait : CropTraitsTypes.values()) {
            this.traits.put(trait, trait.getMin());
        }
    }

    public TraitsManager copy() {
        TraitsManager copy = new TraitsManager();
        copy.analysed = this.analysed;
        this.traits.keySet().forEach(trait -> copy.traits.put((CropTraitsTypes)((Object)trait), this.traits.get(trait)));
        return copy;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("analysed", this.analysed);
        this.traits.forEach((trait, level) -> {
            if (level != null) {
                compound.m_128405_(trait.getName(), level.intValue());
            }
        });
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt != null) {
            this.analysed = nbt.m_128471_("analysed");
            this.traits.keySet().forEach(trait -> this.traits.put((CropTraitsTypes)((Object)trait), nbt.m_128441_(trait.getName()) ? Integer.valueOf(nbt.m_128451_(trait.getName())) : null));
        }
    }

    public boolean hasTrait(CropTraitsTypes trait) {
        return this.traits.get((Object)trait) != null;
    }

    public int getTrait(CropTraitsTypes trait) {
        Integer v = this.traits.get((Object)trait);
        return v == null ? 0 : v;
    }

    public void setTrait(CropTraitsTypes trait, int value) {
        this.traits.put(trait, value);
    }

    public String toString() {
        return "TraitsManager{analysed=" + this.analysed + ", traits=" + this.traits + "}";
    }

    public static class ItemImpl
    extends TypedImpl {
        public final ItemStack stack;

        private ItemImpl(ItemStack stack, CompoundTag compound) {
            super(compound);
            this.stack = stack;
            this.save();
        }

        private ItemImpl(ItemStack stack) {
            super(stack.m_41782_() ? stack.m_41783_() : null);
            this.stack = stack;
        }

        @Override
        public ItemImpl copy() {
            return ItemImpl.of(this.stack.m_41777_(), this.serializeNBT());
        }

        public static ItemImpl of(ItemStack stack) {
            return new ItemImpl(stack);
        }

        public static ItemImpl of(Item item, CompoundTag compound) {
            return ItemImpl.of(new ItemStack((ItemLike)item), compound);
        }

        public static ItemImpl of(ItemStack stack, CompoundTag compound) {
            return new ItemImpl(stack, compound);
        }

        public void save() {
            this.stack.m_41784_().m_128391_(this.serializeNBT());
        }

        @Override
        public String toString() {
            return "ItemImpl{" + super.toString() + ", ItemStack=" + this.stack + "}";
        }
    }

    public static class TypedImpl
    extends TraitsManager {
        @javax.annotation.Nullable
        public CropTypes type;
        private static final RandomSource RANDOM = RandomSource.m_216327_();

        public TypedImpl() {
        }

        public TypedImpl(@Nullable CropTypes type) {
            this.type = type;
        }

        public TypedImpl(CompoundTag nbt) {
            super(nbt);
        }

        public TypedImpl(CompoundTag nbt, @Nullable CropTypes type) {
            super(nbt);
            this.type = type;
        }

        public static Set<String> mutableTraitKeys() {
            TreeSet<String> set = new TreeSet<String>(PTCommonUtil.collect(Arrays.stream(CropTraitsTypes.values()).toList(), CropTraitsTypes::getName));
            set.add("type");
            return set;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag compound = super.serializeNBT();
            if (this.type != null) {
                compound.m_128359_("type", this.type.getName());
            }
            return compound;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            if (nbt != null) {
                this.type = CropTypes.fromNameNullable(nbt.m_128461_("type"));
            }
        }

        @Override
        public TypedImpl copy() {
            TypedImpl copy = new TypedImpl(this.type);
            copy.analysed = this.analysed;
            this.traits.keySet().forEach(trait -> copy.traits.put(trait, (Integer)this.traits.get(trait)));
            return copy;
        }

        public void setType(CropTypes type) {
            this.type = type;
        }

        public TypedImpl calculateNewTraits(TypedImpl otherTrait, CropTraitsTypes boost, int boostLevel) {
            List<CropTypes> children;
            CropTypes newType;
            CropTypes cropTypes = newType = RANDOM.m_188499_() ? this.type : otherTrait.type;
            if (this.type != otherTrait.type && this.type != null && otherTrait.type != null && !(children = CropTypes.getByParents(this.type, otherTrait.type)).isEmpty()) {
                boolean mutate;
                TreeMap<CropTypes, Float> mutationChances = new TreeMap<CropTypes, Float>();
                for (CropTypes child : children) {
                    mutationChances.put(child, Float.valueOf(child.getConfig().getMutateChanceForParents(this.type, otherTrait.type)));
                }
                float mutateChance = (float)mutationChances.values().stream().mapToDouble(Float::doubleValue).sum();
                boolean bl = mutate = RANDOM.m_188501_() <= mutateChance;
                if (mutate) {
                    double minInterval = 0.0;
                    float rand = RANDOM.m_188501_();
                    for (CropTypes crop : mutationChances.keySet()) {
                        double maxInterval = minInterval + (double)(((Float)mutationChances.get((Object)crop)).floatValue() / mutateChance);
                        if ((double)rand >= minInterval && (double)rand < maxInterval) {
                            newType = crop;
                            break;
                        }
                        minInterval = maxInterval;
                    }
                }
            }
            TypedImpl newTraits = new TypedImpl(newType);
            for (CropTraitsTypes trait : CropTraitsTypes.values()) {
                int lv2;
                int lv = this.getTrait(trait);
                if (lv == (lv2 = otherTrait.getTrait(trait))) {
                    newTraits.traits.put(trait, lv + (RANDOM.m_188501_() <= trait.getTransitionPossibility() + (trait == boost ? (float)boostLevel * 0.01f : 0.0f) && lv < trait.getMax() ? 1 : 0));
                    continue;
                }
                int min = Math.min(lv, lv2);
                int max = Math.max(lv, lv2);
                newTraits.traits.put(trait, RANDOM.m_188503_(max - min) + min);
            }
            return newTraits;
        }

        @Override
        public String toString() {
            return "TypedImpl{" + super.toString() + ", type=" + this.type + "}";
        }
    }
}

