/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.inventory.ItemUpgradeableMenu;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeableScreen
extends AbstractContainerScreen<ItemUpgradeableMenu> {
    protected static final Map<Integer, ResourceLocation> BACKGROUND = new HashMap<Integer, ResourceLocation>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(10, new ResourceLocation("planttech2:textures/gui/container/itemupgradeable_10.png"));
        }
    };
    protected final Inventory player;
    protected ItemStack stack;
    protected int invsize;
    protected IEnergyStorage energystorage;
    private static boolean WARNED = false;

    public ItemUpgradeableScreen(ItemUpgradeableMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.player = inv;
        this.stack = container.getStack();
        this.invsize = PTCommonUtil.tryAccessInvValue((ICapabilityProvider)this.stack, IItemHandler::getSlots, 0);
        LazyOptional<IEnergyStorage> optional = PTCommonUtil.getEnergyCap((ICapabilityProvider)this.stack);
        if (!optional.isPresent() && !WARNED) {
            PlantTechMain.LOGGER.error("Cannot access capability for provider, this should not happen " + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()));
            WARNED = true;
        }
        this.energystorage = (IEnergyStorage)optional.orElse((Object)new BioEnergyStorage(0));
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97726_ = 205;
        this.f_97727_ = 202;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
    }

    public void m_88315_(GuiGraphics pStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pStack);
        this.m_7286_(pStack, partialTicks, mouseX, mouseY);
        super.m_88315_(pStack, mouseX, mouseY, partialTicks);
        this.drawTooltips(pStack, mouseX, mouseY);
        this.m_280072_(pStack, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pStack, int mouseX, int mouseY) {
        String tileName = this.f_96539_.getString();
        int textcolor = Integer.parseInt("000000", 16);
        pStack.drawString(this.f_96547_, tileName, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92895_(tileName) / 2.0f + 1.0f, 14.0f, textcolor, false);
    }

    protected void drawTooltips(GuiGraphics pStack, int mouseX, int mouseY) {
        if (this.energystorage != null) {
            this.drawTooltip(pStack, this.energystorage.getEnergyStored() + "/" + this.energystorage.getMaxEnergyStored(), mouseX, mouseY, 148, 27, 16, 74);
        }
    }

    public void drawTooltip(GuiGraphics mStack, String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.f_97735_) && mouseX <= posX + width && mouseY >= (posY += this.f_97736_) && mouseY <= posY + height) {
            mStack.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)lines), mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics pStack, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pStack.m_280218_(BACKGROUND.get(this.invsize), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int k = this.getEnergyStoredScaled(55);
        pStack.m_280218_(BACKGROUND.get(this.invsize), this.f_97735_ + 149, this.f_97736_ + 28 + (55 - k), 208, 55 - k, 16, k);
    }

    protected int getEnergyStoredScaled(int pixels) {
        if (this.energystorage != null) {
            int i = this.energystorage.getEnergyStored();
            int j = this.energystorage.getMaxEnergyStored();
            return i != 0 && j != 0 ? i * pixels / j : 0;
        }
        return 0;
    }

    protected boolean m_97805_(int keyCode, int scanCode) {
        return false;
    }
}

