/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.gui.GuideBaseScreen;
import net.kaneka.planttech2.gui.buttons.CustomButton;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class GuidePlantsScreen
extends GuideBaseScreen {
    private final String[] buttonEntryNames = new String[8];
    private Component selectedName = Component.m_237113_((String)"");
    protected ItemStack primarySeed = ItemStack.f_41583_;
    protected ItemStack soil = ItemStack.f_41583_;
    protected ItemStack[] seeds = new ItemStack[9];
    protected DropEntry[] drops = new DropEntry[9];
    protected ItemStack[][] parents = new ItemStack[4][2];
    protected TemperatureTolerance temp = TemperatureTolerance.NORMAL;
    protected List<Component> temperatureStrings = new ArrayList<Component>();
    protected List<Map<Integer, CropTypes>> familyTree;
    protected Boolean isFamilyTree = false;
    protected List<List<Point>> treePoints = new ArrayList<List<Point>>();
    protected final List<Map<Integer, ItemStack>> parentsInTrees = new ArrayList<Map<Integer, ItemStack>>();

    public GuidePlantsScreen() {
        super(CropTypes.getEnabledLength() - 8, true, "screen.guideplants");
        this.treePoints.add(new ArrayList<Point>(List.of(new Point(262, 22))));
        this.treePoints.add(new ArrayList<Point>(Arrays.asList(new Point(206, 88), new Point(318, 88))));
        this.treePoints.add(new ArrayList<Point>(Arrays.asList(new Point(178, 126), new Point(234, 126), new Point(290, 126), new Point(346, 126))));
        this.treePoints.add(new ArrayList<Point>(Arrays.asList(new Point(164, 150), new Point(192, 150), new Point(220, 150), new Point(248, 150), new Point(276, 150), new Point(304, 150), new Point(332, 150), new Point(360, 150))));
        this.treePoints.add(new ArrayList<Point>(Arrays.asList(new Point(157, 167), new Point(171, 167), new Point(185, 167), new Point(199, 167), new Point(213, 167), new Point(227, 167), new Point(241, 167), new Point(255, 167), new Point(269, 167), new Point(283, 167), new Point(297, 167), new Point(311, 167), new Point(325, 167), new Point(339, 167), new Point(353, 167), new Point(367, 167))));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xPos = this.guiLeft + 31;
        int baseYPos = this.guiTop + 10;
        int width = 100;
        int height = 20;
        for (int id = 0; id < 8; ++id) {
            this.m_142416_((GuiEventListener)new CustomButton(id, xPos, baseYPos + id * 22, 100, 20, "Button " + (id + 1), this::buttonClicked));
        }
        this.m_142416_((GuiEventListener)new CustomButton(8, this.guiLeft + 295, this.guiTop + 151, 10, 10, "+", this::buttonClicked));
        this.m_142416_((GuiEventListener)new CustomButton(9, this.guiLeft + 350, this.guiTop + 12, 30, 12, Component.m_237115_((String)"gui.back").getString(), this::buttonClicked));
        if (this.buttonEntryNames != null) {
            this.updateButtons();
        }
    }

    @Override
    public void m_88315_(GuiGraphics pStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pStack);
        super.m_88315_(pStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawForeground(GuiGraphics pStack) {
        block8: {
            block7: {
                int i;
                if (!this.hasSelection || this.isFamilyTree.booleanValue()) break block7;
                RenderSystem.enableBlend();
                pStack.m_280163_(BACKGROUND, (int)((float)(this.guiLeft + 292) + this.temp.getMinTempTolerancePercent() * 40.0f), this.guiTop + 65, 0.0f, 276.0f, 5, 17, 512, 512);
                pStack.m_280163_(BACKGROUND, (int)((float)(this.guiLeft + 292) + this.temp.getMaxTempTolerancePercent() * 40.0f), this.guiTop + 65, 0.0f, 276.0f, 5, 17, 512, 512);
                RenderSystem.disableBlend();
                this.renderItem(pStack, this.primarySeed, 261, 32);
                if (!this.soil.m_41619_()) {
                    this.renderItem(pStack, this.soil, 217, 65);
                }
                for (i = 0; i < 9; ++i) {
                    if (!this.seeds[i].m_41619_()) {
                        this.renderItem(pStack, this.seeds[i], 189 + 18 * i, 98);
                    }
                    if (this.drops[i] == DropEntry.EMPTY) continue;
                    this.renderItem(pStack, this.drops[i].getItemStack(), 189 + 18 * i, 131);
                }
                for (i = 0; i < 4; ++i) {
                    if (this.parents[i][0].m_41619_()) continue;
                    this.renderItem(pStack, this.parents[i][0], 162 + 56 * i, 164);
                    this.renderItem(pStack, this.parents[i][1], 192 + 56 * i, 164);
                }
                break block8;
            }
            if (!this.isFamilyTree.booleanValue()) break block8;
            for (int i = 0; i < Math.min(5, this.familyTree.size()); ++i) {
                int k = 0;
                while ((double)k < Math.pow(2.0, i)) {
                    if (this.familyTree.get(i).containsKey(k) && this.treePoints.size() > i && this.treePoints.get(i).size() > k) {
                        Point point = this.treePoints.get(i).get(k);
                        float scale = 0.7f;
                        float width = 3.75f;
                        float height = 3.75f;
                        this.renderGuiItem(poseStack -> poseStack.m_85841_(scale, scale, 1.0f), this.parentsInTrees.get(i).get(k), (float)(this.guiLeft + point.x) - width, (float)(this.guiTop + point.y) - height);
                    }
                    ++k;
                }
            }
        }
    }

    @Override
    protected void updateButtons() {
        List<CropTypes> list = CropTypes.crops(false);
        for (int i = 0; i < 8; ++i) {
            if (this.scrollPos + i >= list.size()) continue;
            CropTypes entry = list.get(this.scrollPos + i);
            Object e = this.f_169369_.get(i);
            if (e instanceof AbstractWidget) {
                AbstractWidget aWidget = (AbstractWidget)e;
                aWidget.m_93666_(entry.getDisplayName());
            }
            this.buttonEntryNames[i] = entry.getName();
        }
        Object e = this.f_169369_.get(8);
        if (e instanceof AbstractWidget) {
            AbstractWidget treeButton = (AbstractWidget)e;
            if (this.hasSelection && !this.isFamilyTree.booleanValue()) {
                this.activateButton(treeButton);
            } else {
                this.deactivateButton(treeButton);
            }
        }
        if ((e = this.f_169369_.get(9)) instanceof AbstractWidget) {
            AbstractWidget backButton = (AbstractWidget)e;
            if (this.hasSelection && this.isFamilyTree.booleanValue()) {
                this.activateButton(backButton);
            } else {
                this.deactivateButton(backButton);
            }
        }
    }

    @Override
    protected void drawStrings(GuiGraphics mStack) {
        if (!this.hasSelection) {
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.non_selected"), this.guiLeft + 255, this.guiTop + 90, true);
        } else if (!this.isFamilyTree.booleanValue()) {
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, this.selectedName, this.guiLeft + 269, this.guiTop + 15, true);
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.soil"), this.guiLeft + 225, this.guiTop + 54, false);
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.temperature"), this.guiLeft + 314, this.guiTop + 54, false);
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.seeds"), this.guiLeft + 271, this.guiTop + 87, false);
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.drops"), this.guiLeft + 271, this.guiTop + 120, false);
            PTClientUtil.drawCenteredString(mStack, this.f_96547_, (Component)Component.m_237115_((String)"gui.parents"), this.guiLeft + 271, this.guiTop + 153, false);
        }
    }

    protected void buttonClicked(CustomButton button) {
        int buttonID = button.id;
        if (buttonID >= 0 && buttonID < 8) {
            this.setItems(this.buttonEntryNames[buttonID]);
            this.isFamilyTree = false;
        } else if (buttonID == 8) {
            this.isFamilyTree = true;
        } else if (buttonID == 9) {
            this.isFamilyTree = false;
        }
        this.updateButtons();
    }

    protected void setItems(String entryName) {
        int j;
        CropTypes crop = CropTypes.fromName(entryName);
        CropConfiguration config = crop.getConfig();
        this.hasSelection = true;
        this.familyTree = CropTypes.getFamilyTree(crop);
        this.parentsInTrees.clear();
        for (Map<Integer, CropTypes> CropTypes2 : this.familyTree) {
            HashMap<Integer, ItemStack> parentSeed = new HashMap<Integer, ItemStack>();
            for (Map.Entry<Integer, CropTypes> mapEntry : CropTypes2.entrySet()) {
                parentSeed.put(mapEntry.getKey(), new ItemStack((ItemLike)mapEntry.getValue().getConfig().getPrimarySeed().getItem().get()));
            }
            this.parentsInTrees.add(parentSeed);
        }
        this.selectedName = crop.getDisplayName();
        this.primarySeed = config.getPrimarySeed().getItemStack();
        this.temp = config.getTemperature();
        this.temperatureStrings = new ArrayList<Component>();
        this.temperatureStrings.add((Component)Component.m_237113_((String)this.temp.getDisplayString()));
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            world.m_246945_(Registries.f_256952_).m_255209_().forEach(arg_0 -> this.lambda$setItems$1((Level)world, arg_0));
        }
        this.soil = new ItemStack((ItemLike)config.getSoil().get());
        Arrays.fill(this.seeds, ItemStack.f_41583_);
        Arrays.fill(this.drops, DropEntry.EMPTY);
        for (int k = 0; k < 4; ++k) {
            Arrays.fill(this.parents[k], ItemStack.f_41583_);
        }
        List<Supplier<Ingredient>> seeds = config.getSeeds();
        List<DropEntry> drops = config.getDrops();
        List<ParentPair> parents = config.getParents();
        this.seeds[0] = config.getPrimarySeed().getItemStack();
        int i = 1;
        for (Supplier<Ingredient> seed : seeds) {
            for (ItemStack item : seed.get().m_43908_()) {
                if (item.m_41720_() == Items.f_42127_) continue;
                this.seeds[i] = item.m_41777_();
                ++i;
            }
        }
        this.drops[0] = config.getPrimarySeed();
        for (j = 0; j < 8 && j < drops.size(); ++j) {
            this.drops[j + 1] = drops.get(j);
        }
        for (j = 0; j < 4 && j < parents.size(); ++j) {
            ParentPair pair = parents.get(j);
            this.parents[j][0] = pair.getFirstParent().getConfig().getPrimarySeed().getItemStack();
            this.parents[j][1] = pair.getSecondParent().getConfig().getPrimarySeed().getItemStack();
        }
        this.updateButtons();
    }

    @Override
    protected void drawTooltips(GuiGraphics mStack, int mouseX, int mouseY) {
        block8: {
            block7: {
                int i;
                if (!this.hasSelection || this.isFamilyTree.booleanValue()) break block7;
                this.drawTooltip(mStack, this.primarySeed.m_41786_(), mouseX, mouseY, 261, 32);
                if (!this.soil.m_41619_()) {
                    this.drawTooltip(mStack, this.soil.m_41786_(), mouseX, mouseY, 217, 65);
                }
                this.drawTooltip(mStack, this.temperatureStrings, mouseX, mouseY, 293, 64, 41, 17);
                for (i = 0; i < 9; ++i) {
                    if (!this.seeds[i].m_41619_()) {
                        this.drawTooltip(mStack, this.seeds[i].m_41786_(), mouseX, mouseY, 189 + 18 * i, 98);
                    }
                    if (this.drops[i] == DropEntry.EMPTY) continue;
                    this.drawTooltip(mStack, (Component)Component.m_237113_((String)"").m_130946_(this.drops[i].getMin() + "-" + this.drops[i].getMax() + "x ").m_7220_(this.drops[i].getItem().get().m_5456_().m_41466_()), mouseX, mouseY, 189 + 18 * i, 131);
                }
                for (i = 0; i < 4; ++i) {
                    if (this.parents[i][0].m_41619_()) continue;
                    this.drawTooltip(mStack, this.parents[i][0].m_41786_(), mouseX, mouseY, 162 + 56 * i, 164);
                    this.drawTooltip(mStack, this.parents[i][1].m_41786_(), mouseX, mouseY, 192 + 56 * i, 164);
                }
                break block8;
            }
            if (!this.isFamilyTree.booleanValue()) break block8;
            for (int i = 0; i < Math.min(5, this.familyTree.size()); ++i) {
                int k = 0;
                while ((double)k < Math.pow(2.0, i)) {
                    if (this.familyTree.get(i).containsKey(k) && this.treePoints.size() > i && this.treePoints.get(i).size() > k) {
                        Point point = this.treePoints.get(i).get(k);
                        this.drawTooltip(mStack, this.familyTree.get(i).get(k).getConfig().getPrimarySeed().getItemStack().m_41786_(), mouseX, mouseY, point.x, point.y, 9, 9);
                    }
                    ++k;
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.hasSelection && !this.isFamilyTree.booleanValue() && mouseButton == 0) {
            int i;
            Item clickedOn = null;
            if (this.inItemStackArea(mouseX, mouseY, 261, 32)) {
                clickedOn = this.primarySeed.m_41720_();
            }
            if (this.inItemStackArea(mouseX, mouseY, 217, 65) && this.soil != null && !this.soil.m_41619_()) {
                clickedOn = this.soil.m_41720_();
            }
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null && this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 98)) {
                    clickedOn = this.seeds[i].m_41720_();
                }
                if (this.drops[i] == null || !this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 131)) continue;
                clickedOn = this.drops[i].getItem().get().m_5456_();
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                if (this.inItemStackArea(mouseX, mouseY, 162 + 56 * i, 164)) {
                    clickedOn = this.parents[i][0].m_41720_();
                }
                if (!this.inItemStackArea(mouseX, mouseY, 192 + 56 * i, 164)) continue;
                clickedOn = this.parents[i][1].m_41720_();
            }
            if (clickedOn != null) {
                CropTypes.getBySeed(new ItemStack((ItemLike)clickedOn)).ifPresent(entry -> this.setItems(entry.getName()));
            }
        } else if (this.isFamilyTree.booleanValue()) {
            String clickedName = null;
            for (int i = 0; i < Math.min(5, this.familyTree.size()); ++i) {
                int k = 0;
                while ((double)k < Math.pow(2.0, i)) {
                    if (this.familyTree.get(i).containsKey(k) && this.treePoints.size() > i && this.treePoints.get(i).size() > k) {
                        Point point = this.treePoints.get(i).get(k);
                        if (this.inArea(mouseX, mouseY, point.x, point.y, 9, 9)) {
                            clickedName = this.familyTree.get(i).get(k).getName();
                        }
                    }
                    ++k;
                }
            }
            if (clickedName != null) {
                this.isFamilyTree = false;
                this.setItems(clickedName);
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private boolean inArea(double mouseX, double mouseY, int posX, int posY, int width, int height) {
        return mouseX >= (double)(posX += this.guiLeft) && mouseX <= (double)(posX + width) && mouseY >= (double)(posY += this.guiTop) && mouseY <= (double)(posY + height);
    }

    private boolean inItemStackArea(double mouseX, double mouseY, int posX, int posY) {
        return this.inArea(mouseX, mouseY, posX, posY, 16, 16);
    }

    @Override
    protected void drawBackground(GuiGraphics mStack) {
        if (!this.hasSelection || this.isFamilyTree.booleanValue()) {
            mStack.m_280163_(BACKGROUND, this.guiLeft + 100, this.guiTop, 212.0f, 0.0f, 300, this.ySize, 512, 512);
            if (this.isFamilyTree.booleanValue()) {
                mStack.m_280163_(BACKGROUND, this.guiLeft + 156, this.guiTop + 21, 0.0f, 356.0f, 221, 156, 512, 512);
            }
        } else {
            mStack.m_280163_(BACKGROUND, this.guiLeft + 100, this.guiTop, 212.0f, 196.0f, 300, this.ySize, 512, 512);
        }
        mStack.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, 150, this.ySize, 512, 512);
    }

    private void activateButton(AbstractWidget button) {
        button.f_93623_ = true;
        button.f_93624_ = true;
    }

    private void deactivateButton(AbstractWidget button) {
        button.f_93623_ = false;
        button.f_93624_ = false;
    }

    private /* synthetic */ void lambda$setItems$1(Level world, ResourceKey entry) {
        HolderLookup biomeHolders = world.m_246945_(Registries.f_256952_);
        Holder.Reference biomeRef = (Holder.Reference)biomeHolders.m_254902_(entry).get();
        float biomeTemp = ((Biome)biomeRef.get()).getModifiedClimateSettings().f_47681_();
        if (this.temp.inRange(biomeTemp)) {
            this.temperatureStrings.add((Component)Component.m_237115_((String)("biome." + entry.m_135782_().m_135827_() + "." + entry.m_135782_().m_135815_())).m_130946_(" (").m_130946_(String.valueOf(biomeTemp)).m_130946_(")"));
        }
    }
}

