/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.kaneka.planttech2.items.GuideItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class GuideBaseScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2", "textures/gui/plantencyclopaedia_big.png");
    protected static final int TEXT_COLOR = 0;
    protected int xSize = 512;
    protected int ySize = 196;
    protected int guiLeft;
    protected int guiTop;
    protected int scrollMax;
    protected int scrollPos = 0;
    protected int fadeInTimer = 50;
    protected boolean hasSelection;
    protected boolean allowScroll;

    public GuideBaseScreen(int scrollMax, boolean allowScroll, String title) {
        super((Component)Component.m_237115_((String)title));
        this.scrollMax = scrollMax;
        this.allowScroll = allowScroll;
    }

    public void m_7856_() {
        super.m_7856_();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null && player.m_21205_().m_41720_() instanceof GuideItem) {
            player.m_21205_().m_41721_(1);
        }
        this.hasSelection = false;
        this.guiLeft = (this.f_96543_ - 400) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
    }

    protected void renderGuiItem(Consumer<PoseStack> transform, ItemStack item, float x, float y) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(item, null, null, minecraft.f_91074_.m_19879_());
        minecraft.f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_(x, y, 0.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        transform.accept(posestack);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85836_();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(item, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, model);
        posestack1.m_85849_();
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    protected abstract void updateButtons();

    public void m_88315_(GuiGraphics pStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fadeInTimer > 0) {
            --this.fadeInTimer;
            this.drawFadeInEffect(pStack);
        } else {
            this.drawBackground(pStack);
            this.drawForeground(pStack);
            this.drawButtons(pStack, mouseX, mouseY, partialTicks);
            this.drawStrings(pStack);
            this.drawTooltips(pStack, mouseX, mouseY);
        }
    }

    private void drawButtons(GuiGraphics mStack, int mouseX, int mouseY, float partialTicks) {
        for (Renderable button : this.f_169369_) {
            button.m_88315_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground(GuiGraphics mStack) {
        mStack.m_280163_(BACKGROUND, this.guiLeft + 100, this.guiTop, 212.0f, 0.0f, 300, this.ySize, 512, 512);
        mStack.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, 150, this.ySize, 512, 512);
    }

    protected abstract void drawForeground(GuiGraphics var1);

    private void drawFadeInEffect(GuiGraphics mStack) {
        float percentage = 1.0f - (float)this.fadeInTimer / 50.0f;
        mStack.m_280163_(BACKGROUND, this.guiLeft + 100, this.guiTop, (float)this.xSize - 300.0f * percentage, 0.0f, (int)(300.0f * percentage), this.ySize, 512, 512);
        mStack.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, 150, this.ySize, 512, 512);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.allowScroll && mouseX != 0.0) {
            this.scrollPos += delta > 0.0 ? -1 : 1;
            this.scrollPos = Math.max(0, this.scrollPos);
            this.scrollPos = Math.min(this.scrollMax, this.scrollPos);
            this.updateButtons();
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected abstract void drawStrings(GuiGraphics var1);

    public void renderItem(GuiGraphics stack, ItemStack itemstack, int x, int y) {
        stack.m_280203_(itemstack, this.guiLeft + x, this.guiTop + y);
        stack.m_280370_(this.f_96547_, itemstack, this.guiLeft + x, this.guiTop + y);
    }

    public void drawTooltip(GuiGraphics pStack, Component lines, int mouseX, int mouseY, int posX, int posY) {
        this.drawTooltip(pStack, lines, mouseX, mouseY, posX, posY, 16, 16);
    }

    public void drawTooltip(GuiGraphics pStack, Component lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            pStack.m_280557_(this.f_96547_, lines, mouseX, mouseY);
        }
    }

    public void drawTooltip(GuiGraphics pStack, List<Component> lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            pStack.m_280666_(this.f_96547_, lines, mouseX, mouseY);
        }
    }

    protected abstract void drawTooltips(GuiGraphics var1, int var2, int var3);

    public void m_7861_() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_21205_().m_41720_() instanceof GuideItem) {
            player.m_21205_().m_41721_(0);
        }
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }
}

