/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids;

import javax.annotation.Nonnull;
import net.kaneka.planttech2.registries.ModFluids;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface PTBiomassFluidHandler
extends IFluidHandler {
    default public int getTanks() {
        return 1;
    }

    @Nonnull
    default public FluidStack getFluidInTank(int tank) {
        return this.validCOntainer() ? new FluidStack((Fluid)ModFluids.BIOMASS.get(), this.currentBiomass()) : FluidStack.EMPTY;
    }

    default public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack.getFluid() == ModFluids.BIOMASS.get();
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int space = this.space();
        if (!this.validCOntainer() || !this.isFluidValid(1, resource) && resource != FluidStack.EMPTY || space <= 0) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), space);
        if (action.execute()) {
            this.forceChangeStorage(amount);
        }
        return amount;
    }

    @Nonnull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(1, resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int current = this.currentBiomass();
        if (!this.validCOntainer() || current <= 0) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, current);
        if (action.execute()) {
            this.forceChangeStorage(-amount);
        }
        return new FluidStack((Fluid)ModFluids.BIOMASS.get(), amount);
    }

    default public void forceChangeStorage(int amount) {
        this.forceSetStorage(this.currentBiomass() + amount);
    }

    public void forceSetStorage(int var1);

    public boolean validCOntainer();

    public int currentBiomass();

    default public int space() {
        return this.getTankCapacity(0) - this.currentBiomass();
    }
}

