/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids;

import java.util.function.Consumer;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public abstract class BiomassFluid
extends FlowingFluid {
    public static final ResourceLocation BIOMASS_STILL = new ResourceLocation("planttech2", "block/fluid/biomass_still");
    public static final ResourceLocation BIOMASS_FLOWING = new ResourceLocation("planttech2", "block/fluid/biomass_flow");

    public Fluid m_5615_() {
        return (Fluid)ModFluids.BIOMASS_FLOWING.get();
    }

    public Fluid m_5613_() {
        return (Fluid)ModFluids.BIOMASS.get();
    }

    protected boolean m_6760_(Level p_256009_) {
        return false;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
    }

    protected int m_6719_(LevelReader worldIn) {
        return 4;
    }

    protected int m_6713_(LevelReader worldIn) {
        return 1;
    }

    public Item m_6859_() {
        return (Item)ModItems.BIOMASS_BUCKET.get();
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.m_205067_(FluidTags.f_13131_);
    }

    public int m_6718_(LevelReader p_205569_1_) {
        return 5;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected BlockState m_5804_(FluidState state) {
        return (BlockState)((Block)ModBlocks.BIOMASSFLUIDBLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(BiomassFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == ModFluids.BIOMASS.get() || fluidIn == ModFluids.BIOMASS_FLOWING.get();
    }

    public static class Source
    extends BiomassFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        public FluidType getFluidType() {
            return new FluidType(FluidType.Properties.create().canConvertToSource(true)){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return BIOMASS_STILL;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return BIOMASS_FLOWING;
                        }
                    });
                }
            };
        }
    }

    public static class Flowing
    extends BiomassFluid {
        public Flowing() {
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        public FluidType getFluidType() {
            return new FluidType(FluidType.Properties.create().canConvertToSource(false)){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return BIOMASS_STILL;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return BIOMASS_FLOWING;
                        }
                    });
                }
            };
        }
    }
}

