/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.entities.ModModelLayers;
import net.kaneka.planttech2.entities.passive.plant_mite.PlantMiteRenderer;
import net.kaneka.planttech2.entities.passive.snail.SnailRenderer;
import net.kaneka.planttech2.entities.passive.tech_trader.TechTraderRenderer;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.ParticleItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModScreens;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="planttech2", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModBusEventsClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(PTClientUtil::addAllItemModelsOverrides);
        ModScreens.registerGUI();
    }

    @SubscribeEvent
    public static void addLayerDefs(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModModelLayers.registerAll(event);
    }

    @SubscribeEvent
    public static void onRenderersRegistered(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.TECH_TRADER.get(), TechTraderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.SNAIL.get(), SnailRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.PLANT_MITE.get(), PlantMiteRenderer::new);
    }

    @SubscribeEvent
    public static void registerColorItem(RegisterColorHandlersEvent.Item event) {
        for (RegistryObject<Item> registryObject : ModItems.PARTICLES.values()) {
            event.getItemColors().m_92689_((ItemColor)new ParticleItem.ColorHandler(), new ItemLike[]{(ItemLike)registryObject.get()});
        }
        for (RegistryObject<Item> registryObject : CropTypes.SEEDS.values()) {
            event.getItemColors().m_92689_((ItemColor)new CropSeedItem.ColorHandler(), new ItemLike[]{(ItemLike)registryObject.get()});
        }
        for (RegistryObject<Item> registryObject : ModBlocks.HEDGE_BLOCKS) {
            Hedge block = (Hedge)((Object)registryObject.get());
            event.getItemColors().m_92689_((ItemColor)new Hedge.ColorHandlerItem(block.getLeaves()), new ItemLike[]{block});
        }
    }

    @SubscribeEvent
    public static void registerColorBlock(RegisterColorHandlersEvent.Block event) {
        Block block;
        for (RegistryObject<Block> registryObject : CropTypes.CROP_BLOCKS.values()) {
            block = (CropBaseBlock)((Object)registryObject.get());
            event.getBlockColors().m_92589_((BlockColor)new CropBaseBlock.ColorHandler(), new Block[]{block});
        }
        for (RegistryObject<Block> registryObject : ModBlocks.HEDGE_BLOCKS) {
            block = (Hedge)((Object)registryObject.get());
            event.getBlockColors().m_92589_((BlockColor)new Hedge.ColorHandler(block.getLeaves(), block.getSoil()), new Block[]{block});
        }
    }
}

