/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.utilities.blocks.BlockRenderLayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="planttech2", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistry {
    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) throws IllegalAccessException {
        List list = Arrays.stream(ModBlocks.class.getDeclaredFields()).filter(f -> f.isAnnotationPresent(BlockRenderLayer.class)).collect(Collectors.toList());
        for (Field field : list) {
            BlockRenderLayer annotation = field.getAnnotation(BlockRenderLayer.class);
            RegistryObject registryObject = (RegistryObject)field.get(RegistryObject.class);
            Block block = (Block)registryObject.get();
            switch (annotation.layer()) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_());
                }
            }
        }
        for (RegistryObject registryObject : CropTypes.CROP_BLOCKS.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.m_110463_());
        }
    }
}

