/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.enums;

import java.util.Arrays;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum CropTraitsTypes {
    GROW_SPEED("growspeed", 0, 10, 0.04f),
    SENSITIVITY("sensitivity", 0, 10, 0.04f),
    LIGHT_SENSITIVITY("lightsensitivity", 0, 14, 0.06f),
    WATER_SENSITIVITY("watersensitivity", 0, 8, 0.06f),
    TEMPERATURE_TOLERANCE("temperaturetolerance", 0, 6, 0.03f),
    PRODUCTIVITY("productivity", 0, 5, 0.04f),
    FERTILITY("fertility", 0, 5, 0.04f),
    SPREADING_SPEED("spreadingspeed", 0, 10, 0.04f),
    GENE_STRENGTH("genestrength", 0, 10, 0.04f),
    ENERGY_VALUE("energyvalue", 1, 10, 0.04f);

    private final int min;
    private final int max;
    private final float transitionpossibility;
    private final String name;

    private CropTraitsTypes(String name, int min, int max, float transitionpossibility) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.transitionpossibility = transitionpossibility;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "planttech2.traits." + this.name;
    }

    public static CropTraitsTypes getByName(String name) {
        return Arrays.stream(CropTraitsTypes.values()).filter(trait -> trait.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public float getTransitionPossibility() {
        return this.transitionpossibility;
    }
}

