/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.passive.tech_trader;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.configuration.PlantTech2Configuration;
import net.kaneka.planttech2.entities.passive.tech_trader.TechTrader;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TechTraderSpawner
implements CustomSpawner {
    private final RandomSource random = RandomSource.m_216327_();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private final float spawnChance;
    @Deprecated
    public static final int TEST_CD = 100;
    public static final int ACTUAL_CD = 36000;
    public static final int CD = 36000;

    @SubscribeEvent
    public static void registerSpawn(LevelEvent.Load event) {
        LevelAccessor accessor = event.getLevel();
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
        }
    }

    public TechTraderSpawner(ServerLevelData p_35914_) {
        this.serverLevelData = p_35914_;
        this.tickDelay = 12000;
        this.spawnDelay = 36000;
        this.spawnChance = 0.075f;
    }

    public int m_7995_(ServerLevel p_35922_, boolean p_35923_, boolean p_35924_) {
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 36000;
        this.spawnDelay -= 36000;
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 36000;
        if (!p_35922_.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        if ((double)this.random.m_188501_() <= (double)this.spawnChance * (Double)PlantTech2Configuration.TECHTRADER_SPAWN_CHANCE.get()) {
            return 0;
        }
        if (this.spawn(p_35922_)) {
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel p_35916_) {
        ServerPlayer player = p_35916_.m_8890_();
        if (player == null) {
            return true;
        }
        BlockPos blockpos = player.m_20183_();
        int i = 48;
        PoiManager poimanager = p_35916_.m_8904_();
        Optional optional = poimanager.m_27186_(p_219713_ -> p_219713_.m_203565_(PoiTypes.f_218061_), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnPositionNear((LevelReader)p_35916_, blockpos1, 48);
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)p_35916_, blockpos2)) {
            if (p_35916_.m_204166_(blockpos2).m_203656_(BiomeTags.f_215807_)) {
                return false;
            }
            TechTrader techTrader = (TechTrader)((EntityType)ModEntityTypes.TECH_TRADER.get()).m_262496_(p_35916_, blockpos2, MobSpawnType.EVENT);
            if (techTrader != null) {
                this.serverLevelData.m_8115_(techTrader.m_20148_());
                techTrader.setDespawnDelay(48000);
                techTrader.setWanderTarget(blockpos1);
                techTrader.m_21446_(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader p_35929_, BlockPos p_35930_, int p_35931_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_35930_.m_123341_() + this.random.m_188503_(p_35931_ * 2) - p_35931_;
            BlockPos blockpos1 = new BlockPos(j, l = p_35929_.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = p_35930_.m_123343_() + this.random.m_188503_(p_35931_ * 2) - p_35931_), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)p_35929_, (BlockPos)blockpos1, (EntityType)((EntityType)ModEntityTypes.TECH_TRADER.get()))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)p_35927_, (BlockPos)p_35927_.m_7918_(1, 2, 1))) {
            if (p_35926_.m_8055_(blockpos).m_60812_(p_35926_, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

