/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.passive.tech_trader;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class TechTrader
extends AbstractVillager {
    private static final int NUMBER_OF_TRADE_OFFERS = 4;
    private static final int NUMBER_OF_RARE_TRADE_OFFERS = 1;
    @javax.annotation.Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;
    private static final Lazy<VillagerTrades.ItemListing[]> TRADES = Lazy.of(() -> ((ArrayList)Util.m_137469_(new ArrayList(), list -> {
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), 3, (Item)ModItems.THERMOMETER.get(), 1));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 33 + rand.m_188503_(25), ModItems.CYBERBOW, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 31 + rand.m_188503_(25), ModItems.CYBERDAGGER, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 32 + rand.m_188503_(25), ModItems.CYBERKATANA, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 32 + rand.m_188503_(25), ModItems.CYBERRAPIER, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 34 + rand.m_188503_(25), ModItems.CYBERARMOR_BOOTS, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 37 + rand.m_188503_(25), ModItems.CYBERARMOR_LEGGINGS, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 38 + rand.m_188503_(25), ModItems.CYBERARMOR_CHEST, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade((Item)ModItems.PLANTIUM_INGOT.get(), rand -> 35 + rand.m_188503_(25), ModItems.CYBERARMOR_HELMET, rand -> 1, rand -> 10 + rand.m_188503_(10)));
        list.add(TechTrader.normalTrade(Items.f_42499_, 16, (Item)ModItems.FERTILIZER_TIER_1.get(), 1));
        list.add(TechTrader.normalTrade(Items.f_42499_, 32, (Item)ModItems.FERTILIZER_TIER_2.get(), 1));
        list.add(TechTrader.normalTrade(Items.f_42499_, 48, (Item)ModItems.FERTILIZER_TIER_3.get(), 1));
        list.add(TechTrader.normalTrade(Items.f_42499_, 64, (Item)ModItems.FERTILIZER_TIER_4.get(), 1));
        list.add(TechTrader.particle(Items.f_42413_, 2, CropTypes.COAL_CROP, 1));
        list.add(TechTrader.particle(Items.f_42416_, 2, CropTypes.IRON_CROP, 1));
        list.add(TechTrader.particle(Items.f_151052_, 2, CropTypes.COPPER_CROP, 1));
        list.add(TechTrader.particle(Items.f_42417_, 2, CropTypes.GOLD_CROP, 1));
        list.add(TechTrader.particle(Items.f_42451_, 2, CropTypes.REDSTONE_CROP, 1));
        list.add(TechTrader.particle(Items.f_42534_, 2, CropTypes.LAPIS_CROP, 1));
        list.add(TechTrader.particle(Items.f_42415_, 2, CropTypes.DIAMOND_CROP, 1));
        list.add(TechTrader.particle(Items.f_42418_, 2, CropTypes.NETHERITE_CROP, 1));
    })).toArray(new VillagerTrades.ItemListing[0]));
    private static final Lazy<VillagerTrades.ItemListing[]> RARE_TRADES = Lazy.of(() -> ((ArrayList)Util.m_137469_(new ArrayList(), list -> {
        for (int i = 0; i < CropTypes.crops().size(); ++i) {
            final CropTypes crop = CropTypes.crops().get(i);
            List<ParentPair> parents = crop.getConfig().getParents();
            for (final ParentPair parent : parents) {
                list.add(new VillagerTrades.ItemListing(){

                    @Nullable
                    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
                        return crop.shouldBeInGame() && crop.hasParticle() ? new MerchantOffer(new ItemStack((ItemLike)parent.getFirstParent().getConfig().getPrimarySeed().getItem().get(), 16 + random.m_188503_(48)), new ItemStack((ItemLike)parent.getSecondParent().getConfig().getPrimarySeed().getItem().get(), 16 + random.m_188503_(48)), new ItemStack((ItemLike)crop.getConfig().getPrimarySeed().getItem().get()), 10, 2, 0.0f) : null;
                    }
                });
            }
        }
    })).toArray(new VillagerTrades.ItemListing[0]));

    private static VillagerTrades.ItemListing particle(Item input, int count, CropTypes output, int count2) {
        return TechTrader.normalTrade(input, rand -> count, () -> !output.shouldBeInGame() || !output.hasParticle() ? null : output.getParticle(), rand -> count2, rand -> 0);
    }

    private static VillagerTrades.ItemListing normalTrade(Item input, int count, @javax.annotation.Nullable Item output, int count2) {
        return TechTrader.normalTrade(input, rand -> count, () -> output, rand -> count2, rand -> 0);
    }

    private static VillagerTrades.ItemListing normalTrade(final Item input, final Function<RandomSource, Integer> count, final Supplier<Item> output, final Function<RandomSource, Integer> count2, Function<RandomSource, Integer> inch) {
        return new VillagerTrades.ItemListing(){

            @Nullable
            public MerchantOffer m_213663_(Entity p_219693_, RandomSource rand) {
                return output.get() == null ? null : new MerchantOffer(new ItemStack((ItemLike)input, ((Integer)count.apply(rand)).intValue()), new ItemStack((ItemLike)output.get(), ((Integer)count2.apply(rand)).intValue()), 10, 1, 0.0f);
            }
        };
    }

    public TechTrader(EntityType<? extends TechTrader> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderToPositionGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        return null;
    }

    public boolean m_7826_() {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (!this.m_6616_().isEmpty() && !this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7604_() {
        MerchantOffers offers = this.m_6616_();
        this.m_35277_(offers, (VillagerTrades.ItemListing[])TRADES.get(), 4);
        this.m_35277_(offers, (VillagerTrades.ItemListing[])RARE_TRADES.get(), 1);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            compound.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(CompoundTag p_35852_) {
        super.m_7378_(p_35852_);
        if (p_35852_.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = p_35852_.m_128451_("DespawnDelay");
        }
        if (p_35852_.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)p_35852_.m_128469_("WanderTarget"));
        }
        this.m_146762_(Math.max(0, this.m_146764_()));
    }

    public boolean m_6785_(double p_35886_) {
        return false;
    }

    protected void m_8058_(MerchantOffer p_35859_) {
        if (p_35859_.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_35306_() ? SoundEvents.f_12538_ : SoundEvents.f_12582_;
    }

    protected SoundEvent m_7975_(DamageSource p_35870_) {
        return SoundEvents.f_12587_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12583_;
    }

    protected SoundEvent m_7838_(ItemStack stack) {
        return stack.m_150930_(Items.f_42455_) ? SoundEvents.f_12585_ : SoundEvents.f_12586_;
    }

    protected SoundEvent m_6068_(boolean happy) {
        return happy ? SoundEvents.f_12539_ : SoundEvents.f_12588_;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12539_;
    }

    public void setDespawnDelay(int p_35892_) {
        this.despawnDelay = p_35892_;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.m_35306_() && --this.despawnDelay == 0) {
            this.m_146870_();
        }
    }

    public void setWanderTarget(@javax.annotation.Nullable BlockPos p_35884_) {
        this.wanderTarget = p_35884_;
    }

    @javax.annotation.Nullable
    BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    static class WanderToPositionGoal
    extends Goal {
        final TechTrader trader;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(TechTrader tarder, double maxDistance, double speed) {
            this.trader = tarder;
            this.stopDistance = maxDistance;
            this.speedModifier = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.trader.setWanderTarget(null);
            this.trader.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.trader.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos pos = this.trader.getWanderTarget();
            if (pos != null && this.trader.f_21344_.m_26571_()) {
                if (this.isTooFarAway(pos, 10.0)) {
                    Vec3 vec3 = new Vec3((double)pos.m_123341_() - this.trader.m_20185_(), (double)pos.m_123342_() - this.trader.m_20186_(), (double)pos.m_123343_() - this.trader.m_20189_()).m_82541_();
                    Vec3 vec31 = vec3.m_82490_(10.0).m_82520_(this.trader.m_20185_(), this.trader.m_20186_(), this.trader.m_20189_());
                    this.trader.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
                } else {
                    this.trader.f_21344_.m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos pos, double d) {
            return !pos.m_203195_((Position)this.trader.m_20182_(), d);
        }
    }
}

