/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.passive.snail;

import java.util.Arrays;
import java.util.function.Predicate;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class SnailEntity
extends Animal {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SnailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int EAT_CD = 1200;
    protected int ticksLastAte;
    private final RandomSource rand = RandomSource.m_216327_();

    public SnailEntity(EntityType<SnailEntity> type, Level world) {
        super((EntityType)ModEntityTypes.SNAIL.get(), world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.ticksLastAte > 0) {
            --this.ticksLastAte;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void setRandomVariant() {
        this.setVariant(PTCommonUtil.randomByWeight(Arrays.stream(SnailType.values()).toList(), SnailType::getChance, this.rand).ordinal());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        SpawnGroupData d = super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
        this.setRandomVariant();
        return d;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.35));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13143_), false));
        this.f_21345_.m_25352_(3, (Goal)new EatCropsGoal(this, 0.85f, 20, 3));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
    }

    public boolean m_7848_(Animal partner) {
        return false;
    }

    public SnailType getVariant() {
        return SnailType.values()[(Integer)this.f_19804_.m_135370_(VARIANT)];
    }

    public void setVariant(SnailType variant) {
        this.setVariant(variant.ordinal());
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("snailVariant", this.getVariant().ordinal());
        compound.m_128405_("lastAte", this.ticksLastAte);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("snailVariant"));
        this.ticksLastAte = compound.m_128451_("lastAte");
    }

    public boolean m_6785_(double p_27598_) {
        return !this.m_21532_();
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.575f : 1.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13143_);
    }

    public static AttributeSupplier.Builder createSnailAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.115f);
    }

    @Nullable
    public SnailEntity getBreedOffspring(ServerLevel world, AgeableMob mob) {
        SnailEntity entity = (SnailEntity)((EntityType)ModEntityTypes.SNAIL.get()).m_20615_((Level)world);
        if (entity != null) {
            entity.setVariant(this.getVariant());
        }
        return entity;
    }

    protected ResourceLocation m_7582_() {
        return this.getVariant().loottable;
    }

    public static enum SnailType implements Predicate<SnailType>
    {
        BLACK(0.1f, ModItems.CRACKED_SNAIL_SHELL_BLACK),
        CYBER(0.01f, ModItems.CRACKED_SNAIL_SHELL_CYBER),
        GARDEN(0.8f, ModItems.CRACKED_SNAIL_SHELL_GARDEN),
        MILK(0.07f, ModItems.CRACKED_SNAIL_SHELL_MILK),
        PINK(0.02f, ModItems.CRACKED_SNAIL_SHELL_PINK);

        public final float chance;
        public final RegistryObject<Item> crackedShell;
        public final ResourceLocation texture;
        public final ResourceLocation loottable;

        private SnailType(float chance, RegistryObject<Item> crackedShell) {
            this.chance = chance;
            this.crackedShell = crackedShell;
            this.texture = new ResourceLocation("planttech2", "textures/entities/snail/snail_" + this.name().toLowerCase() + ".png");
            this.loottable = new ResourceLocation("planttech2", "entities/snail_" + this.name().toLowerCase());
        }

        public float getChance() {
            return this.chance;
        }

        @Override
        public boolean test(SnailType snailType) {
            return false;
        }
    }

    public static class EatCropsGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 60;
        protected int ticksWaited;
        private final SnailEntity snail;

        public EatCropsGoal(SnailEntity entity, double speed, int hRange, int vRange) {
            super((PathfinderMob)entity, speed, hRange, vRange);
            this.snail = entity;
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public double m_8052_() {
            return 1.3f;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.snail.ticksLastAte <= 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.snail.ticksLastAte <= 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.snail.ticksLastAte = 1200 + this.snail.m_9236_().f_46441_.m_188503_(1200);
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            CropBlock crop;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            return block instanceof CropBlock && (crop = (CropBlock)block).m_52305_(state) > 0 || state.m_60734_() instanceof CropBaseBlock && (Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) > 0 && (Boolean)state.m_61143_((Property)CropBaseBlock.COPPER) == false;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                if (this.f_25598_.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)this.m_6669_())) > (double)0.3f && this.f_25598_.m_9236_().f_46441_.m_188499_()) {
                    this.f_25598_.m_20256_(this.f_25598_.m_20184_().m_82549_(this.f_25598_.m_20154_().m_82542_((double)0.005f, 0.0, (double)0.005f)).m_82520_(0.0, (double)0.082f, 0.0));
                }
                if (this.ticksWaited >= 60) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_25598_.m_9236_(), (Entity)this.f_25598_)) {
                        Level world = this.f_25598_.m_9236_();
                        BlockState state = this.f_25598_.m_9236_().m_8055_(this.f_25602_);
                        boolean changed = false;
                        Block block = state.m_60734_();
                        if (block instanceof CropBlock) {
                            CropBlock crop = (CropBlock)block;
                            int age = crop.m_52305_(state);
                            if (age > 0) {
                                world.m_46597_(this.f_25602_, crop.m_52289_(age - 1));
                                changed = true;
                            }
                        } else if (state.m_60734_() instanceof CropBaseBlock && (Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) > 0) {
                            world.m_46597_(this.f_25602_, (BlockState)state.m_61124_((Property)CropBaseBlock.GROWSTATE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) - 1)));
                            changed = true;
                        }
                        if (changed && world instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)world;
                            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50052_.m_49966_()), this.f_25598_.m_20185_() - (double)0.2f + (double)(world.f_46441_.m_188501_() * 0.4f), this.f_25598_.m_20186_() + (double)0.15f, this.f_25598_.m_20189_() + (double)(world.f_46441_.m_188501_() * 0.4f), 16, (double)0.1f, (double)0.1f, (double)0.1f, 0.5);
                            server.m_6269_(null, (Entity)this.snail, SoundType.f_56740_.m_56775_(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                    }
                    this.m_8041_();
                } else {
                    ++this.ticksWaited;
                }
            }
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }
}

