/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.passive.plant_mite;

import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.entities.passive.snail.SnailEntity;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlantMiteEntity
extends Animal {
    private int sugar = 0;
    private static final int EAT_CD = 1000;
    protected int ticksLastAte;

    public PlantMiteEntity(EntityType<PlantMiteEntity> type, Level world) {
        super((EntityType)ModEntityTypes.PLANT_MITE.get(), world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.ticksLastAte > 0) {
            --this.ticksLastAte;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.sugar > 0) {
            this.m_20000_((ItemLike)Items.f_42501_, this.sugar);
            this.sugar = 0;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.35));
        this.f_21345_.m_25352_(2, (Goal)new InfectCropGoal(this, 1.0, 10, 3));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
    }

    public boolean m_6785_(double p_27598_) {
        return !this.m_21532_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13143_);
    }

    public static AttributeSupplier.Builder createPlantMiteAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    @Nullable
    public SnailEntity getBreedOffspring(ServerLevel world, AgeableMob mob) {
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("lastAte", this.ticksLastAte);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksLastAte = compound.m_128451_("lastAte");
    }

    public static class InfectCropGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 100;
        protected int ticksWaited;
        private final PlantMiteEntity mite;

        public InfectCropGoal(PlantMiteEntity entity, double speed, int hRange, int vRange) {
            super((PathfinderMob)entity, speed, hRange, vRange);
            this.mite = entity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mite.ticksLastAte <= 0 && this.mite.m_9236_().f_46441_.m_188501_() <= 0.75f;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.mite.ticksLastAte <= 0;
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            return world.m_8055_(pos).m_60734_() instanceof CropBaseBlock;
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        public void m_8041_() {
            super.m_8041_();
            this.mite.ticksLastAte = 1000 + this.mite.m_9236_().f_46441_.m_188503_(1000);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                if (this.f_25598_.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)this.m_6669_())) > (double)0.3f && this.f_25598_.m_9236_().f_46441_.m_188499_()) {
                    this.f_25598_.m_20256_(this.f_25598_.m_20184_().m_82549_(this.f_25598_.m_20154_().m_82542_((double)0.005f, 0.0, (double)0.005f)).m_82520_(0.0, (double)0.082f, 0.0));
                }
                if (this.ticksWaited >= 100) {
                    BlockEntity blockEntity = this.f_25598_.m_9236_().m_7702_(this.m_6669_());
                    if (blockEntity instanceof CropsBlockEntity) {
                        CropsBlockEntity crop = (CropsBlockEntity)blockEntity;
                        if (this.f_25598_.m_9236_().f_46441_.m_188501_() <= 0.1f) {
                            crop.setSick(true);
                        } else {
                            this.mite.sugar = Math.min(this.mite.sugar + 1, 4);
                        }
                    }
                    this.m_8041_();
                } else {
                    ++this.ticksWaited;
                }
            }
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }
}

