/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MachineRecipeProvider<R extends Recipe<Container>>
implements DataProvider {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final PackOutput generator;
    protected final String folder;
    protected HashMap<ResourceLocation, R> recipes = new HashMap();

    protected MachineRecipeProvider(PackOutput generator, String folder) {
        this.generator = generator;
        this.folder = "recipes/" + folder;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path resourceRoot = this.generator.m_245114_();
        this.putRecipes();
        ArrayList completables = new ArrayList();
        this.recipes.forEach((key, recipe) -> {
            Path target = this.getPath(resourceRoot, (ResourceLocation)key);
            completables.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.write(recipe), (Path)target));
        });
        return CompletableFuture.allOf(completables.toArray(new CompletableFuture[0]));
    }

    private Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/" + this.folder + "/" + id.m_135815_() + ".json");
    }

    protected JsonObject write(R recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "planttech2:" + this.m_6055_());
        return json;
    }

    protected abstract void putRecipes();

    protected void putAll(R ... recipes) {
        for (R r : recipes) {
            this.put(r);
        }
    }

    protected void put(R recipe) {
        this.recipes.put(recipe.m_6423_(), recipe);
    }

    protected void addItem(JsonObject json, String key, Ingredient ingredient) {
        json.add(key, ingredient.m_43942_());
    }

    protected void addItem(JsonObject json, String key, Item item) {
        this.add(json, key, "item", ForgeRegistries.ITEMS.getKey((Object)item).toString());
    }

    protected void addItem(JsonObject json, String key, ItemStack stack) {
        json.add(key, JsonParser.parseString((String)GSON.toJson((Object)ImmutableMap.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), (Object)"count", (Object)stack.m_41613_()))));
    }

    protected void addWithBiomass(JsonObject json, String key, Item stack, int biomass) {
        json.add(key, JsonParser.parseString((String)GSON.toJson((Object)ImmutableMap.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)stack).toString(), (Object)"biomass", (Object)biomass))));
    }

    protected void addWithBiomass(JsonObject json, String key, Ingredient ingredient, int biomass) {
        json.addProperty("biomass", (Number)biomass);
        json.add(key, ingredient.m_43942_());
    }

    protected void add(JsonObject json, String key, String subKey, String subValue) {
        json.add(key, JsonParser.parseString((String)GSON.toJson((Object)ImmutableMap.of((Object)subKey, (Object)subValue))));
    }
}

