/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import java.util.function.Consumer;
import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemRecipeProvider
extends RecipeProvider {
    private Consumer<FinishedRecipe> cons;

    public ItemRecipeProvider(PackOutput gen) {
        super(gen);
    }

    protected void m_245200_(Consumer<FinishedRecipe> cons) {
        this.cons = cons;
        this.registerHedgeRecipes(cons);
        this.slab((ItemLike)ModBlocks.BROWN_MUSHROOM_SLAB.get(), (ItemLike)Blocks.f_50180_, cons);
        this.slab((ItemLike)ModBlocks.RED_MUSHROOM_SLAB.get(), (ItemLike)Blocks.f_50181_, cons);
        this.slab((ItemLike)ModBlocks.CRIMSON_HYPHAE_SLAB.get(), (ItemLike)Blocks.f_50697_, cons);
        this.slab((ItemLike)ModBlocks.WARPED_HYPHAE_SLAB.get(), (ItemLike)Blocks.f_50688_, cons);
        this.stairs((ItemLike)ModBlocks.BROWN_MUSHROOM_STAIRS.get(), (ItemLike)Blocks.f_50180_, cons);
        this.stairs((ItemLike)ModBlocks.RED_MUSHROOM_STAIRS.get(), (ItemLike)Blocks.f_50181_, cons);
        this.stairs((ItemLike)ModBlocks.CRIMSON_HYPHAE_STAIRS.get(), (ItemLike)Blocks.f_50697_, cons);
        this.stairs((ItemLike)ModBlocks.WARPED_HYPHAE_STAIRS.get(), (ItemLike)Blocks.f_50688_, cons);
        this.trapdoors((ItemLike)ModBlocks.BROWN_MUSHROOM_TRAPDOOR.get(), (ItemLike)Blocks.f_50180_, cons);
        this.trapdoors((ItemLike)ModBlocks.RED_MUSHROOM_TRAPDOOR.get(), (ItemLike)Blocks.f_50181_, cons);
        this.trapdoors((ItemLike)ModBlocks.CRIMSON_HYPHAE_TRAPDOOR.get(), (ItemLike)Blocks.f_50697_, cons);
        this.trapdoors((ItemLike)ModBlocks.WARPED_HYPHAE_TRAPDOOR.get(), (ItemLike)Blocks.f_50688_, cons);
        this.candles((ItemLike)ModBlocks.BROWN_MUSHROOM_CANDLE.get(), (ItemLike)Blocks.f_50180_, cons);
        this.candles((ItemLike)ModBlocks.RED_MUSHROOM_CANDLE.get(), (ItemLike)Blocks.f_50181_, cons);
        this.candles((ItemLike)ModBlocks.CRIMSON_HYPHAE_CANDLE.get(), (ItemLike)Blocks.f_50697_, cons);
        this.candles((ItemLike)ModBlocks.WARPED_HYPHAE_CANDLE.get(), (ItemLike)Blocks.f_50688_, cons);
        this.fence((ItemLike)ModBlocks.BROWN_MUSHROOM_FENCE.get(), (ItemLike)Blocks.f_50180_, cons);
        this.fence((ItemLike)ModBlocks.RED_MUSHROOM_FENCE.get(), (ItemLike)Blocks.f_50181_, cons);
        this.fence((ItemLike)ModBlocks.CRIMSON_HYPHAE_FENCE.get(), (ItemLike)Blocks.f_50697_, cons);
        this.fence((ItemLike)ModBlocks.WARPED_HYPHAE_FENCE.get(), (ItemLike)Blocks.f_50688_, cons);
        this.fenceGate((ItemLike)ModBlocks.BROWN_MUSHROOM_FENCE_GATE.get(), (ItemLike)Blocks.f_50180_, cons);
        this.fenceGate((ItemLike)ModBlocks.RED_MUSHROOM_FENCE_GATE.get(), (ItemLike)Blocks.f_50181_, cons);
        this.fenceGate((ItemLike)ModBlocks.CRIMSON_HYPHAE_FENCE_GATE.get(), (ItemLike)Blocks.f_50697_, cons);
        this.fenceGate((ItemLike)ModBlocks.WARPED_HYPHAE_FENCE_GATE.get(), (ItemLike)Blocks.f_50688_, cons);
        this.tiered("ABA", "BCB", "ABA", ModItems.SOLARFOCUS_TIER_1, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.PLANTIUM_INGOT.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SOLARFOCUS_TIER_2, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SOLARFOCUS_TIER_1.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SOLARFOCUS_TIER_3, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SOLARFOCUS_TIER_2.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SOLARFOCUS_TIER_4, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SOLARFOCUS_TIER_3.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SPEEDUPGRADE_TIER_1, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.PLANTIUM_INGOT.get(), (ItemLike)Items.f_42616_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SPEEDUPGRADE_TIER_2, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SPEEDUPGRADE_TIER_1.get(), (ItemLike)Items.f_42616_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SPEEDUPGRADE_TIER_3, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SPEEDUPGRADE_TIER_2.get(), (ItemLike)Items.f_42616_);
        this.tiered("ABA", "BCB", "ABA", ModItems.SPEEDUPGRADE_TIER_4, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.SPEEDUPGRADE_TIER_3.get(), (ItemLike)Items.f_42616_);
        this.tiered("ABA", "BCB", "ABA", ModItems.CAPACITYUPGRADE_TIER_1, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.PLANTIUM_INGOT.get(), (ItemLike)Items.f_42153_);
        this.tiered("ABA", "BCB", "ABA", ModItems.CAPACITYUPGRADE_TIER_2, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.CAPACITYUPGRADE_TIER_1.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.CAPACITYUPGRADE_TIER_3, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.CAPACITYUPGRADE_TIER_2.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.CAPACITYUPGRADE_TIER_4, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.CAPACITYUPGRADE_TIER_3.get(), (ItemLike)Items.f_42415_);
        this.tiered("ABA", "BCB", "ABA", ModItems.RANGEUPGRADE_TIER_1, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.PLANTIUM_INGOT.get(), (ItemLike)Items.f_42424_);
        this.tiered("ABA", "BCB", "ABA", ModItems.RANGEUPGRADE_TIER_2, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.RANGEUPGRADE_TIER_1.get(), (ItemLike)Items.f_42387_);
        this.tiered("ABA", "BCB", "ABA", ModItems.RANGEUPGRADE_TIER_3, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.RANGEUPGRADE_TIER_2.get(), (ItemLike)Items.f_42434_);
        this.tiered("ABA", "BCB", "ABA", ModItems.RANGEUPGRADE_TIER_4, (ItemLike)Blocks.f_50185_, (ItemLike)ModItems.RANGEUPGRADE_TIER_3.get(), (ItemLike)Items.f_42392_);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.RAKE.get())).m_126130_("III").m_126130_(" P ").m_126130_(" P ").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)ModItems.PLANTIUM_INGOT.get()).m_126132_(ItemRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.PLANTIUM_INGOT.get())), (CriterionTriggerInstance)ItemRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.PLANTIUM_INGOT.get()))).m_176498_(cons);
    }

    private void tiered(String r, String r2, String r3, RegistryObject<Item> item, ItemLike a, ItemLike b, ItemLike c) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).m_126130_(r).m_126130_(r2).m_126130_(r3).m_126127_(Character.valueOf('A'), a).m_126127_(Character.valueOf('B'), b).m_126127_(Character.valueOf('C'), c).m_126132_(ItemRecipeProvider.m_176602_((ItemLike)a), (CriterionTriggerInstance)ItemRecipeProvider.m_125977_((ItemLike)a)).m_176498_(this.cons);
    }

    private void slab(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        this.simple(item, 6, material, builder -> builder.m_126130_("mmm"), cons);
    }

    private void stairs(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        this.simple(item, 4, material, builder -> builder.m_126130_("m  ").m_126130_("mm ").m_126130_("mmm"), cons);
    }

    private void trapdoors(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        this.simple(item, 2, material, builder -> builder.m_126130_("mmm").m_126130_("mmm"), cons);
    }

    private void candles(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        this.shapeless(RecipeCategory.DECORATIONS, item, cons, new ItemLike[]{material, Items.f_151065_});
    }

    private void fence(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)3).m_126130_("wsw").m_126130_("wsw").m_126127_(Character.valueOf('w'), material).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126132_(ForgeRegistries.ITEMS.getKey((Object)material.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{material})).m_176498_(cons);
    }

    private void fenceGate(ItemLike item, ItemLike material, Consumer<FinishedRecipe> cons) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)1).m_126130_("wsw").m_126130_("wsw").m_126127_(Character.valueOf('s'), material).m_206416_(Character.valueOf('w'), Tags.Items.RODS_WOODEN).m_126132_(ForgeRegistries.ITEMS.getKey((Object)material.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{material})).m_176498_(cons);
    }

    private void simple(ItemLike item, int count, ItemLike material, Consumer<ShapedRecipeBuilder> pattern, Consumer<FinishedRecipe> cons) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)count);
        pattern.accept(builder);
        builder.m_126127_(Character.valueOf('m'), material).m_126132_(ForgeRegistries.ITEMS.getKey((Object)material.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{material})).m_176498_(cons);
    }

    private void shapeless(RecipeCategory category, ItemLike item, Consumer<FinishedRecipe> cons, ItemLike ... materials) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)item);
        for (ItemLike material : materials) {
            builder.m_126209_(material);
        }
        ItemLike unlock = materials[0];
        builder.m_126132_(ForgeRegistries.ITEMS.getKey((Object)unlock.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlock})).m_176498_(cons);
    }

    private void registerHedgeRecipes(Consumer<FinishedRecipe> cons) {
        for (RegistryObject<Block> registryObject : ModBlocks.HEDGE_BLOCKS) {
            Hedge block = (Hedge)((Object)registryObject.get());
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, (int)6).m_126130_(" A ").m_126130_(" A ").m_126130_("BCB").m_126127_(Character.valueOf('A'), (ItemLike)block.getLeaves()).m_126127_(Character.valueOf('B'), (ItemLike)block.getWood()).m_126127_(Character.valueOf('C'), (ItemLike)block.getSoil()).m_126132_("leaves", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block.getLeaves()})).m_176498_(cons);
        }
    }

    private void makeTieredAuraCore(ItemLike ingredient, ItemLike ... cores) {
        this.makeAuraCore(cores[0], ingredient, (ItemLike)ModItems.PLANTIUM_INGOT.get(), (ItemLike)ModItems.PLANTIUM_INGOT.get());
        for (int i = 1; i < cores.length; ++i) {
            this.makeAuraCore(cores[i], cores[i - 1], ingredient, cores[i - 1]);
        }
    }

    private void makeAuraCore(ItemLike product, ItemLike middle, ItemLike side) {
        this.makeAuraCore(product, middle, side, middle);
    }

    private void makeAuraCore(ItemLike product, ItemLike middle, ItemLike side, ItemLike criterion) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)product).m_126130_(" S ").m_126130_("SMS").m_126130_(" S ").m_126127_(Character.valueOf('S'), side).m_126127_(Character.valueOf('M'), middle).m_126132_("plantium", (CriterionTriggerInstance)ItemRecipeProvider.m_125977_((ItemLike)criterion)).m_176498_(this.cons);
    }
}

