/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.gson.JsonObject;
import java.util.Map;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.datagen.recipes.MachineRecipeProvider;
import net.kaneka.planttech2.datagen.recipes.RecipeBuilder;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class InfuserRecipesProvider
extends MachineRecipeProvider<InfuserRecipe> {
    public InfuserRecipesProvider(PackOutput generator) {
        super(generator, "infuser");
    }

    @Override
    protected void putRecipes() {
        this.putAll(new InfuserRecipe[]{Builder.create("fertilizer_tier_1", 100).in(Items.f_42499_).out("planttech2:fertilizer_tier_1").build(), Builder.create("fertilizer_tier_2", 200).in((Item)ModItems.FERTILIZER_TIER_1.get()).out("planttech2:fertilizer_tier_2").build(), Builder.create("fertilizer_tier_3", 300).in((Item)ModItems.FERTILIZER_TIER_2.get()).out("planttech2:fertilizer_tier_3").build(), Builder.create("fertilizer_tier_4", 400).in((Item)ModItems.FERTILIZER_TIER_3.get()).out("planttech2:fertilizer_tier_4").build(), Builder.create("gear_dancium_infused", 200).in((Item)ModItems.GEAR_DANCIUM.get()).out("planttech2:gear_dancium_infused").build(), Builder.create("gear_iron_infused", 200).in((Item)ModItems.GEAR_IRON.get()).out("planttech2:gear_iron_infused").build(), Builder.create("gear_kanekium_infused", 200).in((Item)ModItems.GEAR_KANEKIUM.get()).out("planttech2:gear_kanekium_infused").build(), Builder.create("gear_kinnoium_infused", 200).in((Item)ModItems.GEAR_KINNOIUM.get()).out("planttech2:gear_kinnoium_infused").build(), Builder.create("gear_lenthurium_infused", 200).in((Item)ModItems.GEAR_LENTHURIUM.get()).out("planttech2:gear_lenthurium_infused").build(), Builder.create("gear_plantium_infused", 200).in((Item)ModItems.GEAR_PLANTIUM.get()).out("planttech2:gear_plantium_infused").build(), Builder.create("redstone_infused", 250).in(Items.f_42451_).out("planttech2:redstone_infused").build()});
        ((Map)ModItems.CATALYSTS.get()).forEach((item, pair) -> {
            Item ingredient = (Item)pair.getA();
            int level = (Integer)((Pair)pair.getB()).getB();
            this.put(Builder.create(item, 100 * (level + 1)).in(ingredient).out((Item)item).build());
        });
    }

    @Override
    protected JsonObject write(InfuserRecipe recipe) {
        JsonObject json = super.write(recipe);
        this.addWithBiomass(json, "input", recipe.getInput(), recipe.getBiomass());
        this.addItem(json, "result", recipe.m_8043_(null));
        return json;
    }

    public String m_6055_() {
        return "infusing";
    }

    static class Builder
    extends RecipeBuilder {
        private Ingredient input;
        private final int biomass;
        private ItemStack output;

        public static Builder create(String name, int biomass) {
            return new Builder(name, biomass);
        }

        public static Builder create(Item item, int biomass) {
            return new Builder(item, biomass);
        }

        private Builder(Item item, int biomass) {
            this(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), biomass);
        }

        private Builder(String name, int biomass) {
            super(name);
            this.biomass = biomass;
        }

        public Builder in(String input) {
            return this.in(this.getItemFromString(input));
        }

        public Builder in(Item input) {
            this.input = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
            return this;
        }

        public Builder out(String output) {
            return this.out(this.getItemFromString(output));
        }

        public Builder out(Item output) {
            this.output = new ItemStack((ItemLike)output);
            return this;
        }

        public InfuserRecipe build() {
            return new InfuserRecipe(this.id, this.input, this.output, this.biomass);
        }
    }
}

