/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.datagen.recipes.MachineRecipeProvider;
import net.kaneka.planttech2.datagen.recipes.RecipeBuilder;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class CompressorRecipesProvider
extends MachineRecipeProvider<CompressorRecipe> {
    private static CompressorRecipesProvider INSTANCE = null;

    public CompressorRecipesProvider(PackOutput generator) {
        super(generator, "compressor");
        INSTANCE = this;
    }

    @Override
    protected void putRecipes() {
        Builder.create().in(CropTypes.ALLAY_CROP, 8).out(new ItemLike[]{Items.f_151049_}).build();
        Builder.create().in(CropTypes.AMETHYST_CROP, 8).out(new ItemLike[]{Items.f_151049_}).build();
        Builder.create().in(CropTypes.AMETHYST_CROP, 64).out(new ItemLike[]{Items.f_151086_}).build();
        Builder.create().in(CropTypes.BEE_CROP, 12).out(new ItemLike[]{Items.f_42787_}).out(ItemTags.f_13149_).build();
        Builder.create().in(CropTypes.BLAZE_CROP, 8).out(Tags.Items.RODS_BLAZE).build();
        Builder.create().in(CropTypes.CHICKEN_CROP, 8).out(new ItemLike[]{Items.f_42581_}).out(Tags.Items.FEATHERS).build();
        Builder.create().in(CropTypes.COAL_CROP, 8).out(ItemTags.f_13160_).build();
        Builder.create().in(CropTypes.COAL_CROP, 12).out(Tags.Items.ORES_COAL).build();
        Builder.create().in((Item)ModItems.COLOR_PARTICLES.get(), 8).out(Tags.Items.DYES).build();
        Builder.create().in(CropTypes.COPPER_CROP, 8).out(Tags.Items.RAW_MATERIALS_COPPER).build();
        Builder.create().in(CropTypes.COPPER_CROP, 12).out(Tags.Items.ORES_COPPER).build();
        Builder.create().in(CropTypes.COW_CROP, 8).out(new ItemLike[]{Items.f_42579_}).out(Tags.Items.LEATHER).build();
        Builder.create().in(CropTypes.CREEPER_CROP, 8).out(Tags.Items.GUNPOWDER).build();
        Builder.create().in(CropTypes.DANCIUM_CROP, 8).out((ItemLike)ModItems.DANCIUM_INGOT.get()).build();
        Builder.create().in(CropTypes.DIAMOND_CROP, 8).out(Tags.Items.GEMS_DIAMOND).build();
        Builder.create().in(CropTypes.DIAMOND_CROP, 12).out(Tags.Items.ORES_DIAMOND).build();
        Builder.create().in(CropTypes.DIRT_CROP, 8).out(ItemTags.f_198160_).out(new ItemLike[]{Items.f_42276_}).build();
        Builder.create().in(CropTypes.DROWNED_CROP, 8).out(new ItemLike[]{Items.f_42583_}).build();
        Builder.create().in(CropTypes.DROWNED_CROP, 32).out(new ItemLike[]{Items.f_42713_}).build();
        Builder.create().in(CropTypes.EMERALD_CROP, 8).out(Tags.Items.GEMS_EMERALD).build();
        Builder.create().in(CropTypes.EMERALD_CROP, 12).out(Tags.Items.ORES_EMERALD).build();
        Builder.create().in(CropTypes.ENDERDRAGON_CROP, 8).out(new ItemLike[]{Items.f_42735_, Items.f_42104_}).build();
        Builder.create().in(CropTypes.ENDERMAN_CROP, 8).out(Tags.Items.ENDER_PEARLS).build();
        Builder.create().in(CropTypes.ENDSTONE_CROP, 8).out(Tags.Items.END_STONES).build();
        Builder.create().in(CropTypes.FISH_CROP, 8).out(ItemTags.f_13156_).build();
        Builder.create().in(CropTypes.FROG_CROP, 64).out(new ItemLike[]{Blocks.f_220859_, Blocks.f_220861_, Blocks.f_220860_}).build();
        Builder.create().in(CropTypes.GHAST_CROP, 8).out(new ItemLike[]{Items.f_42586_}).build();
        Builder.create().in(CropTypes.GLOWSTONE_CROP, 8).out(new ItemLike[]{Items.f_42054_}).build();
        Builder.create().in(CropTypes.GLOWSTONE_CROP, 2).out(Tags.Items.DUSTS_GLOWSTONE).build();
        Builder.create().in(CropTypes.GOAT_CROP, 32).out(new ItemLike[]{Items.f_220219_}).build();
        Builder.create().in(CropTypes.GOLD_CROP, 8).out(Tags.Items.RAW_MATERIALS_GOLD).build();
        Builder.create().in(CropTypes.GOLD_CROP, 12).out(Tags.Items.ORES_GOLD).build();
        Builder.create().in(CropTypes.GUARDIAN_CROP, 8).out(new ItemLike[]{Items.f_42612_}).build();
        Builder.create().in(CropTypes.HUSK_CROP, 8).out(Tags.Items.INGOTS_IRON).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 24).out(new ItemLike[]{Items.f_42386_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 32).out(new ItemLike[]{Items.f_42471_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 64).out(new ItemLike[]{Items.f_42469_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 40).out(new ItemLike[]{Items.f_42468_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 56).out(new ItemLike[]{Items.f_42470_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 24).out(new ItemLike[]{Items.f_42385_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 8).out(new ItemLike[]{Items.f_42384_}).build();
        Builder.create().in(CropTypes.ILLAGER_CROP, 16).out(new ItemLike[]{Items.f_42383_}).build();
        Builder.create().in(CropTypes.IRON_CROP, 8).out(Tags.Items.RAW_MATERIALS_IRON).build();
        Builder.create().in(CropTypes.IRON_CROP, 12).out(Tags.Items.ORES_IRON).build();
        Builder.create().in(CropTypes.KANEKIUM_CROP, 8).out((ItemLike)ModItems.KANEKIUM_INGOT.get()).build();
        Builder.create().in(CropTypes.KINNOIUM_CROP, 8).out((ItemLike)ModItems.KINNOIUM_INGOT.get()).build();
        Builder.create().in(CropTypes.LAPIS_CROP, 8).out(Tags.Items.GEMS_LAPIS).build();
        Builder.create().in(CropTypes.LAPIS_CROP, 12).out(Tags.Items.ORES_LAPIS).build();
        Builder.create().in(CropTypes.LAVA_CROP, 8).out(new ItemLike[]{Items.f_42448_}).build();
        Builder.create().in(CropTypes.LENTHURIUM_CROP, 8).out((ItemLike)ModItems.LENTHURIUM_INGOT.get()).build();
        Builder.create().in(CropTypes.MAGMA_CUBE_CROP, 8).out(new ItemLike[]{Items.f_42542_}).build();
        Builder.create().in(CropTypes.MYCELIUM_CROP, 8).out(new ItemLike[]{Items.f_42093_}).build();
        Builder.create().in(CropTypes.NETHERRACK_CROP, 8).out(Tags.Items.NETHERRACK).build();
        Builder.create().in(CropTypes.NETHERITE_CROP, 8).out(Tags.Items.INGOTS_NETHERITE).build();
        Builder.create().in(CropTypes.NETHERITE_CROP, 12).out(Tags.Items.ORES_NETHERITE_SCRAP).build();
        Builder.create().in(CropTypes.PARROT_CROP, 8).out((ItemLike)ModItems.COLOR_PARTICLES.get(), 8).out(Tags.Items.FEATHERS).build();
        Builder.create().in(CropTypes.PIG_CROP, 8).out(new ItemLike[]{Items.f_42485_}).build();
        Builder.create().in(CropTypes.PLANTIUM_CROP, 8).out((ItemLike)ModItems.PLANTIUM_INGOT.get()).build();
        Builder.create().in(CropTypes.PRISMARINE_CROP, 8).out(Tags.Items.GEMS_PRISMARINE, Tags.Items.DUSTS_PRISMARINE).build();
        Builder.create().in(CropTypes.QUARTZ_CROP, 8).out(Tags.Items.GEMS_QUARTZ).build();
        Builder.create().in(CropTypes.QUARTZ_CROP, 12).out(Tags.Items.ORES_QUARTZ).build();
        Builder.create().in(CropTypes.RABBIT_CROP, 12).out(new ItemLike[]{Items.f_42649_, Items.f_42648_}).build();
        Builder.create().in(CropTypes.REDSTONE_CROP, 8).out(Tags.Items.DUSTS_REDSTONE).build();
        Builder.create().in(CropTypes.REDSTONE_CROP, 12).out(Tags.Items.ORES_REDSTONE).build();
        Builder.create().in(CropTypes.SAND_CROP, 8).out(Tags.Items.SAND).build();
        Builder.create().in(CropTypes.SAND_CROP, 32).out(Tags.Items.SANDSTONE).build();
        Builder.create().in(CropTypes.SHEEP_CROP, 8).out(new ItemLike[]{Items.f_42658_}).out(ItemTags.f_13167_).build();
        Builder.create().in(CropTypes.SHULKER_CROP, 8).out(new ItemLike[]{Items.f_42748_}).build();
        Builder.create().in(CropTypes.SKELETON_CROP, 8).out(new ItemLike[]{Items.f_42412_}).out(Tags.Items.BONES).build();
        Builder.create().in(CropTypes.SLIME_CROP, 8).out(Tags.Items.SLIMEBALLS).build();
        Builder.create().in(CropTypes.SNOW_CROP, 8).out(new ItemLike[]{Items.f_41980_}).build();
        Builder.create().in(CropTypes.SNOW_CROP, 8).out((ItemLike)Items.f_42452_, 4).build();
        Builder.create().in(CropTypes.SOULSAND_CROP, 8).out(new ItemLike[]{Items.f_42049_}).build();
        Builder.create().in(CropTypes.SPIDER_CROP, 8).out(new ItemLike[]{Items.f_42591_}).out(Tags.Items.STRING).build();
        Builder.create().in(CropTypes.SPONGE_CROP, 8).out(new ItemLike[]{Items.f_41902_}).build();
        Builder.create().in(CropTypes.SQUID_CROP, 8).out(new ItemLike[]{Items.f_42532_}).build();
        Builder.create().in(CropTypes.STONE_CROP, 8).out(Tags.Items.STONE, Tags.Items.COBBLESTONE).build();
        Builder.create().in(CropTypes.STRAY_CROP, 8).out(new ItemLike[]{Items.f_42412_}).out(Tags.Items.BONES).build();
        Builder.create().in(CropTypes.SWEET_BERRIES_CROP, 8).out(new ItemLike[]{Items.f_42780_}).build();
        Builder.create().in(CropTypes.TURTLE_CROP, 64).out(new ItemLike[]{Items.f_42354_}).build();
        Builder.create().in(CropTypes.TURTLE_CROP, 8).out(new ItemLike[]{Items.f_42355_}).build();
        Builder.create().in(CropTypes.VILLAGER_CROP, 8).out(Tags.Items.GEMS_EMERALD).build();
        Builder.create().in(CropTypes.WARDEN_CROP, 8).out(new ItemLike[]{Items.f_220192_, Items.f_220193_}).build();
        Builder.create().in(CropTypes.WARDEN_CROP, 64).out(new ItemLike[]{Items.f_220194_}).build();
        Builder.create().in(CropTypes.WATER_CROP, 8).out(new ItemLike[]{Items.f_42447_}).build();
        Builder.create().in(CropTypes.WITCH_CROP, 8).out(new ItemLike[]{Items.f_42590_}).out(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_GLOWSTONE).build();
        Builder.create().in(CropTypes.WITHER_CROP, 8).out(Tags.Items.NETHER_STARS).build();
        Builder.create().in(CropTypes.WITHER_SKELETON_CROP, 8).out(new ItemLike[]{Items.f_42679_}).build();
        Builder.create().in(CropTypes.WOOD_CROP, 8).out(ItemTags.f_13182_).build();
        Builder.create().in(CropTypes.ZOMBIE_CROP, 8).out(new ItemLike[]{Items.f_42583_}).build();
        Builder.create().in(CropTypes.ZOMBIE_PIGMAN_CROP, 8).out(Tags.Items.NUGGETS_GOLD).build();
        Builder.create().in(CropTypes.ZOMBIE_VILLAGER_CROP, 8).out(Tags.Items.INGOTS_IRON).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_GARDEN.get(), 64).out(new ItemLike[]{Items.f_42715_}).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_BLACK.get(), 16).out(new ItemLike[]{Items.f_42715_}).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_MILK.get(), 12).out(new ItemLike[]{Items.f_42715_}).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_PINK.get(), 6).out(new ItemLike[]{Items.f_42715_}).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_CYBER.get(), 4).out(new ItemLike[]{Items.f_42715_}).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_GARDEN.get(), 1).out((ItemLike)ModItems.SNAIL_SHELL_DUST_GARDEN.get()).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_BLACK.get(), 1).out((ItemLike)ModItems.SNAIL_SHELL_DUST_BLACK.get()).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_MILK.get(), 1).out((ItemLike)ModItems.SNAIL_SHELL_DUST_MILK.get()).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_PINK.get(), 1).out((ItemLike)ModItems.SNAIL_SHELL_DUST_PINK.get()).build();
        Builder.create().in((Item)ModItems.CRACKED_SNAIL_SHELL_CYBER.get(), 1).out((ItemLike)ModItems.SNAIL_SHELL_DUST_CYBER.get()).build();
        for (CropTypes crop : CropTypes.crops()) {
            if (!crop.hasParticle() || Builder.USED.contains((Object)crop) || !crop.getType().hasDefaultProduct()) continue;
            Builder.create().in(crop, 8).build();
        }
    }

    @Override
    protected JsonObject write(CompressorRecipe recipe) {
        JsonObject json = super.write(recipe);
        this.addItem(json, "input", recipe.getInput());
        this.addItem(json, "result", recipe.getOutput());
        return json;
    }

    public String m_6055_() {
        return "compressing";
    }

    static class Builder
    extends RecipeBuilder {
        static List<CropTypes> USED = new ArrayList<CropTypes>();
        private CropTypes crop;
        private ItemStack input;
        private final List<Pair<String, Ingredient>> outputs = new ArrayList<Pair<String, Ingredient>>();

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder() {
            super("");
        }

        private Builder(String name) {
            super(name);
        }

        public Builder in(CropTypes crop) {
            return this.in(crop, 1);
        }

        public Builder in(CropTypes crop, int count) {
            this.crop = crop;
            return this.in(crop.getParticle(), count);
        }

        public Builder in(Item input, int count) {
            return this.in(new ItemStack((ItemLike)input, count));
        }

        private Builder in(ItemStack input) {
            this.input = input;
            return this;
        }

        @SafeVarargs
        public final Builder out(TagKey<Item> ... outputs) {
            for (TagKey<Item> output : outputs) {
                this.outputs.add(Pair.of(output.f_203868_().m_135815_().replace("/", "_"), Ingredient.m_204132_(output)));
            }
            return this;
        }

        public Builder out(ItemLike ... outputs) {
            for (ItemLike output : outputs) {
                this.out(output, 1);
            }
            return this;
        }

        public Builder out(ItemLike output, int count) {
            return this.out(new ItemStack(output, count));
        }

        private Builder out(ItemStack output) {
            this.outputs.add(Pair.of(ForgeRegistries.ITEMS.getKey((Object)output.m_41720_()).m_135815_(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{output})));
            return this;
        }

        public void build() {
            String path = this.path(this.input);
            String inputName = path.replace("_particles", "");
            if (inputName.equals("air")) {
                return;
            }
            if (this.crop != null && !USED.contains((Object)this.crop)) {
                USED.add(this.crop);
                CropTypes.ItemType type = this.crop.getType();
                type.tagKeys(inputName).forEach(xva$0 -> this.out((TagKey<Item>)xva$0));
            }
            for (Pair<String, Ingredient> output : this.outputs) {
                INSTANCE.put(new CompressorRecipe(new ResourceLocation("planttech2", inputName + "-" + output.getA()), this.input, output.getB()));
            }
        }

        private String path(ItemStack stack) {
            return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        }
    }
}

