/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class JsonFileConverter {
    private static final Gson gson = new GsonBuilder().create();

    public static void act() {
    }

    /*
     * WARNING - void declaration
     */
    public static void parseBlockModel(String path) {
        ArrayList<String> output = new ArrayList<String>();
        String filename = path.substring(path.lastIndexOf("/") + 1).replace(".json", "");
        String pathShort = path.replace("planttech2:models/", "").replace(".json", "");
        JsonObject jObj = JsonFileConverter.getJsonObject(path);
        if (jObj != null) {
            output.add("BlockModelBuilder " + filename + " = models().getBuilder(\"" + pathShort + "\")");
            if (jObj.has("parent")) {
                output.add(".parent(\"" + jObj.get("parent").getAsString() + "\")");
            }
            if (jObj.has("textures")) {
                for (Map.Entry entry : jObj.get("textures").getAsJsonObject().entrySet()) {
                    output.add(".texture(\"" + (String)entry.getKey() + "\", \"" + ((JsonElement)entry.getValue()).getAsString() + "\")");
                }
            }
            if (jObj.has("elements")) {
                JsonArray jArr = jObj.get("elements").getAsJsonArray();
                for (JsonElement jsonElement : jArr) {
                    output.add(".element()");
                    JsonObject ele = jsonElement.getAsJsonObject();
                    JsonArray jArrFrom = ele.get("from").getAsJsonArray();
                    Object from = "";
                    for (JsonElement jEleFrom : jArrFrom) {
                        from = (String)from + ", " + jEleFrom.getAsFloat() + "f";
                    }
                    JsonFileConverter.append(output, ".from(" + ((String)from).replaceFirst(", ", "") + ")");
                    JsonArray jArrTo = ele.get("to").getAsJsonArray();
                    Object to = "";
                    for (JsonElement jEleTo : jArrTo) {
                        to = (String)to + ", " + jEleTo.getAsFloat() + "f";
                    }
                    JsonFileConverter.append(output, ".to(" + ((String)to).replaceFirst(", ", "") + ")");
                    if (ele.has("rotation")) {
                        output.add("\t.rotation()");
                        JsonObject rotation = ele.get("rotation").getAsJsonObject();
                        if (rotation.has("angle")) {
                            JsonFileConverter.append(output, ".angle(" + rotation.get("angle").getAsFloat() + "f)");
                        }
                        if (rotation.has("axis")) {
                            JsonFileConverter.append(output, ".axis(Axis.byName(\"" + rotation.get("axis").getAsString() + "\"))");
                        }
                        if (rotation.has("origin")) {
                            JsonArray originArr = rotation.get("origin").getAsJsonArray();
                            Object originStr = "";
                            for (JsonElement origin : originArr) {
                                originStr = (String)originStr + ", " + origin.getAsFloat() + "f";
                            }
                            JsonFileConverter.append(output, ".origin(" + ((String)originStr).replaceFirst(", ", "") + ")");
                        }
                        if (rotation.has("rescale")) {
                            JsonFileConverter.append(output, ".rescale(" + rotation.get("rescale").getAsString() + ")");
                        }
                        JsonFileConverter.append(output, ".end()");
                    }
                    if (ele.has("faces")) {
                        for (Map.Entry entry : ele.get("faces").getAsJsonObject().entrySet()) {
                            output.add("\t.face(Direction.byName(\"" + (String)entry.getKey() + "\"))");
                            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
                            JsonArray uvArr = value.get("uv").getAsJsonArray();
                            Object uvs = "";
                            for (JsonElement uv : uvArr) {
                                uvs = (String)uvs + ", " + uv.getAsFloat() + "f";
                            }
                            JsonFileConverter.append(output, ".uvs(" + ((String)uvs).replaceFirst(", ", "") + ")");
                            if (value.has("rotation")) {
                                int rot = value.get("rotation").getAsInt();
                                switch (rot) {
                                    case 90: {
                                        output.add(".rotation(FaceRotation.CLOCKWISE_90)");
                                    }
                                    case 180: {
                                        output.add(".rotation(FaceRotation.UPSIDE_DOWN)");
                                    }
                                    case 270: {
                                        output.add(".rotation(FaceRotation.COUNTERCLOCKWISE_90)");
                                    }
                                }
                            }
                            if (value.has("texture")) {
                                JsonFileConverter.append(output, ".texture(\"" + value.get("texture").getAsString() + "\")");
                            }
                            if (value.has("tintindex")) {
                                JsonFileConverter.append(output, ".tintindex(" + value.get("tintindex").getAsInt() + ")");
                            }
                            JsonFileConverter.append(output, ".end()");
                        }
                    }
                    JsonFileConverter.append(output, ".end()");
                }
            }
        } else {
            output.add("Missing file: " + path);
        }
        int i = 1;
        for (String string : output) {
            void var7_14;
            void var7_12;
            if (i == output.size()) {
                String string2 = string + ";";
            }
            if (var7_12.startsWith(".") || var7_12.startsWith("\t.")) {
                String string3 = "\t" + (String)var7_12;
            }
            System.out.println((String)var7_14);
            ++i;
        }
    }

    private static void parseItemModel(String path) {
        ArrayList output = new ArrayList();
        String filename = path.substring(path.lastIndexOf("/") + 1).replace(".json", "");
        String pathShort = path.replace("planttech2:models/", "").replace(".json", "");
        JsonObject jObj = JsonFileConverter.getJsonObject(path);
        if (jObj != null) {
            // empty if block
        }
    }

    private static void append(List<String> list, String end) {
        int last = list.size() - 1;
        String s = list.get(last);
        list.set(last, s + end);
    }

    private static JsonObject getJsonObject(String path) {
        try {
            ResourceLocation loc = new ResourceLocation(path);
            InputStream in = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(loc).get()).m_215507_();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            return je.getAsJsonObject();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

