/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.blocks;

import net.kaneka.planttech2.datagen.blocks.BlockModelBase;
import net.kaneka.planttech2.datagen.blocks.BlockStateGenerator;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BuildingBlockModels
extends BlockModelBase {
    BuildingBlockModels(BlockStateGenerator states, ExistingFileHelper fileHelper) {
        super(states, fileHelper);
    }

    @Override
    public void registerStatesAndModels() {
        ResourceLocation redShroom = new ResourceLocation("block/red_mushroom_block");
        this.states.stairsBlock((StairBlock)ModBlocks.RED_MUSHROOM_STAIRS.get(), redShroom);
        this.states.slabBlock((SlabBlock)ModBlocks.RED_MUSHROOM_SLAB.get(), new ResourceLocation("block/red_mushroom_block_inventory"), redShroom);
        this.states.trapdoorBlock((TrapDoorBlock)ModBlocks.RED_MUSHROOM_TRAPDOOR.get(), redShroom, true);
        this.states.fenceGateBlock((FenceGateBlock)ModBlocks.RED_MUSHROOM_FENCE_GATE.get(), redShroom);
        this.states.fenceBlock((FenceBlock)ModBlocks.RED_MUSHROOM_FENCE.get(), redShroom);
        ((BlockModelBuilder)this.states.models().withExistingParent("red_mushroom_fence_inventory", "block/fence_inventory")).texture("texture", redShroom);
        this.candle((Block)ModBlocks.RED_MUSHROOM_CANDLE.get());
        ResourceLocation brownShroom = new ResourceLocation("block/brown_mushroom_block");
        this.states.stairsBlock((StairBlock)ModBlocks.BROWN_MUSHROOM_STAIRS.get(), brownShroom);
        this.states.slabBlock((SlabBlock)ModBlocks.BROWN_MUSHROOM_SLAB.get(), new ResourceLocation("block/brown_mushroom_block_inventory"), brownShroom);
        this.states.trapdoorBlock((TrapDoorBlock)ModBlocks.BROWN_MUSHROOM_TRAPDOOR.get(), brownShroom, true);
        this.states.fenceGateBlock((FenceGateBlock)ModBlocks.BROWN_MUSHROOM_FENCE_GATE.get(), brownShroom);
        this.states.fenceBlock((FenceBlock)ModBlocks.BROWN_MUSHROOM_FENCE.get(), brownShroom);
        ((BlockModelBuilder)this.states.models().withExistingParent("brown_mushroom_fence_inventory", "block/fence_inventory")).texture("texture", brownShroom);
        this.candle((Block)ModBlocks.BROWN_MUSHROOM_CANDLE.get());
        ResourceLocation crimsonHyphae = new ResourceLocation("block/crimson_stem");
        this.states.stairsBlock((StairBlock)ModBlocks.CRIMSON_HYPHAE_STAIRS.get(), crimsonHyphae);
        this.states.slabBlock((SlabBlock)ModBlocks.CRIMSON_HYPHAE_SLAB.get(), new ResourceLocation("block/crimson_hyphae"), crimsonHyphae);
        this.states.trapdoorBlock((TrapDoorBlock)ModBlocks.CRIMSON_HYPHAE_TRAPDOOR.get(), crimsonHyphae, true);
        this.states.fenceGateBlock((FenceGateBlock)ModBlocks.CRIMSON_HYPHAE_FENCE_GATE.get(), crimsonHyphae);
        this.states.fenceBlock((FenceBlock)ModBlocks.CRIMSON_HYPHAE_FENCE.get(), crimsonHyphae);
        ((BlockModelBuilder)this.states.models().withExistingParent("crimson_hyphae_fence_inventory", "block/fence_inventory")).texture("texture", crimsonHyphae);
        this.candle((Block)ModBlocks.CRIMSON_HYPHAE_CANDLE.get());
        ResourceLocation warpedHyphae = new ResourceLocation("block/warped_stem");
        this.states.stairsBlock((StairBlock)ModBlocks.WARPED_HYPHAE_STAIRS.get(), warpedHyphae);
        this.states.slabBlock((SlabBlock)ModBlocks.WARPED_HYPHAE_SLAB.get(), new ResourceLocation("block/warped_hyphae"), warpedHyphae);
        this.states.trapdoorBlock((TrapDoorBlock)ModBlocks.WARPED_HYPHAE_TRAPDOOR.get(), warpedHyphae, true);
        this.states.fenceGateBlock((FenceGateBlock)ModBlocks.WARPED_HYPHAE_FENCE_GATE.get(), warpedHyphae);
        this.states.fenceBlock((FenceBlock)ModBlocks.WARPED_HYPHAE_FENCE.get(), warpedHyphae);
        ((BlockModelBuilder)this.states.models().withExistingParent("warped_hyphae_fence_inventory", "block/fence_inventory")).texture("texture", warpedHyphae);
        this.candle((Block)ModBlocks.WARPED_HYPHAE_CANDLE.get());
    }

    private void candle(Block block) {
        int i = 0;
        while (i < 4) {
            String candles = i == 0 ? "" : (i == 1 ? "_two" : (i == 2 ? "_three" : "_four"));
            String name = "planttech2:block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + candles;
            String template = "minecraft:block/template" + candles + (i > 0 ? "_candles" : "_candle");
            String texture = "planttech2:block/building_blocks/mushrooms/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, template)).texture("all", texture)).texture("particle", texture);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_lit", template)).texture("all", texture + "_lit")).texture("particle", texture + "_lit");
            int count = ++i;
            this.candleState(this.candleState(this.states.getVariantBuilder(block).partialState(), name, count, true).partialState(), name, count, false);
        }
    }

    private VariantBlockStateBuilder.PartialBlockstate candleState(VariantBlockStateBuilder.PartialBlockstate state, String name, int count, boolean lit) {
        return state.with((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(count)).with((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(lit)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)new ModelFile.UncheckedModelFile(name + (lit ? "_lit" : "")))});
    }

    private void simpleBlockItem(Block block, String texturePath) {
        this.simpleBlock(block, texturePath);
        this.blockItem(block, (BlockModelBuilder)this.models().cubeAll("block/building_blocks/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.states.modLoc(texturePath)));
    }

    private void simpleBlock(Block block, String texturePath) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.states.simpleBlock(block, (ModelFile)this.models().cubeAll("block/building_blocks/" + name, this.states.modLoc(texturePath)));
    }

    private void pillarBlock(Block block, String textureSide, String textureTopButtom) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        BlockModelBuilder vertical = (BlockModelBuilder)this.models().cubeColumn("block/building_blocks/" + name, this.states.modLoc(textureSide), this.states.modLoc(textureTopButtom));
        BlockModelBuilder horizontal = (BlockModelBuilder)this.models().cubeColumnHorizontal("block/building_blocks/" + name, this.states.modLoc(textureSide), this.states.modLoc(textureTopButtom));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.states.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(90).addModel();
        this.blockItem(block, vertical);
    }
}

