/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public class Languages
extends LanguageProvider {
    public Languages(PackOutput gen) {
        super(gen, "planttech2", "en_us");
    }

    protected void addTranslations() {
        this.addBlocks();
        this.addHedges();
        this.addCrops();
        this.addGuides();
        this.addGUIs();
        this.addItems();
        this.addItemGroups();
        this.addInfo();
        this.addMisc();
        this.addEntities();
    }

    private void addEntities() {
        this.addEntityType((Supplier)ModEntityTypes.TECH_TRADER, "Plant Tech Trader");
        this.addEntityType((Supplier)ModEntityTypes.SNAIL, "Snail");
        this.addEntityType((Supplier)ModEntityTypes.PLANT_MITE, "Plant Mite");
    }

    protected String forDisplay(String name) {
        String[] s;
        StringBuilder nameBuilder = new StringBuilder(name.length());
        for (String n : s = name.split("_")) {
            n = StringUtils.capitalize((String)n.toLowerCase());
            if (nameBuilder.length() != 0) {
                nameBuilder.append(" ");
            }
            nameBuilder.append(n);
        }
        return nameBuilder.toString();
    }

    private void addMisc() {
        this.add("planttech2.tip.rake", "Efficient tool for killings plant bugs like snails and mites.");
        this.add("planttech2.tip.catalyst", "The catalyst can be applied on crops to increase the chance of the trait increment if available on the next cross-breeding. Catalysts is consumed despite the success of the cross-breeding.");
        this.add("planttech2.tip.catalyst_2", "Trait Type - %s");
        this.add("planttech2.tip.catalyst_3", "Chance Increase - %s");
        this.add("planttech2.block.crop.catalyst_used", "The plant now has increased %d chance to have better %s upon next cross-breeding.");
        this.add("planttech2.block.crop.catalyst_use_exists", "The plant was applied with %s catalyst already.");
        this.add("planttech2.block.crop.catalyst_use_failed", "The plant was applied with maximum catalyst already.");
        this.add((Item)ModItems.RAKE.get(), "Rake");
        this.add((Item)ModItems.CATALYST_ENERGY_VALUE.get(), "Catalyst - Energy Value I");
        this.add((Item)ModItems.CATALYST_ENERGY_VALUE_I.get(), "Catalyst - Energy Value II");
        this.add((Item)ModItems.CATALYST_ENERGY_VALUE_II.get(), "Catalyst - Energy Value III");
        this.add((Item)ModItems.CATALYST_GENE_STRENGTH.get(), "Catalyst - Genetic Strength I");
        this.add((Item)ModItems.CATALYST_GENE_STRENGTH_I.get(), "Catalyst - Genetic Strength II");
        this.add((Item)ModItems.CATALYST_GENE_STRENGTH_II.get(), "Catalyst - Genetic Strength III");
        this.add((Item)ModItems.CATALYST_GROWTH_RATE.get(), "Catalyst - Growth Rate I");
        this.add((Item)ModItems.CATALYST_GROWTH_RATE_I.get(), "Catalyst - Growth Rate II");
        this.add((Item)ModItems.CATALYST_GROWTH_RATE_II.get(), "Catalyst - Growth Rate III");
        this.add((Item)ModItems.CATALYST_TEMPERATURE_TOLERANCE.get(), "Catalyst - Temperature Tolerance I");
        this.add((Item)ModItems.CATALYST_TEMPERATURE_TOLERANCE_I.get(), "Catalyst - Temperature Tolerance II");
        this.add((Item)ModItems.CATALYST_TEMPERATURE_TOLERANCE_II.get(), "Catalyst - Temperature Tolerance III");
        this.add((Item)ModItems.CATALYST_WATER_SENSITIVITY.get(), "Catalyst - Water Sensitivity I");
        this.add((Item)ModItems.CATALYST_WATER_SENSITIVITY_I.get(), "Catalyst - Water Sensitivity II");
        this.add((Item)ModItems.CATALYST_WATER_SENSITIVITY_II.get(), "Catalyst - Water Sensitivity III");
        this.add((Item)ModItems.CRACKED_SNAIL_SHELL_BLACK.get(), "Cracked Black Snail Shell");
        this.add((Item)ModItems.CRACKED_SNAIL_SHELL_CYBER.get(), "Cracked Cyber Snail Shell");
        this.add((Item)ModItems.CRACKED_SNAIL_SHELL_GARDEN.get(), "Cracked Garden Snail Shell");
        this.add((Item)ModItems.CRACKED_SNAIL_SHELL_MILK.get(), "Cracked Milk Snail Shell");
        this.add((Item)ModItems.CRACKED_SNAIL_SHELL_PINK.get(), "Cracked Pink Snail Shell");
        this.add((Item)ModItems.SNAIL_SHELL_DUST_BLACK.get(), "Black Snail Shell Dust");
        this.add((Item)ModItems.SNAIL_SHELL_DUST_CYBER.get(), "Cyber Snail Shell Dust");
        this.add((Item)ModItems.SNAIL_SHELL_DUST_GARDEN.get(), "Garden Snail Shell Dust");
        this.add((Item)ModItems.SNAIL_SHELL_DUST_MILK.get(), "Milk Snail Shell Dust");
        this.add((Item)ModItems.SNAIL_SHELL_DUST_PINK.get(), "Pink Snail Shell Dust");
        for (CropTraitsTypes cropTraitsTypes : CropTraitsTypes.values()) {
            this.add(cropTraitsTypes.getTranslationKey(), this.forDisplay(cropTraitsTypes.getName()));
        }
        for (Enum enum_ : CropTypes.values()) {
            String name = ((CropTypes)enum_).getName();
            String displayName = this.forDisplay(name);
            this.add("item.planttech2." + name + "_seeds", displayName + " Seeds");
            if (((CropTypes)enum_).hasParticle()) {
                this.add("item.planttech2." + name + "_particles", displayName + " Particles");
            }
            this.add(((CropTypes)enum_).translationKey(), enum_ == CropTypes.LILY_OF_THE_VALLEY_CROP ? "Lily of the Valley" : displayName);
        }
        this.add("planttech2.tip.dismantle_by_wrench", "Can be dismantle by wrench.");
        this.add("planttech2.tip.electric_fence", "Can be dismantled by wrench, connect to a powered energy supplier or electric fence to activate.");
        this.add("planttech2.tip.hedge.log", "Log: %s");
        this.add("planttech2.tip.hedge.leaf", "Leaf: %s");
        this.add("planttech2.tip.hedge.soil", "Can be dismantled by wrench.");
        this.add("planttech2.tip.energy_item.no_energy", "No enough energy.");
        this.add("planttech2.tip.energy_item.energy_use", "%d energy per use.");
        this.add("planttech2.tip.advanced_analyser", "Right-click on a crop to analyse its traits.");
        this.add("planttech2.tip.crop_remover", "Right-click on the crop bars to remove crop.");
        this.add("planttech2.tip.analyser.ok", "Everything's well.");
        this.add("planttech2.tip.crop.no_light", "%s requires more light.");
        this.add("planttech2.tip.crop.no_water", "%s requires more water.");
        this.add("planttech2.tip.crop.no_soil", "%s does not like the soil.");
        this.add("planttech2.tip.crop.no_temperature", "%s does not like the temperature.");
        this.add("planttech2.update.available", "An update for PlantTech 2 is available. ");
        this.add("planttech2.update.click", "Click here");
        this.add("planttech2.update.tooltip", "View CurseForge");
        this.add("planttech2.electric_fence.idle", "Electric fence hums");
        this.add("planttech2.crossbreeding", "Crossbreeding");
        this.add("planttech2.infuser", "Infuser");
        this.add("planttech2.compressor", "Compressor");
        this.add("planttech2.chipalyzer", "Chipalyzer");
        this.add("planttech2.carver", "Carver Crop");
        this.add("planttech2.machinebulbreprocessor", "Machinebulb Reprocessor");
        this.add("planttech2.machine_growing", "Growing Machine");
        this.add("config.test", "TEST");
        this.add("fluid.biomass", "Biomass");
        this.add("death.attack.radiation_sickness", "%1$s was infected by radiation sickness");
        this.add("armorinformation.when_worn", "When worn:");
        this.add("armorinformation.selfrepair", "Self-repair");
        this.add("armorinformation.autofeed", "Auto-feed");
        this.add("techvillager.profession.scientist", "Scientist");
        this.add("techvillager.profession.botanist", "Botanist");
        this.add("techvillager.profession.headhunter", "Headhunter");
        this.add("techvillager.profession.engineer", "Engineer");
        this.add("text.biometemperature", "temperature");
        this.add("temp.extreme_cold", "Extremely Cold");
        this.add("temp.cold", "Cold");
        this.add("temp.normal", "Normal");
        this.add("temp.warm", "Warm");
        this.add("temp.extreme_warm", "Extremely Warm");
    }

    private void addItemGroups() {
        this.add("itemGroup.planttech2_main", "General");
        this.add("itemGroup.planttech2_blocks", "Building Blocks");
        this.add("itemGroup.planttech2_seeds", "Seeds");
        this.add("itemGroup.planttech2_machines", "Machines");
        this.add("itemGroup.planttech2_particles", "Particles");
        this.add("itemGroup.planttech2_toolsandarmor", "Tools and Armor");
        this.add("itemGroup.planttech2_chips", "Chips and Upgrades");
    }

    private void addItems() {
        this.add((Item)ModItems.GUIDE_OVERVIEW.get(), "Tablet: PlantTech 2 Guide");
        this.add((Item)ModItems.GUIDE_PLANTS.get(), "Tablet: Plant Encyclopedia");
        this.add((Item)ModItems.GUIDE_GENETIC_ENGINEERING.get(), "Tablet: Genetic Engineering (NO FUNKTION!)");
        this.add((Item)ModItems.ANALYSER.get(), "Analyzer");
        this.add((Item)ModItems.ADVANCED_ANALYSER.get(), "Advanced Analyzer");
        this.add((Item)ModItems.CROPREMOVER.get(), "Crop Remover");
        this.add((Item)ModItems.WRENCH.get(), "Wrench");
        this.add((Item)ModItems.THERMOMETER.get(), "Thermometer");
        this.add((Item)ModItems.SOLARFOCUS_TIER_1.get(), "Class 1 Solar Focus");
        this.add((Item)ModItems.SOLARFOCUS_TIER_2.get(), "Class 2 Solar Focus");
        this.add((Item)ModItems.SOLARFOCUS_TIER_3.get(), "Class 3 Solar Focus");
        this.add((Item)ModItems.SOLARFOCUS_TIER_4.get(), "Class 4 Solar Focus");
        this.add((Item)ModItems.SPEEDUPGRADE_TIER_1.get(), "Speed Upgrade v1.0");
        this.add((Item)ModItems.SPEEDUPGRADE_TIER_2.get(), "Speed Upgrade v2.0");
        this.add((Item)ModItems.SPEEDUPGRADE_TIER_3.get(), "Speed Upgrade v3.0");
        this.add((Item)ModItems.SPEEDUPGRADE_TIER_4.get(), "Speed Upgrade v4.0");
        this.add((Item)ModItems.RANGEUPGRADE_TIER_1.get(), "Range Upgrade v1.0");
        this.add((Item)ModItems.RANGEUPGRADE_TIER_2.get(), "Range Upgrade v2.0");
        this.add((Item)ModItems.RANGEUPGRADE_TIER_3.get(), "Range Upgrade v3.0");
        this.add((Item)ModItems.RANGEUPGRADE_TIER_4.get(), "Range Upgrade v4.0");
        this.add((Item)ModItems.CAPACITYUPGRADE_TIER_1.get(), "Capacity Upgrade v1.0");
        this.add((Item)ModItems.CAPACITYUPGRADE_TIER_2.get(), "Capacity Upgrade v2.0");
        this.add((Item)ModItems.CAPACITYUPGRADE_TIER_3.get(), "Capacity Upgrade v3.0");
        this.add((Item)ModItems.CAPACITYUPGRADE_TIER_4.get(), "Capacity Upgrade v4.0");
        this.add((Item)ModItems.PLANTIUM_INGOT.get(), "Plantium Ingot");
        this.add((Item)ModItems.PLANTIUM_NUGGET.get(), "Plantium Nugget");
        this.add((Item)ModItems.DANCIUM_INGOT.get(), "Dancium Ingot");
        this.add((Item)ModItems.DANCIUM_NUGGET.get(), "Dancium Nugget");
        this.add((Item)ModItems.KANEKIUM_INGOT.get(), "Kanekium Ingot");
        this.add((Item)ModItems.KANEKIUM_NUGGET.get(), "Kanekium Nugget");
        this.add((Item)ModItems.KINNOIUM_INGOT.get(), "Kinnoium Ingot");
        this.add((Item)ModItems.KINNOIUM_NUGGET.get(), "Kinnoium Nugget");
        this.add((Item)ModItems.LENTHURIUM_INGOT.get(), "Lenthurium Ingot");
        this.add((Item)ModItems.LENTHURIUM_NUGGET.get(), "Lenthurium Nugget");
        this.add((Item)ModItems.BIOMASS.get(), "Biomass");
        this.add((Item)ModItems.DNA_CONTAINER_EMPTY.get(), "Empty DNA Container");
        this.add((Item)ModItems.DNA_CONTAINER.get(), "DNA Container");
        this.add((Item)ModItems.FERTILIZER_TIER_1.get(), "G1 Fertilizer");
        this.add((Item)ModItems.FERTILIZER_TIER_2.get(), "G2 Fertilizer");
        this.add((Item)ModItems.FERTILIZER_TIER_3.get(), "G3 Fertilizer");
        this.add((Item)ModItems.FERTILIZER_TIER_4.get(), "G4 Fertilizer");
        this.add((Item)ModItems.FERTILIZER_CREATIVE.get(), "Creative Fertilizer");
        this.add((Item)ModItems.GEAR_KANEKIUM.get(), "Kanekium Gear");
        this.add((Item)ModItems.GEAR_LENTHURIUM.get(), "Lenthurium Gear");
        this.add((Item)ModItems.GEAR_KINNOIUM.get(), "Kinnoium Gear");
        this.add((Item)ModItems.GEAR_DANCIUM.get(), "Dancium Gear");
        this.add((Item)ModItems.GEAR_IRON.get(), "Iron Gear");
        this.add((Item)ModItems.GEAR_PLANTIUM.get(), "Plantium Gear");
        this.add((Item)ModItems.GEAR_KANEKIUM_INFUSED.get(), "Infused Kanekium Gear");
        this.add((Item)ModItems.GEAR_LENTHURIUM_INFUSED.get(), "Infused Lenthurium Gear");
        this.add((Item)ModItems.GEAR_KINNOIUM_INFUSED.get(), "Infused Kinnoium Gear");
        this.add((Item)ModItems.GEAR_DANCIUM_INFUSED.get(), "Infused Dancium Gear");
        this.add((Item)ModItems.GEAR_IRON_INFUSED.get(), "Infused Iron Gear");
        this.add((Item)ModItems.GEAR_PLANTIUM_INFUSED.get(), "Infused Plantium Gear");
        this.add((Item)ModItems.REDSTONE_INFUSED.get(), "Infused Redstone");
        this.add((Item)ModItems.BIOMASSCONTAINER.get(), "Biomass Container");
        this.add((Item)ModItems.ENERGYSTORAGE_TIER_1.get(), "Class 1 Battery");
        this.add((Item)ModItems.ENERGYSTORAGE_TIER_2.get(), "Class 2 Battery");
        this.add((Item)ModItems.ENERGYSTORAGE_TIER_3.get(), "Class 3 Battery");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_0.get(), "Knowledge Chip v0a");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_1.get(), "Knowledge Chip v1.0");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_2.get(), "Knowledge Chip v2.0");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_3.get(), "Knowledge Chip v3.0");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_4.get(), "Knowledge Chip v4.0");
        this.add((Item)ModItems.KNOWLEDGECHIP_TIER_5.get(), "Knowledge Chip v5.0");
        this.add((Item)ModItems.BIOMASS_BUCKET.get(), "Biomass Bucket");
        this.add((Item)ModItems.MACHINEBULBREPROCESSOR_BULB.get(), "Machinebulb Reprocessor Bulb");
        this.add((Item)ModItems.DNA_COMBINER_BULB.get(), "DNA Combiner Bulb");
        this.add((Item)ModItems.DNA_EXTRACTOR_BULB.get(), "DNA Extractor Bulb");
        this.add((Item)ModItems.DNA_REMOVER_BULB.get(), "DNA Remover Bulb");
        this.add((Item)ModItems.DNA_CLEANER_BULB.get(), "DNA Cleaner Bulb");
        this.add((Item)ModItems.CHIPALYZER_BULB.get(), "Chipalyzer Bulb");
        this.add((Item)ModItems.COMPRESSOR_BULB.get(), "Compressor Bulb");
        this.add((Item)ModItems.IDENTIFIER_BULB.get(), "Identifier Bulb");
        this.add((Item)ModItems.INFUSER_BULB.get(), "Infuser Bulb");
        this.add((Item)ModItems.SEEDSQUEEZER_BULB.get(), "Seed Squeezer Bulb");
        this.add((Item)ModItems.SOLARGENERATOR_BULB.get(), "Solar Generator Bulb");
        this.add((Item)ModItems.MEGAFURNACE_BULB.get(), "Megafurnace Bulb");
        this.add((Item)ModItems.PLANTFARM_BULB.get(), "Plantfarm Bulb");
        this.add((Item)ModItems.SEEDCONSTRUCTOR_BULB.get(), "Seed Constructor Bulb");
        this.add((Item)ModItems.ENERGY_SUPPLIER_BULB.get(), "Energy Supplier Bulb");
        this.add((Item)ModItems.CYBERBOW.get(), "CyberBow");
        this.add((Item)ModItems.CYBERDAGGER.get(), "CyberDagger");
        this.add((Item)ModItems.CYBERKATANA.get(), "CyberKatana");
        this.add((Item)ModItems.CYBERRAPIER.get(), "CyberRapier");
        this.add((Item)ModItems.MULTITOOL.get(), "MultiTool");
        this.add((Item)ModItems.CYBERARMOR_HELMET.get(), "CyberArmor Helmet");
        this.add((Item)ModItems.CYBERARMOR_CHEST.get(), "CyberArmor Chest");
        this.add((Item)ModItems.CYBERARMOR_LEGGINGS.get(), "CyberArmor Leggings");
        this.add((Item)ModItems.CYBERARMOR_BOOTS.get(), "CyberArmor Boots");
        this.add((Item)ModItems.EMPTY_UPGRADECHIP_TIER_1.get(), "Blank Upgrade Chip");
        this.add((Item)ModItems.EMPTY_UPGRADECHIP_TIER_2.get(), "v2.0 Chip Upgrade Pack");
        this.add((Item)ModItems.EMPTY_UPGRADECHIP_TIER_3.get(), "v3.0 Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_CAPACITY_1.get(), "v2.0 Capacity Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_CAPACITY_2.get(), "v3.0 Capacity Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_1.get(), "v2.0 Harvest Level Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_2.get(), "v3.0 Harvest Level Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_REACTOR_1.get(), "v2.0 Reactor Chip Upgrade Pack");
        this.add((Item)ModItems.CHIP_UPGRADEPACK_REACTOR_2.get(), "v3.0 Reactor Chip Upgrade Pack");
        this.add((Item)ModItems.CAPACITYCHIP_TIER_1.get(), "Capacity Chip v1.0");
        this.add((Item)ModItems.CAPACITYCHIP_TIER_2.get(), "Capacity Chip v2.0");
        this.add((Item)ModItems.CAPACITYCHIP_TIER_3.get(), "Capacity Chip v3.0");
        this.add((Item)ModItems.HARVESTLEVELCHIP_TIER_1.get(), "Harvest Level Chip v1.0");
        this.add((Item)ModItems.HARVESTLEVELCHIP_TIER_2.get(), "Harvest Level Chip v2.0");
        this.add((Item)ModItems.HARVESTLEVELCHIP_TIER_3.get(), "Harvest Level Chip v3.0");
        this.add((Item)ModItems.ATTACKCHIP_TIER_1.get(), "Attack Chip v1.0");
        this.add((Item)ModItems.ATTACKCHIP_TIER_2.get(), "Attack Chip v2.0");
        this.add((Item)ModItems.ATTACKCHIP_TIER_3.get(), "Attack Chip v3.0");
        this.add((Item)ModItems.BREAKDOWNRATECHIP_TIER_1.get(), "Breakdown Rate Chip v1.0");
        this.add((Item)ModItems.BREAKDOWNRATECHIP_TIER_2.get(), "Breakdown Rate Chip v2.0");
        this.add((Item)ModItems.BREAKDOWNRATECHIP_TIER_3.get(), "Breakdown Rate Chip v3.0");
        this.add((Item)ModItems.ARMORCHIP_TIER_1.get(), "Armor Chip v1.0");
        this.add((Item)ModItems.ARMORCHIP_TIER_2.get(), "Armor Chip v2.0");
        this.add((Item)ModItems.ARMORCHIP_TIER_3.get(), "Armor Chip v3.0");
        this.add((Item)ModItems.TOUGHNESSCHIP_TIER_1.get(), "Toughness Chip v1.0");
        this.add((Item)ModItems.TOUGHNESSCHIP_TIER_2.get(), "Toughness Chip v2.0");
        this.add((Item)ModItems.TOUGHNESSCHIP_TIER_3.get(), "Toughness Chip v3.0");
        this.add((Item)ModItems.ATTACKSPEEDCHIP_TIER_1.get(), "Attack Speed Chip v1.0");
        this.add((Item)ModItems.ATTACKSPEEDCHIP_TIER_2.get(), "Attack Speed Chip v2.0");
        this.add((Item)ModItems.ATTACKSPEEDCHIP_TIER_3.get(), "Attack Speed Chip v3.0");
        this.add((Item)ModItems.REACTORCHIP_TIER_1.get(), "Reactor Chip v1.0");
        this.add((Item)ModItems.REACTORCHIP_TIER_2.get(), "Reactor Chip v2.0");
        this.add((Item)ModItems.REACTORCHIP_TIER_3.get(), "Reactor Chip v3.0");
        this.add((Item)ModItems.UNLOCKCHIP_SHOVEL.get(), "Unlock Chip: Shovel");
        this.add((Item)ModItems.UNLOCKCHIP_AXE.get(), "Unlock Chip: Axe");
        this.add((Item)ModItems.UNLOCKCHIP_SHEARS.get(), "Unlock Chip: Shears");
        this.add((Item)ModItems.UNLOCKCHIP_HOE.get(), "Unlock Chip: Hoe");
        this.add((Item)ModItems.PROTECTION_CHIP.get(), "Protection Chip");
        this.add((Item)ModItems.FIRE_PROTECTION_CHIP.get(), "Fire Protection Chip");
        this.add((Item)ModItems.FEATHER_FALLING_CHIP.get(), "Feather Falling Chip");
        this.add((Item)ModItems.BLAST_PROTECTION_CHIP.get(), "Blast Protection Chip");
        this.add((Item)ModItems.PROJECTILE_PROTECTION_CHIP.get(), "Projectile Protection Chip");
        this.add((Item)ModItems.RESPIRATION_CHIP.get(), "Respiration Chip");
        this.add((Item)ModItems.AQUA_AFFINITY_CHIP.get(), "Aqua Affinity Chip");
        this.add((Item)ModItems.THORNS_CHIP.get(), "Thorns Chip");
        this.add((Item)ModItems.DEPTH_STRIDER_CHIP.get(), "Depth Strider Chip");
        this.add((Item)ModItems.FROST_WALKER_CHIP.get(), "Frost Walker Chip");
        this.add((Item)ModItems.SHARPNESS_CHIP.get(), "Sharpness Chip");
        this.add((Item)ModItems.SMITE_CHIP.get(), "Smite Chip");
        this.add((Item)ModItems.BANE_OF_ARTHROPODS_CHIP.get(), "Bane of Arthropods Chip");
        this.add((Item)ModItems.KNOCKBACK_CHIP.get(), "Knockback Chip");
        this.add((Item)ModItems.FIRE_ASPECT_CHIP.get(), "Fire Aspect Chip");
        this.add((Item)ModItems.LOOTING_CHIP.get(), "Looting Chip");
        this.add((Item)ModItems.SWEEPING_CHIP.get(), "Sweeping Chip");
        this.add((Item)ModItems.EFFICIENCY_CHIP.get(), "Efficiency Chip");
        this.add((Item)ModItems.SILK_TOUCH_CHIP.get(), "Silk Touch Chip");
        this.add((Item)ModItems.UNBREAKING_CHIP.get(), "Unbreaking Chip");
        this.add((Item)ModItems.FORTUNE_CHIP.get(), "Fortune Chip");
        this.add((Item)ModItems.POWER_CHIP.get(), "Power Chip");
        this.add((Item)ModItems.PUNCH_CHIP.get(), "Punch Chip");
        this.add((Item)ModItems.FLAME_CHIP.get(), "Flame Chip");
        this.add((Item)ModItems.INFINITY_CHIP.get(), "Infinity Chip");
    }

    private void addBlocks() {
        this.add((Block)ModBlocks.BIOMASSFLUIDBLOCK.get(), "Biomass Fluid");
        this.add((Block)ModBlocks.CROPBARS.get(), "Cropbars");
        this.add((Block)ModBlocks.IDENTIFIER.get(), "Identifier");
        this.add((Block)ModBlocks.MEGAFURNACE.get(), "Mega Furnace");
        this.add((Block)ModBlocks.SEEDSQUEEZER.get(), "Seed Squeezer");
        this.add((Block)ModBlocks.SOLARGENERATOR.get(), "Solar Generator");
        this.add((Block)ModBlocks.PLANTFARM.get(), "Void-Plantfarm");
        this.add((Block)ModBlocks.PLANTIUM_BLOCK.get(), "Plantium Block");
        this.add((Block)ModBlocks.DANCIUM_BLOCK.get(), "Dancium Block");
        this.add((Block)ModBlocks.KANEKIUM_BLOCK.get(), "Kanekium Block");
        this.add((Block)ModBlocks.KINNOIUM_BLOCK.get(), "Kinnoium Block");
        this.add((Block)ModBlocks.LENTHURIUM_BLOCK.get(), "Lenthurium Block");
        this.add((Block)ModBlocks.UNIVERSAL_SOIL.get(), "Experimental Soil Prototype");
        this.add((Block)ModBlocks.UNIVERSAL_SOIL_INFUSED.get(), "Biomass-Infused OmniSoil");
        this.add((Block)ModBlocks.CABLE.get(), "Cable");
        this.add((Block)ModBlocks.DNA_EXTRACTOR.get(), "DNA Extractor");
        this.add((Block)ModBlocks.DNA_COMBINER.get(), "DNA Combiner");
        this.add((Block)ModBlocks.DNA_REMOVER.get(), "DNA Remover");
        this.add((Block)ModBlocks.DNA_CLEANER.get(), "DNA Cleaner");
        this.add((Block)ModBlocks.SEEDCONSTRUCTOR.get(), "Seed Constructor");
        this.add((Block)ModBlocks.COMPRESSOR.get(), "Compressor");
        this.add((Block)ModBlocks.INFUSER.get(), "Infuser");
        this.add((Block)ModBlocks.CHIPALYZER.get(), "Chipalyzer");
        this.add((Block)ModBlocks.MACHINEBULBREPROCESSOR.get(), "Machinebulb Reprocessor");
        this.add((Block)ModBlocks.MACHINESHELL_IRON.get(), "Iron Machine Shell");
        this.add((Block)ModBlocks.MACHINESHELL_PLANTIUM.get(), "Plantium Machine Shell");
        this.add((Block)ModBlocks.CARVER.get(), "Carver Crop");
        this.add((Block)ModBlocks.ENERGY_SUPPLIER.get(), "Energy Supplier");
        this.add((Block)ModBlocks.ELECTRIC_FENCE.get(), "Electric Fence");
        this.add((Block)ModBlocks.ELECTRIC_FENCE_TOP.get(), "Electric Fence Top");
        this.add((Block)ModBlocks.ELECTRIC_FENCE_GATE.get(), "Electric Fence Gate");
        this.add((Block)ModBlocks.RED_MUSHROOM_STAIRS.get(), "Red Mushroom Stairs");
        this.add((Block)ModBlocks.RED_MUSHROOM_SLAB.get(), "Red Mushroom Slab");
        this.add((Block)ModBlocks.RED_MUSHROOM_TRAPDOOR.get(), "Red Mushroom Trapdoor");
        this.add((Block)ModBlocks.RED_MUSHROOM_FENCE_GATE.get(), "Red Mushroom Fence Gate");
        this.add((Block)ModBlocks.RED_MUSHROOM_FENCE.get(), "Red Mushroom Fence");
        this.add((Block)ModBlocks.RED_MUSHROOM_CANDLE.get(), "Red Mushroom Candle");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_STAIRS.get(), "Brown Mushroom Stairs");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_SLAB.get(), "Brown Mushroom Slab");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_TRAPDOOR.get(), "Brown Mushroom Trapdoor");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_FENCE_GATE.get(), "Brown Mushroom Fence Gate");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_FENCE.get(), "Brown Mushroom Fence");
        this.add((Block)ModBlocks.BROWN_MUSHROOM_CANDLE.get(), "Brown Mushroom Candle");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_STAIRS.get(), "Crimson Hyphae Stairs");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_SLAB.get(), "Crimson Hyphae Slab");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_TRAPDOOR.get(), "Crimson Hyphae Trapdoor");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_FENCE_GATE.get(), "Crimson Hyphae Fence Gate");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_FENCE.get(), "Crimson Hyphae Fence");
        this.add((Block)ModBlocks.CRIMSON_HYPHAE_CANDLE.get(), "Crimson Hyphae Candle");
        this.add((Block)ModBlocks.WARPED_HYPHAE_STAIRS.get(), "Warped Hyphae Stairs");
        this.add((Block)ModBlocks.WARPED_HYPHAE_SLAB.get(), "Warped Hyphae Slab");
        this.add((Block)ModBlocks.WARPED_HYPHAE_TRAPDOOR.get(), "Warped Hyphae Trapdoor");
        this.add((Block)ModBlocks.WARPED_HYPHAE_FENCE_GATE.get(), "Warped Hyphae Fence Gate");
        this.add((Block)ModBlocks.WARPED_HYPHAE_FENCE.get(), "Warped Hyphae Fence");
        this.add((Block)ModBlocks.WARPED_HYPHAE_CANDLE.get(), "Warped Hyphae Candle");
    }

    public void addCrops() {
        this.add((Item)ModItems.COLOR_PARTICLES.get(), "Color Particles");
        HashMap langKeys = new HashMap();
        Map<String, String> crops = Languages.defaultCrops();
        crops.forEach((k, v) -> langKeys.putIfAbsent("crop." + k, v));
    }

    public void addHedges() {
        String[] types = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        String[] soils = new String[]{"dirt", "grass", "podzol"};
        for (String type_1 : types) {
            for (String type_2 : types) {
                for (String soil : soils) {
                    this.add("block.planttech2.hedge_" + type_1 + "_" + type_2 + "_" + soil, "Hedge (" + Languages.capitalize(type_1) + " Leaves/ " + Languages.capitalize(type_2) + " Wood/" + Languages.capitalize(soil) + " Soil)");
                }
            }
        }
    }

    private static String capitalize(String str) {
        return StringUtils.capitalize((String)str.toLowerCase());
    }

    public void addGUIs() {
        this.add("container.megafurnace", "Mega Furnace");
        this.add("container.identifier", "Identifier");
        this.add("container.solargenerator", "Solar Generator");
        this.add("container.seedsqueezer", "Seed Squeezer");
        this.add("container.plantfarm", "Plantfarm");
        this.add("container.dnaextractor", "DNA Extractor");
        this.add("container.dnacombiner", "DNA Combiner");
        this.add("container.dnaremover", "DNA Remover");
        this.add("container.dnacleaner", "DNA Cleaner");
        this.add("container.seedconstructor", "Seed Constructor");
        this.add("container.compressor", "Compressor");
        this.add("container.infuser", "Infuser");
        this.add("container.upgradeableitem", "Upgrade Item");
        this.add("container.chipalyzer", "Chipalyzer");
        this.add("container.planttopia_teleporter", "PlantTopia Teleporter");
        this.add("container.machinebulbreprocessor", "Machinebulb Reprocessor");
        this.add("container.energysupplier", "Energy Supplier");
        this.add("container.cropauragenerator", "Crop Aura Generator");
        this.add("gui.soil", "Soil");
        this.add("gui.seeds", "Seeds");
        this.add("gui.drops", "Drops");
        this.add("gui.temperature", "Temperature");
        this.add("gui.parents", "Parents");
        this.add("gui.non_selected", "Nothing selected");
        this.add("gui.next", "Next");
        this.add("gui.last", "Last");
        this.add("gui.back", "Back");
        this.add("slot.chipalyzer.chipinput", "Insert empty chip");
        this.add("slot.chipalyzer.iteminput", "Insert item to implant in empty chip");
        this.add("slot.compressor.input", "Insert particle and select result");
        this.add("slot.compressor.select", "Select result after placing particle in input slot");
        this.add("slot.dnacleaner.input", "Insert DNA container you want to empty");
        this.add("slot.dnacombiner.container", "Insert DNA container with traits you want to combine");
        this.add("slot.dnacombiner.empty_container", "Insert empty DNA container");
        this.add("slot.dnaextractor.seeds", "Insert seed you want to extract traits from");
        this.add("slot.dnaextractor.empty_container", "Insert empty DNA container");
        this.add("slot.dnaremover.container", "Insert DNA container to remove a single trait");
        this.add("slot.identifier.input", "Insert seeds with unknown traits");
        this.add("slot.infuser.input", "Insert item/block you want to infuse with biomass");
        this.add("slot.megafurnace.input", "Insert item/block you want to smelt");
        this.add("slot.machinebulbreprocessor.input", "Seeds placed here will be reprocessed into a Machinebulb");
        this.add("slot.plantfarm.storage", "Drops of harvested crops will be inserted here");
        this.add("slot.seedconstructor.container", "Insert DNA container to construct a new seed with its traits");
        this.add("slot.seedsqueezer.input", "Insert PlantTech2 seeds that should be squeezed into biomass and energy");
        this.add("slot.seedsqueezer.squeeze", "No input, will automatically pull from input");
        this.add("slot.solargenerator.focus", "Insert focus to start energy production");
        this.add("slot.upgradeableitem.chipslot", "Insert chip to upgrade item");
        this.add("slot.crop_aura_generator.input_0", "Insert Fertility Aura Core");
        this.add("slot.crop_aura_generator.input_1", "Insert Light Value Aura Core");
        this.add("slot.crop_aura_generator.input_2", "Insert Productivity Aura Core");
        this.add("slot.crop_aura_generator.input_3", "Insert Temperature Aura Core");
        this.add("slot.util.speedupgrade", "Insert Speed Upgrade to speed up the process");
        this.add("slot.util.rangeupgrade", "Insert Range Upgrade to increase the production");
        this.add("slot.util.capacityupgrade", "Insert Capacity Upgrade to increase the energy storage");
        this.add("slot.util.knowledgechip", "Insert Knowledge Chip to collect knowledge while machine is active (limited by the tier of the machine)");
        this.add("slot.util.output", "Output slot");
        this.add("slot.util.fluidin", "Insert biomass container to insert biomass");
        this.add("slot.util.fluidout", "Insert biomass container to extract biomass");
        this.add("slot.util.energyin", "Insert item with energy to charge this machine");
        this.add("slot.util.energyout", "Insert item with energy to charge the item");
    }

    public void addGuides() {
        this.addGuide("header", "PlantTech 2 Guide");
        this.addGuide("crossbreeding.menu", "Crossbreeding");
        this.addGuide("machines.menu", "Machines");
        this.addGuide("genetic_engineering.menu", "Genetic Engineering");
        this.addGuide("general_crossbreeding.header", "General");
        this.addGuide("getting_started.header", "Getting started");
        this.addGuide("crop_not_growing.header", "Crop is not growing?");
        this.addGuide("multiply_crops_seeds.header", "How to multiply crops/seeds");
        this.addGuide("how_to_crossbreed.header", "How to crossbreed");
        this.addGuide("autoreplanting.header", "Auto-replanting");
        this.addGuide("croptraits.header", "Crop traits");
        this.addGuide("identify_traits.header", "Identify traits");
        this.addGuide("fertilizer.header", "Fertilizer");
        this.addGuide("genetic_engineering_crops.header", "Genetic engineering crops");
        this.addGuide("general_genetic_engineering.header", "General");
        this.addGuide("extracting_genes.header", "Extracting genes");
        this.addGuide("purifying_genes.header", "Purifying genes");
        this.addGuide("combining_genes.header", "Combining genes");
        this.addGuide("cleaning_containers.header", "Cleaning containers");
        this.addGuide("creating_designerseeds.header", "Creating designer seeds");
        this.addGuide("general_machines.header", "General");
        this.addGuide("chipalyzer.header", "Chipalyzer");
        this.addGuide("compressor.header", "Compressor");
        this.addGuide("dna_cleaner.header", "DNA Cleaner");
        this.addGuide("dna_combiner.header", "DNA Combiner");
        this.addGuide("dna_extractor.header", "DNA Extractor");
        this.addGuide("dna_remover.header", "DNA Remover");
        this.addGuide("energy_supplier.header", "Energy Supplier");
        this.addGuide("identifier.header", "Identifier");
        this.addGuide("infuser.header", "Infuser");
        this.addGuide("machinebulb_reprocessor.header", "Machinebulb Reprocessor");
        this.addGuide("mega_furnace.header", "Mega Furnace");
        this.addGuide("void_plantfarm.header", "Void Plantfarm");
        this.addGuide("seedconstructor.header", "Seed Constructor");
        this.addGuide("seed_squeezer.header", "Seed Squeezer");
        this.addGuide("solar_generator.header", "Solar Generator");
        this.addGuide("general_crossbreeding.text", "Crossbreeding is the key for renewable resources. But before starting there is some important information: <br> <br> - PlantTech 2 crops act different then vanilla crops. They share some behavior, but not all. <br> - The crops have traits that can be improved with crossbreeding, but most of the base traits are considerably worse than vanilla - however, if properly tended they can be much more efficient. <br> <br> Example: In the beginning plants will need a water source to be 1 block away, but through crossbreeding they can potentially thrive with water as far as 9 blocks away. <br> <br> Please refer to the 'Crop traits' section of the Guide for detailed information. <br> <br> **Also be advised that Bonemeal does not work on PlantTech 2 crops (see Fertilizer)");
        this.addGuide("getting_started.text", "To start your career as a crossbreeder, you just need cropbars <br> (crafting: 4 sticks in 2x2 square) and a vanilla seed (or plantium nugget). Place the cropbars and right-click with the seeds on the cropbars, and if conditions are right the crop will grow. (If not, have a look at the next chapter.)");
        this.addGuide("crop_not_growing.text", "The easiest way to check, if the conditions are matched, is using the analyser. Just right-click on the crop and you will get a message with every condition that is not matched. <br>  The conditions are: <br> <br> - Water source near enough <br> - Light level high enough <br> - Right soil <br> - Right temperature");
        this.addGuide("multiply_crops_seeds.text", "When fully grown on a cropbar, plants will spread to an empty cropbar that is immediately adjacent. This is the easiest way to multiply your stock of seeds without increasing any traits, and if the original seed was identified the traits of the new plant will also be known (provided the result was not a crossbreed; see the next chapter). Once the Fertility trait increases, extra seeds may begin to drop when a crop is harvested.");
        this.addGuide("how_to_crossbreed.text", "When trying to get better traits - or new crop types - you need to crossbreed. This happens when a fully-grown plant spreads onto an empty cropbar that is next to another plant. The selection of the new traits/type is random with the following logic: <br> <br> Type: If the parent crops are different but have a matching crossbreed result, there is a small chance the new plant will be of that type. <br> <br> Traits: For each trait, the traits of the parents are compared. If they are equal, there is a small chance the trait will increased by one. Otherwise, the traits of the new crop will be in range of the parents' traits. <br> <br> The traits of a crossbred crop are always unknown and will need to be revealed with the Identifier machine.");
        this.addGuide("autoreplanting.text", "All crops in PlantTech 2 are auto-replanted; right-clicking to harvest the crops when fully grown will generate any drops and reset the plant to the seedling state. Until the Fertility trait is increased this will usually result in no extra seed drops, as a seed was needed for replanting.");
        this.addGuide("croptraits.text", " **Growth Rate** <br>     - Minimum level: 0 <br>    - Maximum level: 10 <br>     - Reduce the amount of time needed for the crop to grow. <br>    - Time per Stage = 90s - level * 6 <br> <br> **Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level 10 <br>    - Not yet implemented. <br> <br>  **Light Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 14 <br>    - Defines the minimum light level needed for the plant to grow. <br>    - Minimum needed lightlevel = 14 - level <br> <br>  **Water Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 8 <br>    - Defines the max distance from water that that the crop will be able to grow. <br>    - Distance = 1 + level <br> <br>  **Temperature Tolerance** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 4 <br>    - Allows the crop to grow in temperatures outside of its native climate. <br>    - Allowed temperature = default temperature +- level <br> <br> <br> <br> <br> <br> **Productivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 5 <br>    - Increases the amount of products dropped <br> <br>  **Fertility** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 5 <br>    - Increases the amount of seeds dropped <br> <br>  **Spreading Speed** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 10 <br>    - Not yet implemented <br> <br> <br> **Gene Strength** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 10 <br>    - Not yet implemented <br> <br>  **Energy Value** <br> <br>    - Minimum level: 1 <br>    - Maximum level: 10 <br>    - Increases the amount of energy produced in the seed squeezer <br>    - Energy = level * 20");
        this.addGuide("identify_traits.text", "The identifier is a machine that uses energy to identify the unknown traits of crops. <br> Just put the seeds with the unknown traits in the correct slot and the seeds will be identified in a bit. <br> For more information, have a look at \"Machines: Identifier.\"");
        this.addGuide("fertilizer.text", "Bonemeal does not work on PlantTech 2 crops. Instead, Fertilizer must be created by infusing Bonemeal with biomass (in the Infuser machine). There are 4 tiers of fertilizer, which may be upgraded in the Infuser as well. <br> <br> Fertilizer has a chance of advancing the growth of the crop it is used on by one stage, from 5% at Tier 1 to 75% at Tier 4.");
        this.addGuide("genetic_engineering_crops.text", "To make the life a bit easier, it is possible to extract genes of crops and make seeds with these genes. <br> This process is a bridge between the way of crossbreeding and the way of PlantTechian. <br> You find more information in the main category 'Genetic Engineering'");
        this.addGuide("general_genetic_engineering.text", "Genetic engineering is a way to create crops with selected traits. These traits need to be found first but could be used as much as you want. So, start crossbreeding your crops and develop the traits you like to have.");
        this.addGuide("extracting_genes.text", "Once you got traits you want to keep, you need to extract the whole DNA sequence. <br> Therefore, put a seed with traits and an empty DNA container in the DNA extractor. You will obtain a DNA container with the whole DNA sequence; the seed will be destroyed in the process.");
        this.addGuide("purifying_genes.text", "There will be times when you want to remove a gene entirely from a DNA sequence - this can be accomplished by placing the DNA container into the DNA Remover machine. A single gene will be selected randomly and removed from the sequence - it's not possible to select which one, so don't mess around when you only have a single container left. <br> In this way you can isolate a single gene.");
        this.addGuide("combining_genes.text", "DNA containers can be combined in the DNA combiner. Through this process the DNA sequences will be mixed, with the lower values being dominant. (There is no dominant crop type however; that will be selected at random.) The used DNA containers will not be consumed, so this can be an effective way to backup a DNA sequence as you attempt to isolate a gene.");
        this.addGuide("cleaning_containers.text", "Useless DNA containers can be cleaned up for reuse, by placing them in the DNA cleaner.");
        this.addGuide("creating_designerseeds.text", "Now the last step in getting personalized seeds is to put a DNA container and 500 biomass in the Seed Constructor. <br> Biomass is produced by the Seed Squeezer - the same stuff used in the Machinebulb Reprocessor. Again, the used DNA container will not be consumed. <br> All traits that are not present in the DNA container will be reset to their initial value. The default crop type is Carrot, and for the traits have a look at \"Crossbreeding: Crop traits\"");
        this.addGuide("test.text", Strings.repeat((String)"XX ", (int)675));
        this.addGuide("general_machines.text", "Machines in PlantTech 2 aren't just blocks that can be placed, they are complex symbioses of metal and plants. Therefore the process of obtaining the machines is more complex than you may be used to. <br> First of all the machines need a machine shell appropriate for the tier of the machine - lower tier machines need an iron machine shell, with higher tiers requiring a machine shell made from plantium. To obtain the machine shell, you need to place an Iron Block or Plantium Block next to a Carver Crop and wait. <br>  For the plant part you need the machinebulb of the desired machine. A Machinebulb Reprocessor is required for most of these, as well as a Seed Squeezer as a bioenergy source. (These two machinebulbs are the only ones that are obtainable by crafting.) When clicking on the correct machine shell with a bulb the machine will start growing and once finished, the machine is ready. <br> The Machinebulb Reprocessor requires a Knowledge Chip to access higher tiers of machinebulbs. This Chip collects information from machines while they're running, as long as the machine is not a lower tier than the chip. (To start, a Knowledge Chip v0.1 may be used in a Seed Squeezer, a Tier 0 machine.) Once the Knowledge Chip has collected enough information, it may be used in the Machinebulb Reprocessor to get better machinebulbs. (And the Knowledge Chip will only gain useful data from the new Tier 1 machines.)");
        this.addGuide("chipalyzer.text", "The Chipalyzer can analyze various items and record the data on Blank Upgrade Chips. The resulting chips can be slotted into PlantTech2 equipment to enhance its capabilities. (Some effects are stackable; refer to each chip's tooltip for more info.) Some of these chips can also be upgraded; the following pages will have more on this. <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> These chips are upgradeable with standard Chip Upgrade Packs. <br> <br> Attack Chip: Iron Sword <br> Attack Speed Chip: Golden Sword <br> <br> Armor Chip: Iron Chestplate <br> Toughness Chip: Diamond Chestplate <br> <br> Breakdown Rate Chip: Golden Pickaxe <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> This set of chips is upgradeable with their own special Upgrade Packs. <br> <br> Capacity Chip: Battery (0.5kBE) <br> Reactor Chip: Solar Focus MkI <br> Harvestlevel Chip: Wooden Pickaxe <br> Harvest Level Chip: Diamond Pickaxe <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> The following chips are used to unlock additional right-click functions for the Multi-Tool. They are not upgradeable. <br> <br> Unlock Chip (Axe): Iron Axe <br> Unlock Chip (Hoe): Iron Hoe <br> Unlock Chip (Shears): Shears <br> Unlock Chip (Shovel): Iron Shovel <br> <br> <br> It is also possible to program Upgrade Chips with Enchantment data. These do not have multiple levels (so don't waste a Fortune III - you'll get a Fortune I chip), but the effects are stackable with multiple chips.");
        this.addGuide("compressor.text", "The Compressor converts crop particles into items. Some particles have more multiple options.");
        this.addGuide("dna_cleaner.text", "The DNA Cleaner sanitizes used DNA containers and prepares them for reuse.");
        this.addGuide("dna_combiner.text", "The DNA Combiner combines two sequences of DNA (lower values are dominant). The used sample sequences are not lost.");
        this.addGuide("dna_extractor.text", "The DNA Extractor stores the DNA sequence of a crop seed into an empty DNA container. This process destroys the seed.");
        this.addGuide("dna_remover.text", "The DNA Remover removes a single trait, selected randomly. Should be used to reduce the sequence to only good traits.");
        this.addGuide("energy_supplier.text", "The Energy Supplier does what the names says, it supplies energy for blocks like electric fences.");
        this.addGuide("identifier.text", "The Identifier is used to identify crop traits. It can also be used to convert vanilla seeds into PlantTech 2 seeds.");
        this.addGuide("infuser.text", "The Infuser infuses biomass into things like bonemeal to obtain fertilizer.");
        this.addGuide("machinebulb_reprocessor.text", "Takes energy and biomass to produce Machinebulbs. Available Machinebulbs are limited by the Knowledge Chip installed. Energy needed for each bulb: 1000.        Biomass needed: Compressor, Identifier, Energy Supplier -> 100; Infuser, Chipalyzer, Mega Furnace -> 1000; DNA Cleaner, DNA Combiner, DNA Extractor, DNA Remover, Seed Constructor, Void-Plantfarm, Solar Generator -> 2000;");
        this.addGuide("mega_furnace.text", "Powered with BE and has 6 slots for smelting.");
        this.addGuide("void_plantfarm.text", "You want to have cropproducts but don't want to have a farm consume your space? The void plantfarm takes a seed and will plant and farm the crops in the void dimension! It consumes energy to create a portal once it can harvest a crop and the production can be increased by putting a rangeupgrade in it! We can't access the dimension in person, but the machine can.");
        this.addGuide("seedconstructor.text", "The seedconstructor takes a sequence of dna, energy and biomass to creates seeds from it. The sequence will not be consumed. If a trait is not set in the sequence, it will be set to the default value.");
        this.addGuide("seed_squeezer.text", "The seed squeezer is a power generator fuelled by PlantTech2 seeds. The amount of power generated is determined by the seed's energy trait. Biomass is also produced, albeit at a fixed rate.");
        this.addGuide("solar_generator.text", "The solar generator needs a solar focus to produce energy. The higher the tier of the focus, the higher the production.");
    }

    private void addInfo() {
        this.addInfo("knowledge", "Knowledge");
        this.addInfo("tier", "Tier");
        this.addInfo("type", "Crop Type");
        this.addInfo("soil", "Soil");
        this.addInfo("grow_speed", "Growth Rate");
        this.addInfo("sensitivity", "Sensitivity");
        this.addInfo("needed_light_level", "Light Level Required");
        this.addInfo("water_range", "Water Range");
        this.addInfo("temperature", "Temperature");
        this.addInfo("temperature_tolerance", "Temperature Tolerance");
        this.addInfo("productivity", "Productivity");
        this.addInfo("fertility", "Fertility");
        this.addInfo("spreading_speed", "Spreading Speed");
        this.addInfo("gene_strength", "Gene Strength");
        this.addInfo("energy_value", "Energy Value");
        this.addInfo("unknown", "Unknown");
        this.addInfo("only_creative", "Only for Creative Mode.");
        this.addInfo("only_seeds", "Only for PlantTech 2 seeds.");
        this.addInfo("no_space", "Not enough space in your inventory.");
        this.addInfo("not_a_trait", "Not a trait.");
        this.addInfo("fertilizer", "Chance");
        this.addInfo("fertilizer_creative", "Ignores requirements");
        this.addInfo("energy", "energy: %s");
        this.addInfo("energycosts", "energycosts per action: %s");
        this.addInfo("openwithshift", "Shift-rightclick to open inventory");
        this.addInfo("upgradechip.increasecapacity", "+%s energy capacity per chip");
        this.addInfo("upgradechip.increasecapacitymax", "Max energy capacity: %s");
        this.addInfo("upgradechip.energyproduction", "+%s energy production per chip");
        this.addInfo("upgradechip.increaseharvestlevel", "Max energy production: %s");
        this.addInfo("upgradechip.increasearmor", "+%s armor per chip");
        this.addInfo("upgradechip.increaseattack", "+%s attack per chip");
        this.addInfo("upgradechip.increaseattackmax", "Max attack: %s ");
        this.addInfo("upgradechip.increaseattackspeed", "+%s attack speed per chip");
        this.addInfo("upgradechip.increaseattackspeedmax", "Max attack speed: %s");
        this.addInfo("upgradechip.increasebreakdownrate", "+%s breakdown rate per chip");
        this.addInfo("upgradechip.increasebreakdownratemax", "Max breakdown rate: %s");
        this.addInfo("upgradechip.increasetougness", "+%s toughness per chip");
        this.addInfo("upgradechip.increasetougnessmax", "Max toughness: %s");
        this.addInfo("upgradechip.unlockaxefeat", "Unlocks axe features");
        this.addInfo("upgradechip.unlockshovelfeat", "Unlocks shovel features");
        this.addInfo("upgradechip.unlockshearsfeat", "Unlocks shears features");
        this.addInfo("upgradechip.unlockhoefeat", "Unlocks hoe features");
        this.addInfo("upgradechip.energycosts", "+%s energy costs per chip");
        this.addInfo("upgradechip.add", "Add");
        this.addInfo("upgradechip.stackable", "Enchantment can be stacked");
        this.addInfo("any_enchanted_item", "Any item with this enchantment. Level doesn`t matter");
        this.addInfo("wrench_cable", "Right-click cable connections to toggle");
        this.addInfo("wrench_dismantle", "Right-click while sneaking to dismantle PlantTech2 machines and cables");
    }

    public static Map<String, String> defaultCrops() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"abyssalnite", (Object)"Abyssalnite");
        map.put((Object)"adamantine", (Object)"Adamantine");
        map.put((Object)"allium", (Object)"Allium");
        map.put((Object)"aluminum", (Object)"Aluminum");
        map.put((Object)"aluminum_brass", (Object)"Aluminum Brass");
        map.put((Object)"alumite", (Object)"Alumite");
        map.put((Object)"amber", (Object)"Amber");
        map.put((Object)"apatite", (Object)"Apatite");
        map.put((Object)"aquamarine", (Object)"Aquamarine");
        map.put((Object)"ardite", (Object)"Ardite");
        map.put((Object)"awakened_draconium", (Object)"Awakened Draconium");
        map.put((Object)"azure_bluet", (Object)"Azure Bluet");
        map.put((Object)"bamboo", (Object)"Bamboo");
        map.put((Object)"basalt", (Object)"Basalt");
        map.put((Object)"beast", (Object)"Ravager");
        map.put((Object)"beetroots", (Object)"Beetroots");
        map.put((Object)"black_quartz", (Object)"Black Quartz");
        map.put((Object)"blaze", (Object)"Blaze");
        map.put((Object)"blitz", (Object)"Blitz");
        map.put((Object)"blizz", (Object)"Blizz");
        map.put((Object)"blue_topaz", (Object)"Blue Topaz");
        map.put((Object)"blue_orchid", (Object)"Blue Orchid");
        map.put((Object)"brass", (Object)"Brass");
        map.put((Object)"bronze", (Object)"Bronze");
        map.put((Object)"cactus", (Object)"Cactus");
        map.put((Object)"carrot", (Object)"Carrot");
        map.put((Object)"certus_quartz", (Object)"Certus Quartz");
        map.put((Object)"chicken", (Object)"Chicken");
        map.put((Object)"chimerite", (Object)"Chimerite");
        map.put((Object)"chorus", (Object)"Chorus");
        map.put((Object)"chrome", (Object)"Chrome");
        map.put((Object)"coal", (Object)"Coal");
        map.put((Object)"cobalt", (Object)"Cobalt");
        map.put((Object)"cocoa_bean", (Object)"Cocoa Bean");
        map.put((Object)"cold_iron", (Object)"Cold Iron");
        map.put((Object)"compressed_iron", (Object)"Compressed Iron");
        map.put((Object)"conductive_iron", (Object)"Conductive Iron");
        map.put((Object)"constantan", (Object)"Constantan");
        map.put((Object)"copper", (Object)"Copper");
        map.put((Object)"coralium", (Object)"Coralium");
        map.put((Object)"cornflower", (Object)"Cornflower");
        map.put((Object)"cow", (Object)"Cow");
        map.put((Object)"creeper", (Object)"Creeper");
        map.put((Object)"dancium", (Object)"Dancium");
        map.put((Object)"dandelion", (Object)"Dandelion");
        map.put((Object)"dark_gem", (Object)"Dark Gem");
        map.put((Object)"dark_steel", (Object)"Dark Steel");
        map.put((Object)"desh", (Object)"Desh");
        map.put((Object)"diamond", (Object)"Diamond");
        map.put((Object)"dirt", (Object)"Dirt");
        map.put((Object)"draconium", (Object)"Draconium");
        map.put((Object)"dreadium", (Object)"Dreadium");
        map.put((Object)"drowned", (Object)"Drowned");
        map.put((Object)"electrical_steel", (Object)"Electrical Steel");
        map.put((Object)"electrotine", (Object)"Electrotine");
        map.put((Object)"electrum", (Object)"Electrum");
        map.put((Object)"elementium", (Object)"Elementium");
        map.put((Object)"emerald", (Object)"Emerald");
        map.put((Object)"end_steel", (Object)"End Steel");
        map.put((Object)"ender_amethyst", (Object)"Ender Amethyst");
        map.put((Object)"ender_biotite", (Object)"Ender Biotite");
        map.put((Object)"enderdragon", (Object)"Enderdragon");
        map.put((Object)"enderium", (Object)"Enderium");
        map.put((Object)"enderman", (Object)"Enderman");
        map.put((Object)"endstone", (Object)"Endstone");
        map.put((Object)"energetic_alloy", (Object)"Energetic Alloy");
        map.put((Object)"fish", (Object)"Fish");
        map.put((Object)"fluix_crystal", (Object)"Fluix Crystal");
        map.put((Object)"fluxed_electrum", (Object)"Fluxed Electrum");
        map.put((Object)"ghast", (Object)"Ghast");
        map.put((Object)"glowstone", (Object)"Glowstone");
        map.put((Object)"glowstone_ingot", (Object)"Glowstone Ingot");
        map.put((Object)"gold", (Object)"Gold");
        map.put((Object)"graphite", (Object)"Graphite");
        map.put((Object)"guardian", (Object)"Guardian");
        map.put((Object)"husk", (Object)"Husk");
        map.put((Object)"illager", (Object)"Illager");
        map.put((Object)"invar", (Object)"Invar");
        map.put((Object)"iridium", (Object)"Iridium");
        map.put((Object)"iron", (Object)"Iron");
        map.put((Object)"kanekium", (Object)"Kanekium");
        map.put((Object)"kelp", (Object)"Kelp");
        map.put((Object)"kinnoium", (Object)"Kinnoium");
        map.put((Object)"knightslime", (Object)"Knightslime");
        map.put((Object)"lapis", (Object)"Lapis");
        map.put((Object)"lava", (Object)"Lava");
        map.put((Object)"lead", (Object)"Lead");
        map.put((Object)"lenthurium", (Object)"Lenthurium");
        map.put((Object)"lilly_of_the_valley", (Object)"Lily Of The Valley");
        map.put((Object)"lithium", (Object)"Lithium");
        map.put((Object)"lumium", (Object)"Lumium");
        map.put((Object)"magma_cube", (Object)"Magma Cube");
        map.put((Object)"magnesium", (Object)"Magnesium");
        map.put((Object)"malachite", (Object)"Malachite");
        map.put((Object)"manasteel", (Object)"Manasteel");
        map.put((Object)"manyullyn", (Object)"Manyullyn");
        map.put((Object)"melon", (Object)"Melon");
        map.put((Object)"meteoric_iron", (Object)"Meteoric Iron");
        map.put((Object)"mithril", (Object)"Mithril");
        map.put((Object)"moonstone", (Object)"Moonstone");
        map.put((Object)"mooshroom", (Object)"Mooshroom");
        map.put((Object)"mushroom", (Object)"Mushroom");
        map.put((Object)"mycelium", (Object)"Mycelium");
        map.put((Object)"nether_wart", (Object)"Nether Wart");
        map.put((Object)"netherrack", (Object)"Netherrack");
        map.put((Object)"neutronium", (Object)"Neutronium");
        map.put((Object)"nickel", (Object)"Nickel");
        map.put((Object)"octine", (Object)"Octine");
        map.put((Object)"orange_tulip", (Object)"Orange Tulip");
        map.put((Object)"osmium", (Object)"Osmium");
        map.put((Object)"oxeye_daisy", (Object)"Oxeye Daisy");
        map.put((Object)"panda", (Object)"Panda");
        map.put((Object)"parrot", (Object)"Parrot");
        map.put((Object)"peridot", (Object)"Peridot");
        map.put((Object)"pig", (Object)"Pig");
        map.put((Object)"pink_tulip", (Object)"Pink Tulip");
        map.put((Object)"plantium", (Object)"Plantium");
        map.put((Object)"platinum", (Object)"Platinum");
        map.put((Object)"polarbear", (Object)"Polarbear");
        map.put((Object)"poppy", (Object)"Poppy");
        map.put((Object)"potato", (Object)"Potato");
        map.put((Object)"prismarine", (Object)"Prismarine");
        map.put((Object)"pulsating_iron", (Object)"Pulsating Iron");
        map.put((Object)"pumpkin", (Object)"Pumpkin");
        map.put((Object)"quartz", (Object)"Quartz");
        map.put((Object)"quicksilver", (Object)"Quicksilver");
        map.put((Object)"red_tulip", (Object)"Red Tulip");
        map.put((Object)"redstone", (Object)"Redstone");
        map.put((Object)"redstone_alloy", (Object)"Redstone Alloy");
        map.put((Object)"refined_obsidian", (Object)"Refined Obsidian");
        map.put((Object)"rock_crystal", (Object)"Rock Crystal");
        map.put((Object)"rubber", (Object)"Rubber");
        map.put((Object)"ruby", (Object)"Ruby");
        map.put((Object)"saltpeter", (Object)"Saltpeter");
        map.put((Object)"sand", (Object)"Sand");
        map.put((Object)"sapphire", (Object)"Sapphire");
        map.put((Object)"sheep", (Object)"Sheep");
        map.put((Object)"shulker", (Object)"Shulker");
        map.put((Object)"signalum", (Object)"Signalum");
        map.put((Object)"silicon", (Object)"Silicon");
        map.put((Object)"silver", (Object)"Silver");
        map.put((Object)"skeleton", (Object)"Skeleton");
        map.put((Object)"sky_stone", (Object)"Sky Stone");
        map.put((Object)"slate", (Object)"Slate");
        map.put((Object)"slime", (Object)"Slime");
        map.put((Object)"slimy_bone", (Object)"Slimy Bone");
        map.put((Object)"snow", (Object)"Snow");
        map.put((Object)"soularium", (Object)"Soularium");
        map.put((Object)"soulsand", (Object)"Soulsand");
        map.put((Object)"spider", (Object)"Spider");
        map.put((Object)"sponge", (Object)"Sponge");
        map.put((Object)"squid", (Object)"Squid");
        map.put((Object)"star_steel", (Object)"Star Steel");
        map.put((Object)"starmetal", (Object)"Starmetal");
        map.put((Object)"steel", (Object)"Steel");
        map.put((Object)"stone", (Object)"Stone");
        map.put((Object)"stray", (Object)"Stray");
        map.put((Object)"sugarcane", (Object)"Sugarcane");
        map.put((Object)"sulfur", (Object)"Sulfur");
        map.put((Object)"sunstone", (Object)"Sunstone");
        map.put((Object)"syrmorite", (Object)"Syrmorite");
        map.put((Object)"tanzanite", (Object)"Tanzanite");
        map.put((Object)"terrasteel", (Object)"Terrasteel");
        map.put((Object)"thaumium", (Object)"Thaumium");
        map.put((Object)"tin", (Object)"Tin");
        map.put((Object)"titanium", (Object)"Titanium");
        map.put((Object)"topaz", (Object)"Topaz");
        map.put((Object)"tungsten", (Object)"Tungsten");
        map.put((Object)"turtle", (Object)"Turtle");
        map.put((Object)"uranium", (Object)"Uranium");
        map.put((Object)"valonite", (Object)"Valonite");
        map.put((Object)"vibrant_alloy", (Object)"Vibrant Alloy");
        map.put((Object)"villager", (Object)"Villager");
        map.put((Object)"vine", (Object)"Vine");
        map.put((Object)"vinteum", (Object)"Vinteum");
        map.put((Object)"void_metal", (Object)"Void Metal");
        map.put((Object)"water", (Object)"Water");
        map.put((Object)"wheat", (Object)"Wheat");
        map.put((Object)"white_tulip", (Object)"White Tulip");
        map.put((Object)"witch", (Object)"Witch");
        map.put((Object)"wither", (Object)"Wither");
        map.put((Object)"wither_rose", (Object)"Wither Rose");
        map.put((Object)"wither_skeleton", (Object)"Wither Skeleton");
        map.put((Object)"wood", (Object)"Wood");
        map.put((Object)"yellorium", (Object)"Yellorium");
        map.put((Object)"zinc", (Object)"Zinc");
        map.put((Object)"zombie", (Object)"Zombie");
        map.put((Object)"zombie_pigman", (Object)"Zombie Pigman");
        map.put((Object)"zombie_villager", (Object)"Zombie Villager");
        return map.build();
    }

    public void addInfo(String key, String value) {
        this.add("planttech2.info." + key, value);
    }

    public void addGuide(String key, String value) {
        this.add("guide", key, value);
    }

    public void add(String category, String subKey, String value) {
        this.add(category + ".planttech2" + (String)(!subKey.isEmpty() ? "." + subKey : ""), value);
    }
}

