/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import java.util.Map;
import javax.annotation.Nullable;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTClientUtil;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModels
extends ItemModelProvider {
    protected final ResourceLocation generated = this.mcLoc("generated");
    protected final ResourceLocation handheld = this.mcLoc("handheld");

    public ItemModels(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "planttech2", existingFileHelper);
    }

    protected void registerModels() {
        this.addCrops();
        this.addBulbs();
        this.addBiomassContainer();
        this.addChipsUpgrades();
        this.singleTexturedItem((ItemLike)ModItems.RAKE.get());
        ((Map)ModItems.CATALYSTS.get()).keySet().forEach(this::singleTexturedItem);
        this.singleTexturedItem((ItemLike)ModItems.CRACKED_SNAIL_SHELL_BLACK.get());
        this.singleTexturedItem((ItemLike)ModItems.CRACKED_SNAIL_SHELL_CYBER.get());
        this.singleTexturedItem((ItemLike)ModItems.CRACKED_SNAIL_SHELL_GARDEN.get());
        this.singleTexturedItem((ItemLike)ModItems.CRACKED_SNAIL_SHELL_MILK.get());
        this.singleTexturedItem((ItemLike)ModItems.CRACKED_SNAIL_SHELL_PINK.get());
        this.singleTexturedItem((ItemLike)ModItems.SNAIL_SHELL_DUST_BLACK.get());
        this.singleTexturedItem((ItemLike)ModItems.SNAIL_SHELL_DUST_CYBER.get());
        this.singleTexturedItem((ItemLike)ModItems.SNAIL_SHELL_DUST_GARDEN.get());
        this.singleTexturedItem((ItemLike)ModItems.SNAIL_SHELL_DUST_MILK.get());
        this.singleTexturedItem((ItemLike)ModItems.SNAIL_SHELL_DUST_PINK.get());
        this.singleTexturedItem((ItemLike)ModItems.ADVANCED_ANALYSER.get());
        this.singleTexturedItem((ItemLike)ModItems.ANALYSER.get());
        this.singleTexturedItem((ItemLike)ModItems.BIOMASS.get());
        this.singleTexturedItem((ItemLike)ModItems.BIOMASS_BUCKET.get());
        this.singleTexture("cable", this.generated, "layer0", this.itemPrefix("cable"));
        this.singleTexturedItem((ItemLike)ModItems.COLOR_PARTICLES.get());
        this.singleTexturedItem((ItemLike)ModItems.CROPREMOVER.get());
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_BOOTS.get(), "armor/cyberarmor_boots");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_CHEST.get(), "armor/cyberarmor_chest");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_HELMET.get(), "armor/cyberarmor_helmet");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_LEGGINGS.get(), "armor/cyberarmor_leggings");
        this.singleTexturedItem((ItemLike)ModItems.CYBERDAGGER.get(), this.handheld, "weapons/cyberdagger");
        this.singleTexturedItem((ItemLike)ModItems.CYBERKATANA.get(), this.handheld, "weapons/cyberkatana");
        this.singleTexturedItem((ItemLike)ModItems.CYBERRAPIER.get(), this.handheld, "weapons/cyberrapier");
        this.singleTexturedItem((ItemLike)ModItems.DANCIUM_INGOT.get());
        this.singleTexturedItem((ItemLike)ModItems.DANCIUM_NUGGET.get());
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_1.get());
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_2.get());
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_3.get());
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_1.get(), "fert_1");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_2.get(), "fert_2");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_3.get(), "fert_3");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_4.get(), "fert_4");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_CREATIVE.get(), "fert_creative");
        this.singleTexturedItem((ItemLike)ModItems.KANEKIUM_INGOT.get());
        this.singleTexturedItem((ItemLike)ModItems.KANEKIUM_NUGGET.get());
        this.singleTexturedItem((ItemLike)ModItems.KINNOIUM_INGOT.get());
        this.singleTexturedItem((ItemLike)ModItems.KINNOIUM_NUGGET.get());
        this.singleTexturedItem((ItemLike)ModItems.LENTHURIUM_INGOT.get());
        this.singleTexturedItem((ItemLike)ModItems.LENTHURIUM_NUGGET.get());
        this.singleTexturedItem((ItemLike)ModItems.PLANTIUM_INGOT.get());
        this.singleTexturedItem((ItemLike)ModItems.PLANTIUM_NUGGET.get());
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_1.get());
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_2.get());
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_3.get());
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_4.get());
        this.singleTexturedItem((ItemLike)ModItems.REDSTONE_INFUSED.get());
        this.singleTexturedItem((ItemLike)ModItems.TESTITEM.get(), this.mcLoc("item/barrier"));
        for (int i = 0; i < 5; ++i) {
            this.singleTexture("thermometer_" + i, this.mcLoc("item/generated"), "layer0", new ResourceLocation("planttech2", "item/thermometer_" + i));
        }
    }

    private void addCrops() {
        ResourceLocation seedsTexture = this.itemPrefix("seeds");
        ResourceLocation particlesTexture = this.itemPrefix("particles");
        CropTypes.crops().forEach(entry -> {
            String name = entry.getName();
            this.singleTexture(name + "_seeds", this.generated, "layer0", seedsTexture);
            if (entry.hasParticle()) {
                this.singleTexture(name + "_particles", this.generated, "layer0", particlesTexture);
            }
        });
    }

    private void addBiomassContainer() {
        String basePath = ForgeRegistries.ITEMS.getKey((Object)((Item)ModItems.BIOMASSCONTAINER.get())).m_135815_();
        ItemModelBuilder baseContainerItem = (ItemModelBuilder)this.withExistingParent(basePath, this.generated);
        ItemModelBuilder empty = (ItemModelBuilder)this.withExistingParent(basePath + "_empty", this.generated);
        baseContainerItem.override().predicate(PTClientUtil.FILLED_PREDICATE, 0.0f).model((ModelFile)empty);
        baseContainerItem.texture("layer0", this.itemPrefix("biomasscontainer_empty"));
        empty.texture("layer0", this.itemPrefix("biomasscontainer_empty"));
        int max = 9;
        for (int i = 0; i < max; ++i) {
            ItemModelBuilder override = (ItemModelBuilder)this.withExistingParent(basePath + "_" + i, this.generated);
            override.texture("layer0", this.itemPrefix("biomasscontainer_" + i));
            baseContainerItem.override().predicate(PTClientUtil.FILLED_PREDICATE, (float)i + 1.0f).model((ModelFile)override);
        }
    }

    private void addChipsUpgrades() {
        this.singleTexturedItem((ItemLike)ModItems.AQUA_AFFINITY_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_1.get(), "chips/armor_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_2.get(), "chips/armor_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_3.get(), "chips/armor_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_1.get(), "chips/attack_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_2.get(), "chips/attack_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_3.get(), "chips/attack_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_1.get(), "chips/attackspeed_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_2.get(), "chips/attackspeed_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_3.get(), "chips/attackspeed_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.BLAST_PROTECTION_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.BANE_OF_ARTHROPODS_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_1.get(), "chips/harvestspeed_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_2.get(), "chips/harvestspeed_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_3.get(), "chips/harvestspeed_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_1.get(), "chips/capacity_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_2.get(), "chips/capacity_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_3.get(), "chips/capacity_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_1.get());
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_2.get());
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_3.get());
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_4.get());
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_CAPACITY_1.get(), "chips/upgradepack/capacity_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_CAPACITY_2.get(), "chips/upgradepack/capacity_2");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_1.get(), "chips/upgradepack/harvestlevel_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_2.get(), "chips/upgradepack/harvestlevel_2");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_REACTOR_1.get(), "chips/upgradepack/reactor_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_REACTOR_2.get(), "chips/upgradepack/reactor_2");
        this.singleTexturedItem((ItemLike)ModItems.DEPTH_STRIDER_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.EFFICIENCY_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_1.get(), "chips/template_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_2.get(), "chips/template_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_3.get(), "chips/template_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.FEATHER_FALLING_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FIRE_ASPECT_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FIRE_PROTECTION_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FLAME_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FORTUNE_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FROST_WALKER_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_1.get(), "chips/harvestlevel_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_2.get(), "chips/harvestlevel_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_3.get(), "chips/harvestlevel_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.INFINITY_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.KNOCKBACK_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_0.get());
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_1.get());
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_2.get());
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_3.get());
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_4.get());
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_5.get());
        this.singleTexturedItem((ItemLike)ModItems.LOOTING_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.POWER_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PROJECTILE_PROTECTION_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PROTECTION_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PUNCH_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_1.get(), "chips/reactor_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_2.get(), "chips/reactor_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_3.get(), "chips/reactor_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.RESPIRATION_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SHARPNESS_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SILK_TOUCH_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SMITE_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_1.get(), "solarfocus_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_2.get(), "solarfocus_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_3.get(), "solarfocus_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_4.get(), "solarfocus_tier_4");
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_1.get());
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_2.get());
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_3.get());
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_4.get());
        this.singleTexturedItem((ItemLike)ModItems.SWEEPING_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.THORNS_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_1.get(), "chips/toughness_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_2.get(), "chips/toughness_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_3.get(), "chips/toughness_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.UNBREAKING_CHIP.get(), "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_AXE.get(), "chips/axe");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_HOE.get(), "chips/hoe");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_SHEARS.get(), "chips/shears");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_SHOVEL.get(), "chips/shovel");
    }

    private void addBulbs() {
        this.bulbItem("chipalyzer");
        this.bulbItem("compressor");
        this.bulbItem("crop_aura_generator");
        this.bulbItem("dna_cleaner");
        this.bulbItem("dna_combiner");
        this.bulbItem("dna_extractor");
        this.bulbItem("dna_remover");
        this.bulbItem("energy_supplier");
        this.bulbItem("identifier");
        this.bulbItem("infuser");
        this.bulbItem("machinebulbreprocessor");
        this.bulbItem("mega_furnace");
        this.bulbItem("plantfarm");
        this.bulbItem("seedconstructor");
        this.bulbItem("seedsqueezer");
        this.bulbItem("solargenerator");
    }

    private void bulbItem(String item) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item + "_bulb", this.generated);
        model.texture("layer0", this.itemPrefix("machinebulbs/machinebulb_layer_1"));
        model.texture("layer1", this.itemPrefix("machinebulbs/machinebulb_layer_2_" + item));
    }

    private void singleTexturedItem(ItemLike item) {
        this.singleTexturedItem(item, (ResourceLocation)null);
    }

    private void singleTexturedItem(ItemLike item, String texturePath) {
        this.singleTexturedItem(item, this.generated, texturePath);
    }

    private void singleTexturedItem(ItemLike item, ResourceLocation parent, String texturePath) {
        this.singleTexturedItem(item, parent, this.itemPrefix(texturePath));
    }

    private void singleTexturedItem(ItemLike item, @Nullable ResourceLocation textureLocation) {
        this.singleTexturedItem(item, this.generated, textureLocation);
    }

    private void singleTexturedItem(ItemLike item, ResourceLocation parent, @Nullable ResourceLocation textureLocation) {
        ResourceLocation loc = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        if (textureLocation == null) {
            textureLocation = this.itemLoc(loc, "");
        }
        this.singleTexture(loc.m_135815_(), parent, "layer0", textureLocation);
    }

    private ResourceLocation itemLoc(ResourceLocation loc, String subPath) {
        return new ResourceLocation(loc.m_135827_(), "item/" + subPath + loc.m_135815_());
    }

    private ResourceLocation itemPrefix(String path) {
        return new ResourceLocation("planttech2", "item/" + path);
    }
}

