/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "planttech2", existingFileHelper);
    }

    protected void registerModels() {
        this.block((Block)ModBlocks.RED_MUSHROOM_STAIRS.get());
        this.block((Block)ModBlocks.RED_MUSHROOM_SLAB.get());
        this.trapdoorItem((Block)ModBlocks.RED_MUSHROOM_TRAPDOOR.get());
        this.block((Block)ModBlocks.RED_MUSHROOM_FENCE_GATE.get());
        this.fenceItem((Block)ModBlocks.RED_MUSHROOM_FENCE.get());
        this.generated((Block)ModBlocks.RED_MUSHROOM_CANDLE.get());
        this.block((Block)ModBlocks.BROWN_MUSHROOM_STAIRS.get());
        this.block((Block)ModBlocks.BROWN_MUSHROOM_SLAB.get());
        this.trapdoorItem((Block)ModBlocks.BROWN_MUSHROOM_TRAPDOOR.get());
        this.block((Block)ModBlocks.BROWN_MUSHROOM_FENCE_GATE.get());
        this.fenceItem((Block)ModBlocks.BROWN_MUSHROOM_FENCE.get());
        this.generated((Block)ModBlocks.BROWN_MUSHROOM_CANDLE.get());
        this.block((Block)ModBlocks.CRIMSON_HYPHAE_STAIRS.get());
        this.block((Block)ModBlocks.CRIMSON_HYPHAE_SLAB.get());
        this.trapdoorItem((Block)ModBlocks.CRIMSON_HYPHAE_TRAPDOOR.get());
        this.block((Block)ModBlocks.CRIMSON_HYPHAE_FENCE_GATE.get());
        this.fenceItem((Block)ModBlocks.CRIMSON_HYPHAE_FENCE.get());
        this.generated((Block)ModBlocks.CRIMSON_HYPHAE_CANDLE.get());
        this.block((Block)ModBlocks.WARPED_HYPHAE_STAIRS.get());
        this.block((Block)ModBlocks.WARPED_HYPHAE_SLAB.get());
        this.trapdoorItem((Block)ModBlocks.WARPED_HYPHAE_TRAPDOOR.get());
        this.block((Block)ModBlocks.WARPED_HYPHAE_FENCE_GATE.get());
        this.fenceItem((Block)ModBlocks.WARPED_HYPHAE_FENCE.get());
        this.generated((Block)ModBlocks.WARPED_HYPHAE_CANDLE.get());
    }

    private void trapdoorItem(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.withExistingParent(name, this.modLoc("block/" + name) + "_bottom");
    }

    private void fenceItem(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.withExistingParent(name, this.modLoc("block/" + name) + "_inventory");
    }

    private void registerBlockModels() {
        for (RegistryObject<Block> registryObject : ModBlocks.HEDGE_BLOCKS) {
            this.blockHedge((Block)registryObject.get());
        }
    }

    private void generatedItemModel(String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    private void generated(Block b) {
        this.generatedItemModel(ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_());
    }

    private void block(Block b) {
        this.block(b, this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_()));
    }

    private void block(Block b, ResourceLocation parent) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_(), parent);
    }

    private void buildingBlock(Block b) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_(), this.modLoc("block/building_blocks/" + ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_()));
    }

    private void blockHedge(Block b) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_(), this.modLoc("block/hedge/" + ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_().replace("hedge_", "") + "_base"));
    }

    public String m_6055_() {
        return " planttech2 item model generator";
    }
}

