/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import net.kaneka.planttech2.crops.CropConfigProvider;
import net.kaneka.planttech2.datagen.ItemModelGenerator;
import net.kaneka.planttech2.datagen.ItemModels;
import net.kaneka.planttech2.datagen.Languages;
import net.kaneka.planttech2.datagen.blocks.BlockStateGenerator;
import net.kaneka.planttech2.datagen.loot.PT2LootTables;
import net.kaneka.planttech2.datagen.recipes.ChipalyzerRecipesProvider;
import net.kaneka.planttech2.datagen.recipes.CompressorRecipesProvider;
import net.kaneka.planttech2.datagen.recipes.InfuserRecipesProvider;
import net.kaneka.planttech2.datagen.recipes.ItemRecipeProvider;
import net.kaneka.planttech2.datagen.tags.BlockTagGenerator;
import net.kaneka.planttech2.datagen.tags.EntityTagGenerator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="planttech2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        generator.addProvider(client, (DataProvider)new Languages(output));
        generator.addProvider(client, (DataProvider)new BlockStateGenerator(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new ItemModels(output, existingFileHelper));
        generator.addProvider(client, (DataProvider)new ItemModelGenerator(output, existingFileHelper));
        generator.addProvider(server, (DataProvider)new ItemRecipeProvider(output));
        generator.addProvider(server, (DataProvider)new PT2LootTables(output));
        generator.addProvider(server, (DataProvider)new CropConfigProvider(output));
        generator.addProvider(server, (DataProvider)new CompressorRecipesProvider(output));
        generator.addProvider(server, (DataProvider)new ChipalyzerRecipesProvider(output));
        generator.addProvider(server, (DataProvider)new InfuserRecipesProvider(output));
        generator.addProvider(server, (DataProvider)new BlockTagGenerator(output, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(server, (DataProvider)new EntityTagGenerator(output, event.getLookupProvider(), existingFileHelper));
    }
}

