/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class TemperatureTolerance
extends Pair<Float, Float>
implements ISerializable {
    public static final float MIN = -0.7f;
    public static final float MAX = 2.0f;
    public static final float RANGE = 2.7f;
    public static final TemperatureTolerance DEFAULT = TemperatureTolerance.of(0.0f, 0.0f);
    public static final TemperatureTolerance EXTREME_COLD = TemperatureTolerance.of(-0.7f, 0.1f);
    public static final TemperatureTolerance COLD = TemperatureTolerance.of(0.1f, 0.41f);
    public static final TemperatureTolerance NORMAL = TemperatureTolerance.of(0.41f, 0.65f);
    public static final TemperatureTolerance WARM = TemperatureTolerance.of(0.65f, 1.5f);
    public static final TemperatureTolerance EXTREME_WARM = TemperatureTolerance.of(1.5f, 2.0f);

    public static TemperatureTolerance of(float min, float max) {
        return new TemperatureTolerance(Float.valueOf(min), Float.valueOf(max));
    }

    public static TemperatureTolerance fromNBT(CompoundTag compound) {
        TemperatureTolerance t = new TemperatureTolerance();
        t.deserializeNBT(compound);
        return t;
    }

    public TemperatureTolerance() {
        this(Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    protected TemperatureTolerance(Float aFloat, Float aFloat2) {
        super(aFloat, aFloat2);
    }

    public boolean inRange(float temp) {
        return this.inRange(temp, 0.0f);
    }

    public boolean inRange(float temp, float extraTolerance) {
        return temp >= ((Float)this.getA()).floatValue() - extraTolerance && temp <= ((Float)this.getB()).floatValue() + extraTolerance;
    }

    public float getMinTempTolerancePercent() {
        return this.getAbsMinTempTolerance() / 2.7f;
    }

    public float getMaxTempTolerancePercent() {
        return this.getAbsMaxTempTolerance() / 2.7f;
    }

    public float getMinTempTolerance() {
        return ((Float)this.getA()).floatValue();
    }

    public float getMaxTempTolerance() {
        return ((Float)this.getB()).floatValue();
    }

    public float getAbsMinTempTolerance() {
        return ((Float)this.getA()).floatValue() - -0.7f;
    }

    public float getAbsMaxTempTolerance() {
        return ((Float)this.getB()).floatValue() - -0.7f;
    }

    public TemperatureTolerance copy() {
        return TemperatureTolerance.of(this.getMinTempTolerance(), this.getMaxTempTolerance());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("minTempTolerance", ((Float)this.getA()).floatValue());
        compound.m_128350_("maxTempTolerance", ((Float)this.getB()).floatValue());
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.setA(Float.valueOf(nbt.m_128457_("minTempTolerance")));
        this.setB(Float.valueOf(nbt.m_128457_("maxTempTolerance")));
    }

    @Override
    public void extraToNetwork(FriendlyByteBuf buf) {
        ISerializable.super.extraToNetwork(buf);
    }

    @Override
    public void extraFromNetwork(FriendlyByteBuf buf) {
        ISerializable.super.extraFromNetwork(buf);
    }

    public String getDisplayString(int extraTolerence) {
        return this.getDisplayString() + (String)(extraTolerence == 0 ? "" : " (+-" + String.format("%.2f", Float.valueOf((float)extraTolerence / 4.0f)) + ")");
    }

    public String getDisplayString() {
        return String.format("%.2f ~ %.2f", this.getA(), this.getB());
    }
}

