/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.BiPredicate;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class ParentPair
extends Pair<String, String>
implements BiPredicate<CropTypes, CropTypes>,
ISerializable {
    private final float mutationChance;

    public static ParentPair of(CompoundTag compound) {
        return new ParentPair(compound.m_128461_("parent1"), compound.m_128461_("parent2"), compound.m_128457_("mutation"));
    }

    public static ParentPair of(String firstParent, String secondParent, float mutationChance) {
        return new ParentPair(firstParent, secondParent, mutationChance);
    }

    private ParentPair(String parent1, String parent2, float mutationChance) {
        super(parent1, parent2);
        this.mutationChance = mutationChance;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("parent1", (String)this.getA());
        compound.m_128359_("parent2", (String)this.getB());
        compound.m_128350_("mutation", this.mutationChance);
        return compound;
    }

    @Override
    public boolean test(CropTypes parent1, CropTypes parent2) {
        return this.testExact(parent1, parent2) || this.testExact(parent2, parent1);
    }

    private boolean testExact(CropTypes parent1, CropTypes parent2) {
        return this.getFirstParent() == parent1 && this.getSecondParent() == parent2;
    }

    public CropTypes getFirstParent() {
        return CropTypes.fromName((String)this.getA());
    }

    public CropTypes getSecondParent() {
        return CropTypes.fromName((String)this.getB());
    }

    public float getMutationChance() {
        return this.mutationChance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParentPair that = (ParentPair)o;
        return super.equals(o) && Float.compare(that.mutationChance, this.mutationChance) == 0;
    }

    @Override
    public String toString() {
        return "ParentPair{" + super.toString() + ", mutationChance=" + this.mutationChance + "}";
    }

    public static class Serializer
    implements JsonSerializer<ParentPair>,
    JsonDeserializer<ParentPair> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(ParentPair src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("parent_1", (String)src.getA());
            obj.addProperty("parent_2", (String)src.getB());
            obj.addProperty("chance", (Number)Float.valueOf(src.getMutationChance()));
            return obj;
        }

        public ParentPair deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String parent1 = GsonHelper.m_13906_((JsonObject)obj, (String)"parent_1");
            String parent2 = GsonHelper.m_13906_((JsonObject)obj, (String)"parent_2");
            float mutateChance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            return new ParentPair(parent1, parent2, mutateChance);
        }

        public ParentPair read(FriendlyByteBuf buf) {
            String parent1 = buf.m_130277_();
            String parent2 = buf.m_130277_();
            float chance = buf.readFloat();
            return ParentPair.of(parent1, parent2, chance);
        }

        public void write(ParentPair pair, FriendlyByteBuf buf) {
            buf.m_130070_((String)pair.getA());
            buf.m_130070_((String)pair.getB());
            buf.writeFloat(pair.getMutationChance());
        }
    }
}

