/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.LazyRegistryEntry;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DropEntry
implements ISerializable {
    public static final DropEntry EMPTY = DropEntry.of(() -> Items.f_41852_, 0, 0);
    private final int min;
    private final int max;
    private final Supplier<Item> drop;

    private DropEntry(Supplier<Item> item, int min, int max) {
        this.drop = item;
        this.min = min;
        this.max = max;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("min", this.min);
        compound.m_128405_("max", this.max);
        compound.m_128359_("drop", ForgeRegistries.ITEMS.getKey((Object)this.drop.get()).toString());
        return compound;
    }

    public int getAmountDropped(int traitBase, int traitMax, RandomSource rand) {
        int minAmount = Math.max((int)((float)traitBase / (float)traitMax * (float)this.max * 0.75f), this.min);
        int maxAmount = Math.max(1, Math.min((int)((float)traitBase / (float)traitMax * (float)this.max * 1.5f), this.max));
        int range = maxAmount - minAmount;
        return rand.m_188503_(range + 1) + minAmount;
    }

    public ItemStack getDroppedStack(int traitBase, int traitMax, RandomSource rand) {
        int amountDropped = this.getAmountDropped(traitBase, traitMax, rand);
        return amountDropped > 0 ? new ItemStack((ItemLike)this.drop.get(), amountDropped) : ItemStack.f_41583_;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public Supplier<Item> getItem() {
        return this.drop;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.getItem().get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropEntry entry = (DropEntry)o;
        return this.min == entry.min && this.max == entry.max && this.drop.equals(entry.drop);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.drop);
    }

    public static DropEntry of(Supplier<Item> item, int min, int max) {
        return new DropEntry(item, min, max);
    }

    public static DropEntry of(CompoundTag compound) {
        return new DropEntry(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("drop"))), compound.m_128451_("min"), compound.m_128451_("max"));
    }

    public String toString() {
        return "DropEntry{min=" + this.min + ", max=" + this.max + ", drop=" + this.drop + "}";
    }

    public static class Serializer
    implements JsonSerializer<DropEntry>,
    JsonDeserializer<DropEntry> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(DropEntry entry, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)entry.getItem().get()).toString());
            obj.addProperty("min", (Number)entry.getMin());
            obj.addProperty("max", (Number)entry.getMax());
            return obj;
        }

        public DropEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation itemLocation;
            int min = 1;
            int max = 1;
            if (json.isJsonPrimitive()) {
                itemLocation = new ResourceLocation(json.getAsJsonArray().get(0).getAsString());
            } else if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                itemLocation = new ResourceLocation(obj.get("item").getAsString());
                if (obj.has("min")) {
                    min = obj.get("min").getAsInt();
                }
                if (obj.has("max")) {
                    max = obj.get("max").getAsInt();
                }
            } else {
                throw new JsonSyntaxException("Expected either a string or an object, got ");
            }
            if (min < 0) {
                throw new JsonSyntaxException("min has a negative value");
            }
            if (max < 0) {
                throw new JsonSyntaxException("max has a negative value");
            }
            if (min > max) {
                throw new JsonSyntaxException("min is bigger than max");
            }
            return DropEntry.of(LazyRegistryEntry.of(itemLocation, ForgeRegistries.ITEMS), min, max);
        }

        public void write(DropEntry entry, FriendlyByteBuf buffer) {
            buffer.m_130085_(ForgeRegistries.ITEMS.getKey((Object)entry.getItem().get()));
            buffer.writeInt(entry.getMin());
            buffer.writeInt(entry.getMax());
        }

        public DropEntry read(FriendlyByteBuf buffer) {
            ResourceLocation itemLoc = buffer.m_130281_();
            int min = buffer.readInt();
            int max = buffer.readInt();
            return DropEntry.of(LazyRegistryEntry.of(itemLoc, ForgeRegistries.ITEMS), min, max);
        }
    }
}

