/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.LazyRegistryEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum CropTypes {
    ABYSSALNITE_CROP("abyssalnite", false, ItemType.INGOTS, 4522079),
    ADAMANTINE_CROP("adamantine", false, ItemType.INGOTS, 13974528),
    ALLIUM_CROP("allium", true, ItemType.OTHER, 10903265, false),
    ALLAY_CROP("allay", true, ItemType.OTHER, 652031),
    ALUMINUM_CROP("aluminum", false, ItemType.INGOTS, 0xB4B4B4),
    ALUMINUM_BRASS_CROP("aluminum_brass", false, ItemType.INGOTS, 13153024),
    ALUMITE_CROP("alumite", false, ItemType.INGOTS, 15174143),
    AMBER_CROP("amber", false, ItemType.GEMS, 0xE09E00),
    AMETHYST_CROP("amethyst", true, ItemType.GEMS, 12604927),
    APATITE_CROP("apatite", false, ItemType.GEMS, 46048),
    AQUAMARINE_CROP("aquamarine", false, ItemType.GEMS, 50132),
    ARDITE_CROP("ardite", false, ItemType.INGOTS, 8931099),
    AWAKENED_DRACONIUM_CROP("awakened_draconium", false, ItemType.INGOTS, 12536832),
    AZURE_BLUET_CROP("azure_bluet", true, ItemType.OTHER, 14084328, false),
    BAMBOO_CROP("bamboo", true, ItemType.OTHER, 6129700, false),
    BASALT_CROP("basalt", false, ItemType.INGOTS, 0x424242),
    BEAST_CROP("beast", true, ItemType.OTHER, 6973797),
    BEE_CROP("bee", true, ItemType.OTHER, 16766720),
    BEETROOTS_CROP("beetroots", true, ItemType.OTHER, 12526889, false),
    BLACK_QUARTZ_CROP("black_quartz", false, ItemType.GEMS, 0x202020),
    BLAZE_CROP("blaze", true, ItemType.OTHER, 16553472),
    BLITZ_CROP("blitz", false, ItemType.OTHER, 0xFFFDCC),
    BLIZZ_CROP("blizz", false, ItemType.OTHER, 12833791),
    BLUE_TOPAZ_CROP("blue_topaz", false, ItemType.GEMS, 6326783),
    BLUE_ORCHID_CROP("blue_orchid", true, ItemType.OTHER, 3172095, false),
    BRASS_CROP("brass", false, ItemType.INGOTS, 0xEAEAEA),
    BRONZE_CROP("bronze", false, ItemType.INGOTS, 8406272),
    CACTUS_CROP("cactus", true, ItemType.OTHER, 5405990, false),
    CARROT_CROP("carrot", true, ItemType.OTHER, 14912029, false),
    CERTUS_QUARTZ_CROP("certus_quartz", false, ItemType.GEMS, 10470399),
    CHICKEN_CROP("chicken", true, ItemType.OTHER, 0xE2E2E2),
    CHIMERITE_CROP("chimerite", false, ItemType.GEMS, 11468710),
    CHORUS_CROP("chorus", true, ItemType.OTHER, 9400719, false),
    CHROME_CROP("chrome", false, ItemType.INGOTS, 0xFFFFFF),
    COAL_CROP("coal", true, ItemType.GEMS, 0x3F3F3F),
    COBALT_CROP("cobalt", false, ItemType.INGOTS, 1922961),
    COCOA_BEAN_CROP("cocoa_bean", true, ItemType.OTHER, 12153653, false),
    COLD_IRON_CROP("cold_iron", false, ItemType.INGOTS, 7514111),
    COMPRESSED_IRON_CROP("compressed_iron", false, ItemType.INGOTS, 0xBDBDBD),
    CONDUCTIVE_IRON_CROP("conductive_iron", false, ItemType.INGOTS, 6462975),
    CONSTANTAN_CROP("constantan", false, ItemType.INGOTS, 11643648),
    COPPER_CROP("copper", true, ItemType.INGOTS, 11827200),
    CORALIUM_CROP("coralium", false, ItemType.GEMS, 25706),
    CORNFLOWER_CROP("cornflower", true, ItemType.OTHER, 4614891, false),
    COW_CROP("cow", true, ItemType.OTHER, 4470310),
    CREEPER_CROP("creeper", true, ItemType.OTHER, 4306742),
    DANCIUM_CROP("dancium", true, ItemType.INGOTS, 15436820),
    DANDELION_CROP("dandelion", true, ItemType.OTHER, 16700985, false),
    DARK_GEM_CROP("dark_gem", false, ItemType.GEMS, 0x4E4E4E),
    DARK_STEEL_CROP("dark_steel", false, ItemType.INGOTS, 9272063),
    DESH_CROP("desh", false, ItemType.INGOTS, 0x535353),
    DIAMOND_CROP("diamond", true, ItemType.GEMS, 7851771),
    DIRT_CROP("dirt", true, ItemType.VANILLA_BLOCKS, 5848361),
    DRACONIUM_CROP("draconium", false, ItemType.INGOTS, 7733434),
    DREADIUM_CROP("dreadium", false, ItemType.INGOTS, 12189709),
    DROWNED_CROP("drowned", true, ItemType.OTHER, 9433559),
    ELECTRICAL_STEEL_CROP("electrical_steel", false, ItemType.INGOTS, 0xB8B8B8),
    ELECTROTINE_CROP("electrotine", false, ItemType.DUSTS, 20627),
    ELECTRUM_CROP("electrum", false, ItemType.INGOTS, 16773464),
    ELEMENTIUM_CROP("elementium", false, ItemType.INGOTS, 15405567),
    EMERALD_CROP("emerald", true, ItemType.GEMS, 1564002),
    END_STEEL_CROP("end_steel", false, ItemType.INGOTS, 16711638),
    ENDER_AMETHYST_CROP("ender_amethyst", false, ItemType.GEMS, 16594431),
    ENDER_BIOTITE_CROP("ender_biotite", false, ItemType.GEMS, 0),
    ENDERDRAGON_CROP("enderdragon", false, ItemType.OTHER, 0x181818),
    ENDERIUM_CROP("enderium", false, ItemType.INGOTS, 31607),
    ENDERMAN_CROP("enderman", true, ItemType.OTHER, 0x181818),
    ENDSTONE_CROP("endstone", true, ItemType.VANILLA_BLOCKS, 16186045),
    ENERGETIC_ALLOY_CROP("energetic_alloy", false, ItemType.INGOTS, 10288946),
    FISH_CROP("fish", true, ItemType.OTHER, 12551195),
    FLUIX_CRYSTAL_CROP("fluix_crystal", false, ItemType.GEMS, 7274648),
    FLUXED_ELECTRUM_CROP("fluxed_electrum", false, ItemType.INGOTS, 16776071),
    FROG_CROP("frog", true, ItemType.OTHER, 5014348),
    GHAST_CROP("ghast", true, ItemType.OTHER, 0xF0F0F0),
    GLOWING_SQUID_CROP("glowing_squid", true, ItemType.OTHER, 161881),
    GLOWSTONE_CROP("glowstone", true, ItemType.VANILLA_BLOCKS, 16505460),
    GLOWSTONE_INGOT_CROP("glowstone_ingot", false, ItemType.INGOTS, 16182528),
    GLOW_BERRIES_CROP("glow_berries", false, ItemType.OTHER, 16764483, false),
    GOAT_CROP("goat", true, ItemType.OTHER, 0xEBEBEB),
    GOLD_CROP("gold", true, ItemType.INGOTS, 16297771),
    GRAPHITE_CROP("graphite", false, ItemType.INGOTS, 0x444444),
    GUARDIAN_CROP("guardian", true, ItemType.OTHER, 6719872),
    HUSK_CROP("husk", true, ItemType.OTHER, 6970698),
    ILLAGER_CROP("illager", true, ItemType.OTHER, 0x939999),
    INVAR_CROP("invar", false, ItemType.INGOTS, 12827648),
    IRIDIUM_CROP("iridium", false, ItemType.INGOTS, 0xCFCFCF),
    IRON_CROP("iron", true, ItemType.INGOTS, 12360064),
    KANEKIUM_CROP("kanekium", true, ItemType.INGOTS, 5713546),
    KELP_CROP("kelp", true, ItemType.OTHER, 5996849, false),
    KINNOIUM_CROP("kinnoium", true, ItemType.INGOTS, 2386733),
    KNIGHTSLIME_CROP("knightslime", false, ItemType.INGOTS, 0xFD5FFF),
    LAPIS_CROP("lapis", true, ItemType.GEMS, 1066156),
    LAVA_CROP("lava", true, ItemType.VANILLA_FLUIDS, 13717260),
    LEAD_CROP("lead", false, ItemType.INGOTS, 3305113),
    LENTHURIUM_CROP("lenthurium", true, ItemType.INGOTS, 2917765),
    LILY_OF_THE_VALLEY_CROP("lily_of_the_valley", true, ItemType.OTHER, 0xE7E7E7, false),
    LITHIUM_CROP("lithium", false, ItemType.INGOTS, 16775876),
    LUMIUM_CROP("lumium", false, ItemType.INGOTS, 0xFFF282),
    MAGMA_CUBE_CROP("magma_cube", true, ItemType.VANILLA_BLOCKS, 0x330000),
    MAGNESIUM_CROP("magnesium", false, ItemType.INGOTS, 6379776),
    MALACHITE_CROP("malachite", false, ItemType.GEMS, 3587923),
    MANASTEEL_CROP("manasteel", false, ItemType.INGOTS, 4034559),
    MANYULLYN_CROP("manyullyn", false, ItemType.INGOTS, 0x793393),
    MELON_CROP("melon", true, ItemType.OTHER, 10988573, false),
    METEORIC_IRON_CROP("meteoric_iron", false, ItemType.INGOTS, 9405534),
    MITHRIL_CROP("mithril", false, ItemType.INGOTS, 12048383),
    MOONSTONE_CROP("moonstone", false, ItemType.GEMS, 0xEEF6FF),
    MOOSHROOM_CROP("mooshroom", true, ItemType.OTHER, 11014162),
    MUSHROOM_CROP("mushroom", true, ItemType.OTHER, 0xE21212, false),
    MYCELIUM_CROP("mycelium", false, ItemType.VANILLA_BLOCKS, 7561570),
    NETHER_WART_CROP("nether_wart", true, ItemType.OTHER, 8592416, false),
    NETHERRACK_CROP("netherrack", true, ItemType.VANILLA_BLOCKS, 6629416),
    NETHERITE_CROP("netherite", true, ItemType.INGOTS, 0x320000),
    NEUTRONIUM_CROP("neutronium", false, ItemType.INGOTS, 0x585858),
    NICKEL_CROP("nickel", false, ItemType.INGOTS, 10459532),
    OCTINE_CROP("octine", false, ItemType.INGOTS, 16757760),
    ORANGE_TULIP_CROP("orange_tulip", true, ItemType.OTHER, 12413474, false),
    OSMIUM_CROP("osmium", false, ItemType.INGOTS, 13037055),
    OXEYE_DAISY_CROP("oxeye_daisy", true, ItemType.OTHER, 16103975, false),
    PANDA_CROP("panda", true, ItemType.OTHER, 16103975),
    PARROT_CROP("parrot", true, ItemType.OTHER, 1621503),
    PERIDOT_CROP("peridot", false, ItemType.GEMS, 6277209),
    PIG_CROP("pig", true, ItemType.OTHER, 15834776),
    PINK_TULIP_CROP("pink_tulip", true, ItemType.OTHER, 14987252, false),
    PLANTIUM_CROP("plantium", true, ItemType.OTHER, 3514440),
    PLATINUM_CROP("platinum", false, ItemType.INGOTS, 0xA2A2A2),
    POLARBEAR_CROP("polarbear", true, ItemType.GEMS, 0xF6F6F6),
    POPPY_CROP("poppy", true, ItemType.OTHER, 15544364, false),
    POTATO_CROP("potato", true, ItemType.OTHER, 13148747, false),
    PRISMARINE_CROP("prismarine", true, ItemType.GEMS, 6202518),
    PULSATING_IRON_CROP("pulsating_iron", false, ItemType.INGOTS, 7723376),
    PUMPKIN_CROP("pumpkin", true, ItemType.OTHER, 14912029, false),
    QUARTZ_CROP("quartz", true, ItemType.GEMS, 13945530),
    QUICKSILVER_CROP("quicksilver", false, ItemType.GEMS, 0xD6FFFF),
    RABBIT_CROP("rabbit", true, ItemType.OTHER, 0),
    RED_TULIP_CROP("red_tulip", true, ItemType.OTHER, 15544364, false),
    REDSTONE_CROP("redstone", true, ItemType.DUSTS, 0xFF0000),
    REDSTONE_ALLOY_CROP("redstone_alloy", false, ItemType.INGOTS, 0xFF0000),
    REFINED_OBSIDIAN_CROP("refined_obsidian", false, ItemType.INGOTS, 6435181),
    ROCK_CRYSTAL_CROP("rock_crystal", false, ItemType.GEMS, 0xA6A6A6),
    RUBBER_CROP("rubber", false, ItemType.OTHER, 0x444444),
    RUBY_CROP("ruby", false, ItemType.GEMS, 0x980000),
    SALTPETER_CROP("saltpeter", false, ItemType.DUSTS, 0x969696),
    SAND_CROP("sand", false, ItemType.VANILLA_BLOCKS, 14340003),
    SAPPHIRE_CROP("sapphire", false, ItemType.GEMS, 2702),
    SHEEP_CROP("sheep", true, ItemType.OTHER, 12623494),
    SHULKER_CROP("shulker", true, ItemType.OTHER, 9330830),
    SIGNALUM_CROP("signalum", false, ItemType.INGOTS, 9328384),
    SILICON_CROP("silicon", false, ItemType.INGOTS, 0x777777),
    SILVER_CROP("silver", false, ItemType.INGOTS, 0xDADADA),
    SKELETON_CROP("skeleton", true, ItemType.OTHER, 0xBCBCBC),
    SKY_STONE_CROP("sky_stone", false, ItemType.MOD_BLOCKS, 0x383838),
    SLATE_CROP("slate", false, ItemType.MOD_BLOCKS, 0xFFFFFF),
    SLIME_CROP("slime", true, ItemType.OTHER, 5881157),
    SLIMY_BONE_CROP("slimy_bone", false, ItemType.MOD_ITEMS, 0x7B7B7B),
    SNOW_CROP("snow", true, ItemType.VANILLA_BLOCKS, 0xFFFFFF),
    SOULARIUM_CROP("soularium", false, ItemType.INGOTS, 4470820),
    SOULSAND_CROP("soulsand", true, ItemType.VANILLA_BLOCKS, 4798252),
    SPIDER_CROP("spider", true, ItemType.OTHER, 6313032),
    SPONGE_CROP("sponge", true, ItemType.VANILLA_BLOCKS, 13487690),
    SQUID_CROP("squid", true, ItemType.OTHER, 13487690),
    STAR_STEEL_CROP("star_steel", false, ItemType.INGOTS, 0x171717),
    STARMETAL_CROP("starmetal", false, ItemType.INGOTS, 0x22002F),
    STEEL_CROP("steel", false, ItemType.INGOTS, 0x686868),
    STONE_CROP("stone", true, ItemType.VANILLA_BLOCKS, 0x616161),
    STRAY_CROP("stray", true, ItemType.OTHER, 11319997),
    SUGARCANE_CROP("sugarcane", true, ItemType.OTHER, 8562777, false),
    SULFUR_CROP("sulfur", false, ItemType.DUSTS, 11643943),
    SUNSTONE_CROP("sunstone", false, ItemType.MOD_BLOCKS, 12663552),
    SWEET_BERRIES_CROP("sweet_berries", true, ItemType.OTHER, 0xE00000, false),
    SYRMORITE_CROP("syrmorite", false, ItemType.INGOTS, 13049599),
    TANZANITE_CROP("tanzanite", false, ItemType.GEMS, 11096518),
    TERRASTEEL_CROP("terrasteel", false, ItemType.INGOTS, 3322112),
    THAUMIUM_CROP("thaumium", false, ItemType.INGOTS, 9044223),
    TIN_CROP("tin", false, ItemType.INGOTS, 11249548),
    TITANIUM_CROP("titanium", false, ItemType.INGOTS, 0xC6C6C6),
    TOPAZ_CROP("topaz", false, ItemType.GEMS, 16768553),
    TUNGSTEN_CROP("tungsten", false, ItemType.INGOTS, 23104),
    TURTLE_CROP("turtle", true, ItemType.OTHER, 3706170),
    URANIUM_CROP("uranium", false, ItemType.INGOTS, 3849506),
    VALONITE_CROP("valonite", false, ItemType.GEMS, 13608405),
    VIBRANT_ALLOY_CROP("vibrant_alloy", false, ItemType.INGOTS, 12549632),
    VILLAGER_CROP("villager", true, ItemType.OTHER, 11893607),
    VINE_CROP("vine", true, ItemType.VANILLA_BLOCKS, 1789969, false),
    VINTEUM_CROP("vinteum", false, ItemType.DUSTS, 5931519),
    VOID_METAL_CROP("void_metal", false, ItemType.INGOTS, 0),
    WARDEN_CROP("warden", true, ItemType.OTHER, 3753044),
    WATER_CROP("water", true, ItemType.VANILLA_FLUIDS, 2842623),
    WHEAT_CROP("wheat", true, ItemType.OTHER, 44569, false),
    WHITE_TULIP_CROP("white_tulip", true, ItemType.OTHER, 0xF7F7F7, false),
    WITCH_CROP("witch", true, ItemType.OTHER, 10720387),
    WITHER_CROP("wither", true, ItemType.OTHER, 0x343434),
    WITHER_ROSE_CROP("wither_rose", true, ItemType.OTHER, 0, false),
    WITHER_SKELETON_CROP("wither_skeleton", true, ItemType.OTHER, 0x515353),
    WOOD_CROP("wood", true, ItemType.VANILLA_BLOCKS, 6315604),
    YELLORIUM_CROP("yellorium", false, ItemType.INGOTS, 0xFFFC00),
    ZINC_CROP("zinc", false, ItemType.INGOTS, 0xB8B78B),
    ZOMBIE_CROP("zombie", true, ItemType.OTHER, 7443803),
    ZOMBIE_PIGMAN_CROP("zombie_pigman", true, ItemType.OTHER, 15639972),
    ZOMBIE_VILLAGER_CROP("zombie_villager", true, ItemType.OTHER, 3891759);

    private final String name;
    private final boolean vanilla;
    private final ItemType type;
    private final String displayName;
    private final int seedColor;
    private final Style style;
    private final boolean hasParticle;
    private final Supplier<Item> particle;
    private final CropConfiguration config;
    private RegistryObject<Item> seed;
    private RegistryObject<Block> cropBlock;
    public static final Logger LOGGER;
    public static final Map<CropTypes, RegistryObject<Item>> SEEDS;
    public static final Map<CropTypes, RegistryObject<Block>> CROP_BLOCKS;
    public static CropTypes DEFAULT;
    private static final HashSet<String> WARNED_DEAD_END;

    private CropTypes(String name, boolean vanilla, ItemType type, int seedColor) {
        this(name, vanilla, type, seedColor, true);
    }

    private CropTypes(String name, boolean vanilla, ItemType type, int seedColor, boolean particle) {
        String[] s;
        this.name = name;
        this.vanilla = vanilla;
        this.type = type;
        StringBuilder nameBuilder = new StringBuilder(name.length());
        for (String n2 : s = name.split("_")) {
            n2 = StringUtils.capitalize((String)n2.toLowerCase());
            if (nameBuilder.length() != 0) {
                nameBuilder.append(" ");
            }
            nameBuilder.append(n2);
        }
        this.displayName = nameBuilder.toString();
        this.seedColor = seedColor;
        this.style = Style.f_131099_.m_178520_(seedColor);
        this.hasParticle = particle;
        this.particle = () -> particle ? (Item)ModItems.PARTICLES.get(name).get() : Items.f_41852_;
        CropConfiguration.Builder builder = CropConfiguration.builder(DropEntry.of(this::getSeed, 1, 4));
        if (particle) {
            builder.drop(() -> (Item)ModItems.PARTICLES.get(name).get(), 0, 8);
        }
        this.config = builder.build();
    }

    public void setSeed(RegistryObject<Item> seed) {
        SEEDS.put(this, seed);
        this.seed = seed;
    }

    public void setCropBlock(RegistryObject<Block> cropBlock) {
        CROP_BLOCKS.put(this, cropBlock);
        this.cropBlock = cropBlock;
    }

    public Item getSeed() {
        return (Item)this.seed.get();
    }

    public Component getDisplaySoilName() {
        Block block = this.getConfig().getSoil().get();
        return block.m_49954_().m_6881_().m_130948_(Style.f_131099_.m_178520_(block.m_284356_().m_284280_(MapColor.Brightness.NORMAL)));
    }

    public Block getCropBlock() {
        return (Block)this.cropBlock.get();
    }

    public ItemType getType() {
        return this.type;
    }

    public boolean isSeed(ItemStack stack) {
        CropConfiguration config = this.getConfig();
        return config.getPrimarySeed().getItem().get() == stack.m_41720_() || config.getSeeds().stream().anyMatch(sup -> ((Ingredient)sup.get()).test(stack));
    }

    public List<ItemStack> calculateDrops(List<ItemStack> drops, TraitsManager cropTrait, int growstate, RandomSource rand) {
        CropConfiguration config = this.getConfig();
        ItemStack seed = config.getPrimarySeed().getDroppedStack(cropTrait.getTrait(CropTraitsTypes.FERTILITY), CropTraitsTypes.FERTILITY.getMax(), rand);
        if (!seed.m_41619_()) {
            if (growstate < 7) {
                seed.m_41764_(1);
            }
            drops.add(TraitsManager.ItemImpl.of((ItemStack)seed, (CompoundTag)cropTrait.serializeNBT()).stack);
        }
        if (growstate > 6) {
            List<DropEntry> dropEntries = config.getDrops();
            for (int i = 1; i < dropEntries.size(); ++i) {
                DropEntry drop = dropEntries.get(i);
                ItemStack addDrop = drop.getDroppedStack(cropTrait.getTrait(CropTraitsTypes.PRODUCTIVITY), CropTraitsTypes.PRODUCTIVITY.getMax(), rand);
                if (addDrop.m_41619_()) continue;
                drops.add(addDrop);
            }
        }
        return drops;
    }

    public NonNullList<ItemStack> calculateDropsReduced(NonNullList<ItemStack> drops, TraitsManager cropTrait, int growstate, RandomSource rand) {
        CropConfiguration config = this.getConfig();
        List<DropEntry> dropEntries = config.getDrops();
        if (growstate > 6) {
            ItemStack seed = config.getPrimarySeed().getDroppedStack(cropTrait.getTrait(CropTraitsTypes.FERTILITY), CropTraitsTypes.FERTILITY.getMax(), rand);
            if (!seed.m_41619_() && seed.m_41613_() > 1) {
                seed.m_41774_(1);
                drops.add((Object)TraitsManager.ItemImpl.of((ItemStack)seed, (CompoundTag)cropTrait.serializeNBT()).stack);
            }
            for (DropEntry drop : dropEntries) {
                ItemStack stack = drop.getDroppedStack(cropTrait.getTrait(CropTraitsTypes.PRODUCTIVITY), CropTraitsTypes.PRODUCTIVITY.getMax(), rand);
                if (stack.m_41619_()) continue;
                drops.add((Object)stack);
            }
        }
        return drops;
    }

    public boolean isChild(CropTypes parent1, CropTypes parent2) {
        return this.getConfig().getParents().stream().anyMatch(parent -> parent.test(parent1, parent2));
    }

    public Item getParticle() {
        return this.particle.get();
    }

    public int getSeedColor() {
        return this.seedColor;
    }

    public boolean hasParticle() {
        return this.hasParticle;
    }

    public CropConfiguration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)this.translationKey()).m_130948_(this.style);
    }

    public String translationKey() {
        return "planttech2.crop." + this.name;
    }

    public static CropTypes fromName(String name) {
        return Arrays.stream(CropTypes.values()).filter(crop -> crop.name.equals(name)).findFirst().orElse(DEFAULT);
    }

    public static CropTypes fromNameNullable(String name) {
        return Arrays.stream(CropTypes.values()).filter(crop -> crop.name.equals(name)).findFirst().orElse(null);
    }

    public static CropTypes getDefault() {
        return DEFAULT;
    }

    public static void extraToNetwork(FriendlyByteBuf buf) {
        try {
            for (CropTypes crop : CropTypes.values()) {
                crop.getConfig().extraToNetwork(buf);
            }
        }
        catch (Exception e) {
            PlantTechMain.LOGGER.error("Crop list is broken, cannot write the data");
            e.printStackTrace();
        }
    }

    public static CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        try {
            ListTag list = new ListTag();
            for (CropTypes crop : CropTypes.values()) {
                CompoundTag tag = crop.getConfig().serializeNBT();
                tag.m_128359_("name", crop.name);
                list.add((Object)tag);
            }
            compound.m_128365_("crops", (Tag)list);
        }
        catch (Exception e) {
            PlantTechMain.LOGGER.error("Crop list is broken, cannot write the data");
            e.printStackTrace();
            return new CompoundTag();
        }
        return compound;
    }

    public static void extraFromNetwork(FriendlyByteBuf buf) {
        try {
            for (CropTypes crop : CropTypes.values()) {
                crop.getConfig().extraFromNetwork(buf);
            }
        }
        catch (Exception e) {
            PlantTechMain.LOGGER.error("Crop list is broken, cannot write the data");
            e.printStackTrace();
        }
    }

    public static void deserializeNBT(CompoundTag compound) {
        try {
            ListTag crops = compound.m_128437_("crops", 10);
            for (int i = 0; i < crops.size(); ++i) {
                CompoundTag data = crops.m_128728_(i);
                CropTypes.fromName(data.m_128461_("name")).getConfig().deserializeNBT(data);
            }
        }
        catch (Exception e) {
            PlantTechMain.LOGGER.error("Received incomplete crop list, cannot deserialize the data");
            e.printStackTrace();
        }
    }

    public static int getEnabledLength() {
        return CropTypes.crops(false).size();
    }

    public static Optional<CropTypes> getBySeed(ItemStack item) {
        return CropTypes.crops().stream().filter(crop -> crop.isSeed(item)).findFirst();
    }

    public static List<CropTypes> getByParents(CropTypes parent, CropTypes parent2) {
        return CropTypes.crops().stream().filter(crop -> crop.isChild(parent, parent2)).collect(Collectors.toList());
    }

    public static List<CropTypes> crops(boolean includeDisabled) {
        return CropTypes.crops().stream().filter(entry -> includeDisabled || entry.shouldBeInGame()).sorted().collect(Collectors.toList());
    }

    public static List<CropTypes> crops() {
        return Arrays.stream(CropTypes.values()).sorted().toList();
    }

    public static List<CropConfiguration> configs() {
        return CropTypes.crops().stream().map(CropTypes::getConfig).collect(Collectors.toList());
    }

    public static List<Map<Integer, CropTypes>> getFamilyTree(CropTypes crop) {
        ArrayList<Map<Integer, CropTypes>> tree = new ArrayList<Map<Integer, CropTypes>>();
        HashMap<Integer, CropTypes> map = new HashMap<Integer, CropTypes>();
        HashMap<Integer, CropTypes> mapNext = new HashMap<Integer, CropTypes>();
        map.put(0, crop);
        tree.add(map);
        boolean next = true;
        int counter = 0;
        while (next) {
            next = false;
            for (Map.Entry mapEntry : map.entrySet()) {
                String name;
                int position = (Integer)mapEntry.getKey();
                CropTypes currentEntry = (CropTypes)((Object)mapEntry.getValue());
                List<ParentPair> parents = currentEntry.getConfig().getParents();
                if (parents.size() > 0) {
                    mapNext.put(2 * position, parents.get(0).getFirstParent());
                    mapNext.put(2 * position + 1, parents.get(0).getSecondParent());
                    next = true;
                    continue;
                }
                if (currentEntry.getConfig().getSeeds().size() > 1 || WARNED_DEAD_END.contains(name = currentEntry.getName())) continue;
                LOGGER.info("Dead end in " + name);
                WARNED_DEAD_END.add(name);
            }
            if (next && ++counter < 20) {
                tree.add(mapNext);
                map = mapNext;
                mapNext = new HashMap();
                continue;
            }
            if (counter < 20) break;
            LOGGER.info("Loophole in croplist");
            break;
        }
        return tree;
    }

    public boolean shouldBeInGame() {
        return this.getConfig().shouldBeInGame() && (this.vanilla || this.getType().tagKeys(this.getName()).stream().anyMatch(key -> {
            Optional tag = BuiltInRegistries.f_257033_.m_203431_(key);
            return tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0;
        }));
    }

    static {
        LOGGER = LogManager.getLogger();
        SEEDS = new HashMap<CropTypes, RegistryObject<Item>>();
        CROP_BLOCKS = new HashMap<CropTypes, RegistryObject<Block>>();
        WARNED_DEAD_END = new HashSet();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ItemType {
        ORES(0, 1, "ores", true),
        DUSTS(1, 1, "dusts", true),
        NUGGETS(2, 1, "nuggets", true),
        GEMS(3, 1, "gems", true){

            @Override
            public TagKey<Item> alternateTagKey(String item) {
                return ItemTags.create((ResourceLocation)new ResourceLocation(INGOTS.getRel() + item));
            }
        }
        ,
        INGOTS(4, 1, "ingots", true){

            @Override
            public TagKey<Item> alternateTagKey(String item) {
                return ItemTags.create((ResourceLocation)new ResourceLocation(GEMS.getRel() + item));
            }
        }
        ,
        STORAGE_BLOCKS(5, 1, "storage_blocks", true),
        VANILLA_BLOCKS(6, 0, null, false),
        MOD_BLOCKS(7, 1, null, false),
        VANILLA_ITEMS(8, 0, null, false),
        MOD_ITEMS(9, 1, null, false),
        VANILLA_FLUIDS(10, 0, null, false),
        MOD_FLUIDS(11, 1, null, false),
        OTHER(12, 0, null, false);

        private final int index;
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @Nullable
        private final String rel;
        private final boolean hasDefaultProduct;

        private ItemType(@Nullable int index, int mod, String name, boolean hasDefaultProduct) {
            this.index = index;
            this.id = mod == 0 ? "minecraft" : "forge";
            this.name = name;
            this.rel = name == null ? this.id + ":" : this.id + ":" + name + "/";
            this.hasDefaultProduct = hasDefaultProduct;
        }

        public boolean hasDefaultProduct() {
            return this.hasDefaultProduct;
        }

        @Nullable
        public String getRel() {
            return this.rel;
        }

        public int getIndex() {
            return this.index;
        }

        public static ItemType fromIndex(int index) {
            return Arrays.stream(ItemType.values()).filter(type -> type.getIndex() == index).findFirst().orElse(OTHER);
        }

        public Set<TagKey<Item>> tagKeys(String item) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.rel + item));
            return this.alternates() ? Set.of(tag, this.alternateTagKey(item)) : Collections.singleton(tag);
        }

        public TagKey<Item> alternateTagKey(String item) {
            throw new NullPointerException();
        }

        public boolean alternates() {
            return this == INGOTS || this == GEMS;
        }
    }

    public static class Serializer
    implements JsonSerializer<CropTypes>,
    JsonDeserializer<CropTypes> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(CropTypes crop, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            CropConfiguration config = crop.getConfig();
            obj.addProperty("crop", crop.getName());
            obj.addProperty("enabled", Boolean.valueOf(config.isEnabled()));
            JsonObject temp = new JsonObject();
            temp.addProperty("minTemperatureTolerance", (Number)Float.valueOf(config.getTemperature().getMinTempTolerance()));
            temp.addProperty("maxTemperatureTolerance", (Number)Float.valueOf(config.getTemperature().getMaxTempTolerance()));
            obj.add("temperature", (JsonElement)temp);
            obj.add("primary_seed", context.serialize((Object)config.getPrimarySeed(), DropEntry.class));
            JsonArray seeds = new JsonArray();
            config.getSeeds().stream().map(Supplier::get).map(Ingredient::m_43942_).sorted(Comparator.comparing(JsonElement::toString)).forEach(arg_0 -> ((JsonArray)seeds).add(arg_0));
            obj.add("seeds", (JsonElement)seeds);
            JsonArray drops = new JsonArray();
            config.getDrops().stream().map(entry -> context.serialize(entry, DropEntry.class)).forEach(arg_0 -> ((JsonArray)drops).add(arg_0));
            obj.add("drops", (JsonElement)drops);
            JsonArray parents = new JsonArray();
            config.getParents().stream().map(pair -> context.serialize(pair, ParentPair.class)).forEach(arg_0 -> ((JsonArray)parents).add(arg_0));
            obj.add("parents", (JsonElement)parents);
            JsonObject soil = new JsonObject();
            soil.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)config.getSoil().get()).toString());
            obj.add("soil", (JsonElement)soil);
            return obj;
        }

        public CropTypes deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            CropTypes crop = CropTypes.fromName(obj.get("crop").getAsString());
            crop.getConfig().update(obj.get("enabled").getAsBoolean(), this.getTemperature(obj.getAsJsonObject("temperature")), (DropEntry)context.deserialize(obj.get("primary_seed"), DropEntry.class), this.getSeeds(obj.get("seeds")), this.getDropEntries(obj.get("drops"), context), this.getParentPairs(obj.get("parents"), context), this.getSoil(obj.get("soil")));
            return crop;
        }

        @Deprecated
        public void write(CropTypes crop, FriendlyByteBuf buf) {
            CropConfiguration config = crop.getConfig();
            buf.m_130072_(crop.getName(), 64);
            buf.writeBoolean(config.isEnabled());
            buf.m_130079_(config.getTemperature().serializeNBT());
            DropEntry.Serializer.INSTANCE.write(config.getPrimarySeed(), buf);
            buf.writeShort(config.getSeeds().size());
            config.getSeeds().stream().map(Supplier::get).filter(Objects::nonNull).forEach(e -> e.m_43923_(buf));
            buf.writeShort(config.getParents().size());
            config.getDrops().forEach(drop -> DropEntry.Serializer.INSTANCE.write((DropEntry)drop, buf));
            buf.writeShort(config.getParents().size());
            config.getParents().forEach(pair -> ParentPair.Serializer.INSTANCE.write((ParentPair)pair, buf));
            buf.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)config.getSoil().get()));
        }

        @Deprecated
        public CropTypes read(FriendlyByteBuf buf) {
            String name = buf.m_130136_(64);
            boolean enabled = buf.readBoolean();
            TemperatureTolerance temperature = TemperatureTolerance.fromNBT(buf.m_130260_());
            DropEntry primarySeed = DropEntry.Serializer.INSTANCE.read(buf);
            LinkedList<Supplier<Ingredient>> seeds = new LinkedList<Supplier<Ingredient>>();
            int seedsAmount = buf.readShort();
            for (int i = 0; i < seedsAmount; ++i) {
                seeds.add(() -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            int dropsAmount = buf.readShort();
            LinkedList<DropEntry> drops = new LinkedList<DropEntry>();
            for (int i = 0; i < dropsAmount; ++i) {
                drops.add(DropEntry.Serializer.INSTANCE.read(buf));
            }
            LinkedList<ParentPair> parentPairs = new LinkedList<ParentPair>();
            int parentsAmount = buf.readShort();
            for (int i = 0; i < parentsAmount; ++i) {
                parentPairs.add(ParentPair.Serializer.INSTANCE.read(buf));
            }
            LazyRegistryEntry<Block> soil = LazyRegistryEntry.of(buf.m_130281_(), ForgeRegistries.BLOCKS);
            CropTypes crop = CropTypes.fromName(name);
            crop.getConfig().update(enabled, temperature, primarySeed, seeds, drops, parentPairs, soil);
            return crop;
        }

        private TemperatureTolerance getTemperature(JsonObject obj) {
            return TemperatureTolerance.of(GsonHelper.m_13888_((JsonElement)obj.get("minTemperatureTolerance"), (String)"minTemperatureTolerance"), GsonHelper.m_13888_((JsonElement)obj.get("maxTemperatureTolerance"), (String)"maxTemperatureTolerance"));
        }

        private List<DropEntry> getDropEntries(JsonElement element, JsonDeserializationContext context) {
            return this.getEntries(element, context, DropEntry.class);
        }

        private List<ParentPair> getParentPairs(JsonElement element, JsonDeserializationContext context) {
            return this.getEntries(element, context, ParentPair.class);
        }

        private <T> List<T> getEntries(JsonElement element, JsonDeserializationContext context, Class<T> clazz) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (element.isJsonPrimitive() || element.isJsonObject()) {
                list.add(context.deserialize(element, clazz));
            } else if (element.isJsonArray()) {
                element.getAsJsonArray().forEach(el -> list.add(context.deserialize(el, (Type)clazz)));
            } else {
                throw new JsonSyntaxException("Expected " + clazz.getName() + " to be a JsonObject or JsonArray, was " + GsonHelper.m_13883_((JsonElement)element));
            }
            return list;
        }

        private List<Supplier<Ingredient>> getSeeds(JsonElement json) {
            List elements = StreamSupport.stream(GsonHelper.m_13924_((JsonElement)json, (String)"seeds").spliterator(), false).collect(Collectors.toList());
            return (List)Util.m_137469_(new ArrayList(), list -> {
                for (JsonElement element : elements) {
                    list.add(() -> {
                        try {
                            return Ingredient.m_43917_((JsonElement)element);
                        }
                        catch (Exception e) {
                            return Ingredient.f_43901_;
                        }
                    });
                }
            });
        }

        private Supplier<Block> getSoil(JsonElement element) {
            if (element.isJsonPrimitive()) {
                return () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)"soil")));
            }
            if (element.isJsonObject()) {
                return () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)element.getAsJsonObject(), (String)"block")));
            }
            throw new JsonSyntaxException("Expected soil to be a string or JsonObject, was " + GsonHelper.m_13883_((JsonElement)element));
        }
    }
}

