/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.packets.CropListSyncMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.utilities.BaseReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CropListReloadListener
extends BaseReloadListener<CropTypes> {
    public static String FOLDER = "pt2_crops";
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(CropTypes.class, (Object)CropTypes.Serializer.INSTANCE).registerTypeAdapter(DropEntry.class, (Object)DropEntry.Serializer.INSTANCE).registerTypeAdapter(ParentPair.class, (Object)ParentPair.Serializer.INSTANCE).create();

    public CropListReloadListener() {
        super("crop configuration", GSON, FOLDER);
    }

    @Override
    protected CropTypes fromJson(JsonElement element) {
        return (CropTypes)((Object)this.gson.fromJson(element, CropTypes.class));
    }

    @Override
    protected void postLoading(Map<ResourceLocation, Supplier<CropTypes>> map) {
        for (Supplier<CropTypes> value : map.values()) {
            value.get();
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PlantTechMain.LOGGER.info("syncing crop list to clients");
            PlantTech2PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CropListSyncMessage());
        } else {
            PlantTechMain.LOGGER.warn("Server is not up yet, will not send the changes to clients. Might need to reload manually afterwards");
        }
    }

    public static JsonElement toJson(CropTypes crop) {
        return GSON.toJsonTree((Object)crop);
    }
}

