/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.LazyRegistryEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.utilities.ISerializable;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class CropConfiguration
implements ISerializable {
    private boolean enabled;
    private TemperatureTolerance temperature;
    private DropEntry primarySeed;
    private List<Supplier<Ingredient>> seeds;
    private List<DropEntry> drops;
    private List<ParentPair> parents;
    private Supplier<Block> soil;

    public CropConfiguration(boolean enabled, TemperatureTolerance temperature, DropEntry primarySeed, List<Supplier<Ingredient>> seeds, List<DropEntry> drops, List<ParentPair> parents, Supplier<Block> soil) {
        this.update(enabled, temperature, primarySeed, seeds, drops, parents, soil);
    }

    public void update(CropConfiguration config) {
        this.update(config.enabled, config.temperature, config.primarySeed, config.seeds, config.drops, config.parents, config.soil);
    }

    public void update(boolean enabled, TemperatureTolerance temperature, DropEntry primarySeed, List<Supplier<Ingredient>> seeds, List<DropEntry> drops, List<ParentPair> parents, Supplier<Block> soil) {
        this.enabled = enabled;
        this.temperature = temperature;
        this.primarySeed = primarySeed;
        this.seeds = seeds;
        this.drops = drops;
        this.parents = parents;
        this.soil = soil;
    }

    @Override
    public void extraToNetwork(FriendlyByteBuf buf) {
        buf.writeInt(this.seeds.size());
        for (Supplier<Ingredient> seed : this.seeds) {
            seed.get().m_43923_(buf);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("enabled", this.enabled);
        compound.m_128365_("temperature", (Tag)this.temperature.serializeNBT());
        compound.m_128365_("primaryseed", (Tag)this.primarySeed.serializeNBT());
        NBTHelper.putSerilizableList(compound, "drops", this.drops);
        NBTHelper.putSerilizableList(compound, "parents", this.parents);
        compound.m_128359_("soil", ForgeRegistries.BLOCKS.getKey((Object)this.soil.get()).toString());
        return compound;
    }

    @Override
    public void extraFromNetwork(FriendlyByteBuf buf) {
        this.seeds.clear();
        int s = buf.readInt();
        for (int i = 0; i < s; ++i) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            this.seeds.add(() -> ingredient);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.enabled = compound.m_128471_("enabled");
        this.temperature = TemperatureTolerance.fromNBT(compound.m_128469_("temperature"));
        this.primarySeed = DropEntry.of(compound.m_128469_("primaryseed"));
        this.drops = NBTHelper.constructListFromCompound(compound, "drops", DropEntry::of);
        this.parents = NBTHelper.constructListFromCompound(compound, "parents", ParentPair::of);
        this.soil = () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("soil")));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEmpty() {
        return this.primarySeed.isEmpty();
    }

    public boolean shouldBeInGame() {
        return this.isEnabled() && !this.isEmpty();
    }

    public TemperatureTolerance getTemperature() {
        return this.temperature;
    }

    public DropEntry getPrimarySeed() {
        return this.primarySeed;
    }

    public List<Supplier<Ingredient>> getSeeds() {
        return this.seeds;
    }

    public List<DropEntry> getDrops() {
        return this.drops;
    }

    public List<ParentPair> getParents() {
        return this.parents;
    }

    public Supplier<Block> getSoil() {
        return this.soil;
    }

    public float getMutateChanceForParents(CropTypes parent1, CropTypes parent2) {
        return this.parents.stream().filter(parentPair -> parentPair.test(parent1, parent2)).map(ParentPair::getMutationChance).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    public String toString() {
        return "CropConfiguration{enabled=" + this.enabled + ", temperature=" + this.temperature + ", primarySeed=" + this.primarySeed + ", seeds=" + this.seeds + ", drops=" + this.drops + ", parents=" + this.parents + ", soil=" + this.soil + "}";
    }

    public static Builder builder(CropConfiguration configuration) {
        return new Builder(configuration);
    }

    public static Builder builder(DropEntry primarySeed) {
        return new Builder(primarySeed);
    }

    public static class Builder {
        boolean enabled = true;
        final TemperatureTolerance temperature = TemperatureTolerance.NORMAL.copy();
        final DropEntry primarySeed;
        final List<Supplier<Ingredient>> seeds = new ArrayList<Supplier<Ingredient>>();
        final List<DropEntry> drops = new ArrayList<DropEntry>();
        final List<ParentPair> parents = new ArrayList<ParentPair>();
        Supplier<Block> soil = () -> Blocks.f_50493_;

        private Builder(CropConfiguration configuration) {
            this.enabled = configuration.isEnabled();
            this.temperature(configuration.getTemperature());
            this.primarySeed = configuration.getPrimarySeed();
            this.seeds.addAll(configuration.getSeeds());
            this.drops.addAll(configuration.getDrops());
            this.parents.addAll(configuration.getParents());
            this.soil = configuration.getSoil();
        }

        private Builder(DropEntry primarySeed) {
            this.primarySeed = primarySeed;
        }

        public CropConfiguration build() {
            return new CropConfiguration(this.enabled, this.temperature, this.primarySeed, this.seeds, this.drops, this.parents, this.soil);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled() {
            return this.enabled(true);
        }

        public Builder temperature(float min, float max) {
            this.temperature.set(Float.valueOf(min), Float.valueOf(max));
            return this;
        }

        public Builder temperature(TemperatureTolerance temperature) {
            this.temperature.set((Float)temperature.getA(), (Float)temperature.getB());
            return this;
        }

        public Builder seed(Supplier<Item> item) {
            this.seeds.add(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
            return this;
        }

        public Builder seed(TagKey<Item> tag) {
            this.seeds.add(() -> Ingredient.m_204132_((TagKey)tag));
            return this;
        }

        public Builder seed(ResourceLocation item) {
            return this.seed(LazyRegistryEntry.of(item, ForgeRegistries.ITEMS));
        }

        public Builder seed(String item) {
            return this.seed(new ResourceLocation(item));
        }

        public Builder parents(ParentPair entry) {
            this.parents.add(entry);
            return this;
        }

        public Builder parents(CropTypes parent1, CropTypes parent2, float chance) {
            return this.parents(parent1.getName(), parent2.getName(), chance);
        }

        public Builder parents(String parent1, String parent2, float chance) {
            return this.parents(ParentPair.of(parent1, parent2, chance));
        }

        public Builder parents(ParentPair ... entries) {
            this.parents.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder drop(DropEntry entry) {
            this.drops.add(entry);
            return this;
        }

        public Builder drop(Supplier<Item> item, int min, int max) {
            return this.drop(DropEntry.of(item, min, max));
        }

        public Builder drop(ResourceLocation item, int min, int max) {
            return this.drop(LazyRegistryEntry.of(item, ForgeRegistries.ITEMS), min, max);
        }

        public Builder drop(String item, int min, int max) {
            return this.drop(new ResourceLocation(item), min, max);
        }

        public Builder drop(DropEntry ... entries) {
            this.drops.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder soil(Supplier<Block> newSoil) {
            this.soil = newSoil;
            return this;
        }
    }
}

