/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.CropListReloadListener;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.TemperatureTolerance;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.BaseDataProvider;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CropConfigProvider
extends BaseDataProvider<CropTypes> {
    public CropConfigProvider(PackOutput generator) {
        super(generator, entry -> CropConfigProvider.modLoc(entry.getName()));
    }

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path path = this.dataGenerator.m_245114_();
        List<CropTypes> entryData = this.getData();
        this.validate(entryData);
        ArrayList completables = new ArrayList();
        entryData.forEach(entry -> {
            Path outputFile = this.getPath(path, (ResourceLocation)this.locationGetter.apply(entry));
            try {
                completables.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.toJson((CropTypes)((Object)entry)), (Path)outputFile));
            }
            catch (Exception ioexception) {
                LOGGER.error("Couldn't save " + this.m_6055_() + " {}", (Object)outputFile, (Object)ioexception);
            }
        });
        return CompletableFuture.allOf(completables.toArray(new CompletableFuture[0]));
    }

    @Override
    protected void validate(List<CropTypes> dataMap) {
        AtomicBoolean errored = new AtomicBoolean(false);
        dataMap.forEach(crop -> {
            String name = crop.getName();
            ResourceLocation loc = new ResourceLocation("planttech2", name);
            crop.getConfig().getParents().forEach(parentPair -> {
                if (parentPair.getFirstParent() == null) {
                    LOGGER.fatal("Unknown first parent crop entry {} in {}: {}", (Object)parentPair.getFirstParent(), (Object)loc, parentPair);
                    errored.set(true);
                }
                if (parentPair.getSecondParent() == null) {
                    LOGGER.fatal("Unknown second parent crop entry {} in {}: {}", (Object)parentPair.getSecondParent(), (Object)loc, parentPair);
                    errored.set(true);
                }
            });
        });
        if (errored.get()) {
            throw new RuntimeException("Unknown crop entries found during validation. Check the log for details");
        }
    }

    @Override
    protected JsonElement toJson(CropTypes data) {
        return CropListReloadListener.toJson(data);
    }

    @Override
    protected Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/" + CropListReloadListener.FOLDER + "/" + id.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Crop Entry Configurations";
    }

    @Override
    public List<CropTypes> getData() {
        this.data.clear();
        this.addEntryWithSeeds(CropTypes.ALLAY_CROP, b -> b.parents(CropTypes.CHICKEN_CROP, CropTypes.SQUID_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.ALLIUM_CROP, b -> b.seed(() -> Items.f_41942_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41942_, 0, 4));
        this.addEntryWithSeeds(CropTypes.AMETHYST_CROP, b -> b.parents(CropTypes.DIAMOND_CROP, CropTypes.LAPIS_CROP, 0.1f).soil(() -> Blocks.f_152497_));
        this.addEntryWithSeeds(CropTypes.AZURE_BLUET_CROP, b -> b.seed(() -> Items.f_41943_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41943_, 0, 4));
        this.addEntryWithSeeds(CropTypes.BAMBOO_CROP, b -> b.seed(() -> Items.f_41911_).drop(() -> Items.f_41911_, 0, 4));
        this.addEntryWithSeeds(CropTypes.BEAST_CROP, b -> b.parents(CropTypes.ILLAGER_CROP, CropTypes.WITCH_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.BEE_CROP, b -> b.parents(CropTypes.DANDELION_CROP, CropTypes.ALLIUM_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.BEETROOTS_CROP, b -> b.seed(() -> Items.f_42733_).drop(() -> Items.f_42732_, 0, 4));
        this.addEntryWithSeeds(CropTypes.BLAZE_CROP, b -> b.parents(CropTypes.CREEPER_CROP, CropTypes.LAVA_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.BLUE_ORCHID_CROP, b -> b.seed(() -> Items.f_41941_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41941_, 0, 4));
        this.addEntryWithSeeds(CropTypes.CACTUS_CROP, b -> b.seed(() -> Items.f_41982_).drop(() -> Items.f_41982_, 0, 4).temperature(TemperatureTolerance.WARM).soil(() -> Blocks.f_49992_));
        this.addEntryWithSeeds(CropTypes.CARROT_CROP, b -> b.seed(() -> Items.f_42619_).drop(() -> Items.f_42619_, 0, 4));
        this.addEntryWithSeeds(CropTypes.CHICKEN_CROP, b -> b.parents(CropTypes.BEETROOTS_CROP, CropTypes.CACTUS_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.CHORUS_CROP, b -> b.seed(() -> Items.f_42003_).drop(() -> Items.f_42730_, 0, 4).temperature(TemperatureTolerance.COLD).soil(() -> Blocks.f_50259_));
        this.addEntryWithSeeds(CropTypes.COAL_CROP, b -> b.parents(CropTypes.NETHER_WART_CROP, CropTypes.CHORUS_CROP, 0.1f).soil(() -> Blocks.f_49997_));
        this.addEntryWithSeeds(CropTypes.COCOA_BEAN_CROP, b -> b.seed(() -> Items.f_42533_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_42533_, 0, 4).temperature(TemperatureTolerance.WARM));
        this.addEntryWithSeeds(CropTypes.COPPER_CROP, b -> b.parents(CropTypes.IRON_CROP, CropTypes.COAL_CROP, 0.1f).soil(() -> Blocks.f_152505_));
        this.addEntryWithSeeds(CropTypes.CORNFLOWER_CROP, b -> b.seed(() -> Items.f_41949_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41949_, 0, 4));
        this.addEntryWithSeeds(CropTypes.COW_CROP, b -> b.parents(CropTypes.CARROT_CROP, CropTypes.POTATO_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.CREEPER_CROP, b -> b.parents(CropTypes.PIG_CROP, CropTypes.COAL_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.DANCIUM_CROP, b -> b.parents(CropTypes.PLANTIUM_CROP, CropTypes.FISH_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.DANDELION_CROP, b -> b.seed(() -> Items.f_41939_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41939_, 0, 4));
        this.addEntryWithSeeds(CropTypes.DIAMOND_CROP, b -> b.parents(CropTypes.QUARTZ_CROP, CropTypes.ENDERDRAGON_CROP, 0.1f).soil(() -> Blocks.f_50089_));
        this.addEntryWithSeeds(CropTypes.DIRT_CROP, b -> b.parents(CropTypes.MELON_CROP, CropTypes.PUMPKIN_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.DROWNED_CROP, b -> b.parents(CropTypes.STRAY_CROP, CropTypes.HUSK_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.EMERALD_CROP, b -> b.parents(CropTypes.DIAMOND_CROP, CropTypes.WITHER_CROP, 0.1f).soil(() -> Blocks.f_50089_));
        this.addEntryWithSeeds(CropTypes.ENDERDRAGON_CROP, b -> b.parents(CropTypes.ENDERMAN_CROP, CropTypes.SHULKER_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM).soil(() -> Blocks.f_50752_));
        this.addEntryWithSeeds(CropTypes.ENDERMAN_CROP, b -> b.parents(CropTypes.WITHER_SKELETON_CROP, CropTypes.NETHERRACK_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.ENDSTONE_CROP, b -> b.parents(CropTypes.COAL_CROP, CropTypes.CHORUS_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.FISH_CROP, b -> b.parents(CropTypes.CACTUS_CROP, CropTypes.SUGARCANE_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.FROG_CROP, b -> b.parents(CropTypes.SLIME_CROP, CropTypes.WATER_CROP, 0.1f).temperature(TemperatureTolerance.WARM));
        this.addEntryWithSeeds(CropTypes.GHAST_CROP, b -> b.parents(CropTypes.MAGMA_CUBE_CROP, CropTypes.BLAZE_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.GLOWING_SQUID_CROP, b -> b.parents(CropTypes.SQUID_CROP, CropTypes.GLOWSTONE_CROP, 0.1f).temperature(TemperatureTolerance.COLD).soil(() -> Blocks.f_49992_));
        this.addEntryWithSeeds(CropTypes.GLOWSTONE_CROP, b -> b.parents(CropTypes.SOULSAND_CROP, CropTypes.NETHERRACK_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.GLOW_BERRIES_CROP, b -> b.parents(CropTypes.SWEET_BERRIES_CROP, CropTypes.GLOWSTONE_CROP, 0.1f).seed(() -> Items.f_151079_).drop(() -> Items.f_151079_, 0, 4));
        this.addEntryWithSeeds(CropTypes.GOAT_CROP, b -> b.parents(CropTypes.SHEEP_CROP, CropTypes.COW_CROP, 0.1f).soil(() -> Blocks.f_50069_).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.GOLD_CROP, b -> b.parents(CropTypes.COAL_CROP, CropTypes.LAPIS_CROP, 0.1f).soil(() -> Blocks.f_49995_));
        this.addEntryWithSeeds(CropTypes.GUARDIAN_CROP, b -> b.parents(CropTypes.GHAST_CROP, CropTypes.WITCH_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.HUSK_CROP, b -> b.parents(CropTypes.ZOMBIE_CROP, CropTypes.LAVA_CROP, 0.1f).temperature(TemperatureTolerance.WARM));
        this.addEntryWithSeeds(CropTypes.ILLAGER_CROP, b -> b.parents(CropTypes.VILLAGER_CROP, CropTypes.WITCH_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.IRON_CROP, b -> b.parents(CropTypes.REDSTONE_CROP, CropTypes.GOLD_CROP, 0.1f).soil(() -> Blocks.f_49996_));
        this.addEntryWithSeeds(CropTypes.KANEKIUM_CROP, b -> b.parents(CropTypes.PLANTIUM_CROP, CropTypes.SQUID_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.KELP_CROP, b -> b.seed(() -> Items.f_41910_).drop(() -> Items.f_41910_, 0, 4));
        this.addEntryWithSeeds(CropTypes.KINNOIUM_CROP, b -> b.parents(CropTypes.PLANTIUM_CROP, CropTypes.PIG_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.LAPIS_CROP, b -> b.parents(CropTypes.STONE_CROP, CropTypes.COAL_CROP, 0.1f).soil(() -> Blocks.f_50059_));
        this.addEntryWithSeeds(CropTypes.LAVA_CROP, b -> b.parents(CropTypes.STONE_CROP, CropTypes.WATER_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.LENTHURIUM_CROP, b -> b.parents(CropTypes.PLANTIUM_CROP, CropTypes.CHICKEN_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.LILY_OF_THE_VALLEY_CROP, b -> b.seed(() -> Items.f_41950_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41950_, 0, 4));
        this.addEntryWithSeeds(CropTypes.MAGMA_CUBE_CROP, b -> b.parents(CropTypes.SLIME_CROP, CropTypes.LAVA_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.MELON_CROP, b -> b.seed(() -> Items.f_42578_).drop(() -> Items.f_42028_, 0, 4));
        this.addEntryWithSeeds(CropTypes.MOOSHROOM_CROP, b -> b.parents(CropTypes.COW_CROP, CropTypes.MUSHROOM_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.MUSHROOM_CROP, b -> b.seed(() -> Items.f_41952_).seed(() -> Items.f_41953_).drop(() -> Items.f_41952_, 0, 4).drop(() -> Items.f_41953_, 0, 4));
        this.addEntryWithSeeds(CropTypes.MYCELIUM_CROP, b -> b.parents(CropTypes.NETHERRACK_CROP, CropTypes.MOOSHROOM_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.NETHER_WART_CROP, b -> b.seed(() -> Items.f_42588_).drop(() -> Items.f_42588_, 0, 4).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.NETHERRACK_CROP, b -> b.parents(CropTypes.ENDSTONE_CROP, CropTypes.NETHER_WART_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.NETHERITE_CROP, b -> b.parents(CropTypes.GHAST_CROP, CropTypes.ENDERDRAGON_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.ORANGE_TULIP_CROP, b -> b.seed(() -> Items.f_41945_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41945_, 0, 4));
        this.addEntryWithSeeds(CropTypes.OXEYE_DAISY_CROP, b -> b.seed(() -> Items.f_41948_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41948_, 0, 4));
        this.addEntryWithSeeds(CropTypes.PINK_TULIP_CROP, b -> b.seed(() -> Items.f_41947_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41947_, 0, 4));
        this.addEntryWithSeeds(CropTypes.PLANTIUM_CROP, b -> b.seed(() -> (Item)ModItems.PLANTIUM_NUGGET.get()).soil(() -> (Block)ModBlocks.PLANTIUM_BLOCK.get()));
        this.addEntryWithSeeds(CropTypes.POPPY_CROP, b -> b.seed(() -> Items.f_41940_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41940_, 0, 4));
        this.addEntryWithSeeds(CropTypes.POTATO_CROP, b -> b.seed(() -> Items.f_42620_).drop(() -> Items.f_42620_, 0, 4).drop(() -> Items.f_42675_, 0, 2));
        this.addEntryWithSeeds(CropTypes.PUMPKIN_CROP, b -> b.seed(() -> Items.f_42577_).drop(() -> Items.f_42046_, 0, 3));
        this.addEntryWithSeeds(CropTypes.PANDA_CROP, b -> b.parents(CropTypes.BEETROOTS_CROP, CropTypes.MUSHROOM_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.PARROT_CROP, b -> b.parents(CropTypes.WHEAT_CROP, CropTypes.COCOA_BEAN_CROP, 0.1f).temperature(TemperatureTolerance.WARM));
        this.addEntryWithSeeds(CropTypes.PIG_CROP, b -> b.parents(CropTypes.BEETROOTS_CROP, CropTypes.CARROT_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.POLARBEAR_CROP, b -> b.parents(CropTypes.COW_CROP, CropTypes.PANDA_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_COLD));
        this.addEntryWithSeeds(CropTypes.PRISMARINE_CROP, b -> b.parents(CropTypes.SOULSAND_CROP, CropTypes.WATER_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.QUARTZ_CROP, b -> b.parents(CropTypes.NETHERRACK_CROP, CropTypes.IRON_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.RABBIT_CROP, b -> b.parents(CropTypes.CARROT_CROP, CropTypes.CHICKEN_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.REDSTONE_CROP, b -> b.parents(CropTypes.GOLD_CROP, CropTypes.GLOWSTONE_CROP, 0.1f).soil(() -> Blocks.f_50173_));
        this.addEntryWithSeeds(CropTypes.RED_TULIP_CROP, b -> b.seed(() -> Items.f_41944_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41944_, 0, 4));
        this.addEntryWithSeeds(CropTypes.SAND_CROP, b -> b.parents(CropTypes.MUSHROOM_CROP, CropTypes.CACTUS_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.SHEEP_CROP, b -> b.parents(CropTypes.POTATO_CROP, CropTypes.WHEAT_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.SHULKER_CROP, b -> b.parents(CropTypes.BLAZE_CROP, CropTypes.ENDSTONE_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.SKELETON_CROP, b -> b.parents(CropTypes.PIG_CROP, CropTypes.COW_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.SLIME_CROP, b -> b.parents(CropTypes.CREEPER_CROP, CropTypes.ZOMBIE_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.SNOW_CROP, b -> b.parents(CropTypes.POLARBEAR_CROP, CropTypes.WATER_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_COLD));
        this.addEntryWithSeeds(CropTypes.SOULSAND_CROP, b -> b.parents(CropTypes.SAND_CROP, CropTypes.NETHERRACK_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.SPIDER_CROP, b -> b.parents(CropTypes.SHEEP_CROP, CropTypes.SQUID_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.SPONGE_CROP, b -> b.parents(CropTypes.MYCELIUM_CROP, CropTypes.GUARDIAN_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.SQUID_CROP, b -> b.parents(CropTypes.NETHER_WART_CROP, CropTypes.VINE_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.STONE_CROP, b -> b.parents(CropTypes.WHEAT_CROP, CropTypes.MUSHROOM_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.STRAY_CROP, b -> b.parents(CropTypes.SKELETON_CROP, CropTypes.SNOW_CROP, 0.1f).temperature(TemperatureTolerance.COLD));
        this.addEntryWithSeeds(CropTypes.SUGARCANE_CROP, b -> b.seed(() -> Items.f_41909_).drop(() -> Items.f_41909_, 0, 4));
        this.addEntryWithSeeds(CropTypes.SWEET_BERRIES_CROP, b -> b.seed(() -> Items.f_42780_).drop(() -> Items.f_42780_, 0, 4));
        this.addEntryWithSeeds(CropTypes.TURTLE_CROP, b -> b.parents(CropTypes.SQUID_CROP, CropTypes.FISH_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.VILLAGER_CROP, b -> b.parents(CropTypes.POLARBEAR_CROP, CropTypes.TURTLE_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.VINE_CROP, b -> b.seed(() -> Items.f_42029_).drop(() -> Items.f_42029_, 0, 4));
        this.addEntryWithSeeds(CropTypes.WATER_CROP, b -> b.parents(CropTypes.VINE_CROP, CropTypes.SUGARCANE_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.WARDEN_CROP, b -> b.parents(CropTypes.BEAST_CROP, CropTypes.WITHER_CROP, 0.1f).temperature(TemperatureTolerance.COLD).soil(() -> Blocks.f_220855_));
        this.addEntryWithSeeds(CropTypes.WHEAT_CROP, b -> b.seed(() -> Items.f_42404_).drop(() -> Items.f_42405_, 0, 4));
        this.addEntryWithSeeds(CropTypes.WHITE_TULIP_CROP, b -> b.seed(() -> Items.f_41946_).drop(() -> (Item)ModItems.COLOR_PARTICLES.get(), 1, 4).drop(() -> Items.f_41946_, 0, 4));
        this.addEntryWithSeeds(CropTypes.WITCH_CROP, b -> b.parents(CropTypes.VILLAGER_CROP, CropTypes.SOULSAND_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.WITHER_CROP, b -> b.parents(CropTypes.GHAST_CROP, CropTypes.ZOMBIE_VILLAGER_CROP, 0.1f).soil(() -> Blocks.f_50752_));
        this.addEntryWithSeeds(CropTypes.WITHER_ROSE_CROP, b -> b.seed(() -> Items.f_41951_).drop(() -> Items.f_41951_, 0, 1));
        this.addEntryWithSeeds(CropTypes.WITHER_SKELETON_CROP, b -> b.parents(CropTypes.SKELETON_CROP, CropTypes.NETHERRACK_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.WOOD_CROP, b -> b.parents(CropTypes.DIRT_CROP, CropTypes.SAND_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.ZOMBIE_CROP, b -> b.parents(CropTypes.CHICKEN_CROP, CropTypes.SHEEP_CROP, 0.1f));
        this.addEntryWithSeeds(CropTypes.ZOMBIE_PIGMAN_CROP, b -> b.parents(CropTypes.ZOMBIE_CROP, CropTypes.NETHER_WART_CROP, 0.1f).temperature(TemperatureTolerance.EXTREME_WARM));
        this.addEntryWithSeeds(CropTypes.ZOMBIE_VILLAGER_CROP, b -> b.parents(CropTypes.ZOMBIE_CROP, CropTypes.VILLAGER_CROP, 0.1f));
        this.empty(CropTypes.ABYSSALNITE_CROP);
        this.empty(CropTypes.ADAMANTINE_CROP);
        this.empty(CropTypes.ALUMINUM_CROP);
        this.empty(CropTypes.ALUMINUM_BRASS_CROP);
        this.empty(CropTypes.ALUMITE_CROP);
        this.empty(CropTypes.AMBER_CROP);
        this.empty(CropTypes.APATITE_CROP);
        this.empty(CropTypes.AQUAMARINE_CROP);
        this.empty(CropTypes.ARDITE_CROP);
        this.empty(CropTypes.AWAKENED_DRACONIUM_CROP);
        this.empty(CropTypes.BASALT_CROP);
        this.empty(CropTypes.BLACK_QUARTZ_CROP);
        this.empty(CropTypes.BLITZ_CROP);
        this.empty(CropTypes.BLIZZ_CROP);
        this.empty(CropTypes.BLUE_TOPAZ_CROP);
        this.empty(CropTypes.BRASS_CROP);
        this.empty(CropTypes.BRONZE_CROP);
        this.empty(CropTypes.CERTUS_QUARTZ_CROP);
        this.empty(CropTypes.CHIMERITE_CROP);
        this.empty(CropTypes.CHROME_CROP);
        this.empty(CropTypes.COBALT_CROP);
        this.empty(CropTypes.COLD_IRON_CROP);
        this.empty(CropTypes.COMPRESSED_IRON_CROP);
        this.empty(CropTypes.CONDUCTIVE_IRON_CROP);
        this.empty(CropTypes.CONSTANTAN_CROP);
        this.empty(CropTypes.CORALIUM_CROP);
        this.empty(CropTypes.DARK_GEM_CROP);
        this.empty(CropTypes.DARK_STEEL_CROP);
        this.empty(CropTypes.DESH_CROP);
        this.empty(CropTypes.DRACONIUM_CROP);
        this.empty(CropTypes.DREADIUM_CROP);
        this.empty(CropTypes.ELECTRICAL_STEEL_CROP);
        this.empty(CropTypes.ELECTROTINE_CROP);
        this.empty(CropTypes.ELECTRUM_CROP);
        this.empty(CropTypes.ELEMENTIUM_CROP);
        this.empty(CropTypes.END_STEEL_CROP);
        this.empty(CropTypes.ENDER_AMETHYST_CROP);
        this.empty(CropTypes.ENDER_BIOTITE_CROP);
        this.empty(CropTypes.ENDERIUM_CROP);
        this.empty(CropTypes.ENERGETIC_ALLOY_CROP);
        this.empty(CropTypes.FLUIX_CRYSTAL_CROP);
        this.empty(CropTypes.FLUXED_ELECTRUM_CROP);
        this.empty(CropTypes.GLOWSTONE_INGOT_CROP);
        this.empty(CropTypes.GRAPHITE_CROP);
        this.empty(CropTypes.INVAR_CROP);
        this.empty(CropTypes.IRIDIUM_CROP);
        this.empty(CropTypes.KNIGHTSLIME_CROP);
        this.empty(CropTypes.LEAD_CROP);
        this.empty(CropTypes.LITHIUM_CROP);
        this.empty(CropTypes.LUMIUM_CROP);
        this.empty(CropTypes.MAGNESIUM_CROP);
        this.empty(CropTypes.MALACHITE_CROP);
        this.empty(CropTypes.MANASTEEL_CROP);
        this.empty(CropTypes.MANYULLYN_CROP);
        this.empty(CropTypes.METEORIC_IRON_CROP);
        this.empty(CropTypes.MITHRIL_CROP);
        this.empty(CropTypes.MOONSTONE_CROP);
        this.empty(CropTypes.NEUTRONIUM_CROP);
        this.empty(CropTypes.NICKEL_CROP);
        this.empty(CropTypes.OCTINE_CROP);
        this.empty(CropTypes.OSMIUM_CROP);
        this.empty(CropTypes.PERIDOT_CROP);
        this.empty(CropTypes.PLATINUM_CROP);
        this.empty(CropTypes.PULSATING_IRON_CROP);
        this.empty(CropTypes.QUICKSILVER_CROP);
        this.empty(CropTypes.REDSTONE_ALLOY_CROP);
        this.empty(CropTypes.REFINED_OBSIDIAN_CROP);
        this.empty(CropTypes.ROCK_CRYSTAL_CROP);
        this.empty(CropTypes.RUBBER_CROP);
        this.empty(CropTypes.RUBY_CROP);
        this.empty(CropTypes.SALTPETER_CROP);
        this.empty(CropTypes.SIGNALUM_CROP);
        this.empty(CropTypes.SILICON_CROP);
        this.empty(CropTypes.SILVER_CROP);
        this.empty(CropTypes.SKY_STONE_CROP);
        this.empty(CropTypes.SLATE_CROP);
        this.empty(CropTypes.SLIMY_BONE_CROP);
        this.empty(CropTypes.SOULARIUM_CROP);
        this.empty(CropTypes.SAPPHIRE_CROP);
        this.empty(CropTypes.STAR_STEEL_CROP);
        this.empty(CropTypes.STARMETAL_CROP);
        this.empty(CropTypes.STEEL_CROP);
        this.empty(CropTypes.SULFUR_CROP);
        this.empty(CropTypes.SUNSTONE_CROP);
        this.empty(CropTypes.SYRMORITE_CROP);
        this.empty(CropTypes.TANZANITE_CROP);
        this.empty(CropTypes.TERRASTEEL_CROP);
        this.empty(CropTypes.THAUMIUM_CROP);
        this.empty(CropTypes.TIN_CROP);
        this.empty(CropTypes.TITANIUM_CROP);
        this.empty(CropTypes.TOPAZ_CROP);
        this.empty(CropTypes.TUNGSTEN_CROP);
        this.empty(CropTypes.URANIUM_CROP);
        this.empty(CropTypes.VALONITE_CROP);
        this.empty(CropTypes.VIBRANT_ALLOY_CROP);
        this.empty(CropTypes.VINTEUM_CROP);
        this.empty(CropTypes.VOID_METAL_CROP);
        this.empty(CropTypes.YELLORIUM_CROP);
        this.empty(CropTypes.ZINC_CROP);
        return this.data;
    }

    private void empty(CropTypes crop) {
        this.addEntryWithSeeds(crop, builder -> crop.getType().tagKeys(crop.getName()).forEach(builder::seed));
    }

    private void addEntryWithSeeds(CropTypes crop, Consumer<CropConfiguration.Builder> modifier) {
        CropConfiguration.Builder config = CropConfiguration.builder(crop.getConfig());
        modifier.accept(config);
        crop.getConfig().update(config.build());
        this.data.add(crop);
    }
}

