/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.ModBlockEntityBlock;
import net.kaneka.planttech2.blocks.entity.cable.CableBlockEntity;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class CableBlock
extends ModBlockEntityBlock {
    public static final IntegerProperty NORTH = IntegerProperty.m_61631_((String)"north", (int)0, (int)3);
    public static final IntegerProperty EAST = IntegerProperty.m_61631_((String)"east", (int)0, (int)3);
    public static final IntegerProperty SOUTH = IntegerProperty.m_61631_((String)"south", (int)0, (int)3);
    public static final IntegerProperty WEST = IntegerProperty.m_61631_((String)"west", (int)0, (int)3);
    public static final IntegerProperty UP = IntegerProperty.m_61631_((String)"up", (int)0, (int)3);
    public static final IntegerProperty DOWN = IntegerProperty.m_61631_((String)"down", (int)0, (int)3);
    public static final Map<Direction, IntegerProperty> DIRECTIONS = new HashMap<Direction, IntegerProperty>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.NORTH, NORTH);
            this.put(Direction.EAST, EAST);
            this.put(Direction.SOUTH, SOUTH);
            this.put(Direction.WEST, WEST);
            this.put(Direction.UP, UP);
            this.put(Direction.DOWN, DOWN);
        }
    };
    private static final VoxelShape POST = CableBlock.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    private static final Map<Direction, VoxelShape> CONNECTION_VOXELS = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0));
            this.put(Direction.UP, Block.m_49796_((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
            this.put(Direction.NORTH, Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0));
            this.put(Direction.SOUTH, Block.m_49796_((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0));
            this.put(Direction.WEST, Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0));
            this.put(Direction.EAST, Block.m_49796_((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        }
    };
    private static final Map<Direction, VoxelShape> CABLE_VOXELS = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0));
            this.put(Direction.UP, Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            this.put(Direction.NORTH, Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0));
            this.put(Direction.SOUTH, Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0));
            this.put(Direction.WEST, Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0));
            this.put(Direction.EAST, Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
        }
    };
    protected final VoxelShape[][][][][][] shapes = new VoxelShape[3][3][3][3][3][3];

    public CableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(0.5f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(0))).m_61124_((Property)UP, (Comparable)Integer.valueOf(0))).m_61124_((Property)DOWN, (Comparable)Integer.valueOf(0)));
        this.initShapes();
    }

    private void initShapes() {
        for (int d = 0; d < 3; ++d) {
            for (int u = 0; u < 3; ++u) {
                for (int n = 0; n < 3; ++n) {
                    for (int s = 0; s < 3; ++s) {
                        for (int w = 0; w < 3; ++w) {
                            for (int e = 0; e < 3; ++e) {
                                this.shapes[d][u][n][s][w][e] = this.getCombinedShape(d, u, n, s, w, e);
                            }
                        }
                    }
                }
            }
        }
    }

    private VoxelShape getCombinedShape(int ... states) {
        VoxelShape shape = POST;
        if (states.length == 6) {
            for (int i = 0; i < 6; ++i) {
                int state = states[i];
                Direction direction = Direction.m_122376_((int)i);
                if (state <= 0) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CABLE_VOXELS.get(direction));
                if (state <= 1) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECTION_VOXELS.get(direction));
            }
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes[Math.min(2, (Integer)state.m_61143_((Property)DOWN))][Math.min(2, (Integer)state.m_61143_((Property)UP))][Math.min(2, (Integer)state.m_61143_((Property)NORTH))][Math.min(2, (Integer)state.m_61143_((Property)SOUTH))][Math.min(2, (Integer)state.m_61143_((Property)WEST))][Math.min(2, (Integer)state.m_61143_((Property)EAST))];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!level.m_5776_() && hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_21205_().m_41720_() == ModItems.WRENCH.get()) {
            Vec3 hitvec = ray.m_82450_();
            hitvec = hitvec.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
            for (Direction dir : Direction.values()) {
                CableBlockEntity te;
                VoxelShape tempshape = CONNECTION_VOXELS.get(dir);
                if (!(tempshape.m_83288_(Direction.Axis.X) <= hitvec.f_82479_) || !(tempshape.m_83297_(Direction.Axis.X) >= hitvec.f_82479_) || !(tempshape.m_83288_(Direction.Axis.Y) <= hitvec.f_82480_) || !(tempshape.m_83297_(Direction.Axis.Y) >= hitvec.f_82480_) || !(tempshape.m_83288_(Direction.Axis.Z) <= hitvec.f_82481_) || !(tempshape.m_83297_(Direction.Axis.Z) >= hitvec.f_82481_) || (te = this.getTECable(level, pos)) == null) continue;
                te.rotateConnection(dir);
                level.m_7731_(pos, this.getCurrentState(state, level, pos), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldstate, boolean bool) {
        CableBlockEntity te;
        if (!world.m_5776_() && state.m_60734_() != oldstate.m_60734_() && (te = this.getTECable(world, pos)) != null) {
            world.m_7731_(pos, this.getCurrentState(state, world, pos), 3);
            te.initCable();
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.f_46443_ && type == ModBlockEntities.CABLE_TE.get() ? CableBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CableBlockEntity(blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_()) {
            this.modifyCable(level, pos, CableBlockEntity::removeCable);
            level.m_46747_(pos);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        if (!world.m_5776_()) {
            this.checkConnections(world, pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction facing : Direction.values()) {
            BlockState stateDirection = level.m_8055_(pos.m_121945_(facing));
            BlockEntity te = level.m_7702_(pos.m_121945_(facing));
            if (stateDirection.m_60734_() instanceof CableBlock) {
                state.m_61124_((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(1));
                continue;
            }
            if (te != null && te.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                state.m_61124_((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(2));
                continue;
            }
            state.m_61124_((Property)DIRECTIONS.get(facing), (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(state, (Level)level, currentPos);
    }

    public BlockState getCurrentState(BlockState state, Level world, BlockPos pos) {
        CableBlockEntity cable = this.getTECable(world, pos);
        if (cable != null) {
            cable.checkConnections();
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Integer.valueOf(cable.getConnection(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Integer.valueOf(cable.getConnection(Direction.DOWN)))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(cable.getConnection(Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(cable.getConnection(Direction.WEST)))).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(cable.getConnection(Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(cable.getConnection(Direction.SOUTH)));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    private CableBlockEntity getTECable(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return null;
        }
        BlockEntity BlockEntity2 = world.m_7702_(pos);
        return BlockEntity2 instanceof CableBlockEntity ? (CableBlockEntity)BlockEntity2 : null;
    }

    private void checkConnections(Level world, BlockPos pos) {
        this.modifyCable(world, pos, CableBlockEntity::checkConnections);
    }

    private void modifyCable(Level world, BlockPos pos, Consumer<CableBlockEntity> modification) {
        CableBlockEntity cable = this.getTECable(world, pos);
        if (cable != null) {
            modification.accept(cable);
        }
    }
}

