/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.fluids.PTBiomassFluidHandler;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public abstract class EnergyInventoryFluidBlockEntity
extends EnergyInventoryBlockEntity
implements PTBiomassFluidHandler {
    private int biomass = 0;
    private int biomassCapacity;
    protected LazyOptional<IFluidHandler> biomassCap;

    public EnergyInventoryFluidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, pos, state, energyStorage, invSize, tier);
        this.biomassCapacity = maxBiomassStorage;
        this.biomassCap = LazyOptional.of(() -> this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.biomassCap.cast() : super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        this.doFluidLoop();
    }

    public void doFluidLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getFluidInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getFluidOutSlot());
        if (this.currentBiomass() < this.getTankCapacity()) {
            PTCommonUtil.tryAccessBiomass((ICapabilityProvider)stack, (storage, index) -> {
                IFluidHandlerItem cap;
                if (storage instanceof IFluidHandlerItem && this.fill((cap = (IFluidHandlerItem)storage).drain(new FluidStack((Fluid)ModFluids.BIOMASS.get(), stack.m_41720_() instanceof BucketItem ? storage.getTankCapacity(index.intValue()) : 4), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE) > 0) {
                    this.itemhandler.setStackInSlot(this.getFluidInSlot(), cap.getContainer());
                }
            });
        }
        PTCommonUtil.tryAccessBiomass((ICapabilityProvider)stack2, (storage, index) -> {
            IFluidHandlerItem cap;
            if (storage instanceof IFluidHandlerItem && this.drain((cap = (IFluidHandlerItem)storage).fill(new FluidStack((Fluid)ModFluids.BIOMASS.get(), Math.min(stack2.m_41720_() instanceof BucketItem ? storage.getTankCapacity(index.intValue()) : 4, this.currentBiomass())), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE).getAmount() > 0) {
                this.itemhandler.setStackInSlot(this.getFluidOutSlot(), cap.getContainer());
            }
        });
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("planttech2:biomass", this.currentBiomass());
        compound.m_128405_("biomassCapacity", this.getTankCapacity());
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.biomass = compound.m_128451_("planttech2:biomass");
        int c = compound.m_128451_("biomassCapacity");
        if (c > 0) {
            this.biomassCapacity = c;
        }
    }

    public abstract int getFluidInSlot();

    public abstract int getFluidOutSlot();

    @Override
    public void forceSetStorage(int amount) {
        this.biomass = amount;
        this.m_6596_();
    }

    @Override
    public boolean validCOntainer() {
        return !this.m_58901_();
    }

    @Override
    public int currentBiomass() {
        return this.biomass;
    }

    public void setTankCapacity(int amount) {
        this.biomassCapacity = amount;
    }

    public final int getTankCapacity() {
        return this.getTankCapacity(0);
    }

    public int getTankCapacity(int tank) {
        return this.biomassCapacity;
    }
}

