/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyBlockEntity;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PTCommonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class EnergyInventoryBlockEntity
extends EnergyBlockEntity {
    protected ItemStackHandler itemhandler;
    protected LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemhandler);
    protected PT2ItemStackHandler insertables;
    protected LazyOptional<IItemHandler> insertablesCap = LazyOptional.of(() -> this.insertables);
    protected PT2ItemStackHandler extractables;
    protected LazyOptional<IItemHandler> extractablesCap = LazyOptional.of(() -> this.extractables);
    protected int ticksPassed = 0;
    protected int tier;

    public EnergyInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage, int invSize, int tier) {
        super(type, pos, state, energyStorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.insertables = this.createInsertables();
        this.extractables = this.createExtractables();
        this.tier = tier;
    }

    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, new PT2ItemStackHandler.Handler[0]);
    }

    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, new PT2ItemStackHandler.Handler[0]);
    }

    protected static PT2ItemStackHandler.Handler ofDNAContainer(int index, boolean isEmpty) {
        return PT2ItemStackHandler.Handler.of(index).setConditions(stack -> isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER_EMPTY.get() || !isEmpty && stack.m_41720_() == ModItems.DNA_CONTAINER.get() && stack.m_41782_());
    }

    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            stacks.add(this.itemhandler.getStackInSlot(i).m_41777_());
        }
        return stacks;
    }

    @Override
    public void doUpdate() {
        this.doEnergyLoop();
    }

    protected void resetProgress(boolean forced) {
        this.ticksPassed = 0;
    }

    public void doEnergyLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getEnergyInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getEnergyOutSlot());
        if (this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack, cap -> this.energyStorage.receiveEnergy(cap.extractEnergy(1, false)));
        }
        if (this.energyStorage.getEnergyStored() >= 1) {
            PTCommonUtil.tryAccessEnergy((ICapabilityProvider)stack2, cap -> this.energyStorage.extractEnergy(cap.receiveEnergy(1, false)));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null) {
                return this.inventoryCap.cast();
            }
            if (facing == Direction.DOWN) {
                return this.extractables.isEmpty() ? LazyOptional.empty() : this.extractablesCap.cast();
            }
            return this.insertables.isEmpty() ? LazyOptional.empty() : this.insertablesCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("inventory", (Tag)this.itemhandler.serializeNBT());
        compound.m_128405_("tickspassed", this.ticksPassed);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        int slotamount = this.itemhandler.getSlots();
        this.itemhandler.deserializeNBT(compound.m_128469_("inventory"));
        if (this.itemhandler.getSlots() != slotamount) {
            this.itemhandler.setSize(slotamount);
        }
        this.insertables = this.createInsertables();
        this.extractables = this.createExtractables();
        this.ticksPassed = compound.m_128451_("tickspassed");
    }

    public static void spawnAsEntity(Level level, BlockPos pos, ItemStack stack) {
        if (level != null && !level.f_46443_ && !stack.m_41619_() && !level.restoringBlockSnapshots && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            double d0 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d1 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d2 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            ItemEntity entityitem = new ItemEntity(level, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, stack);
            entityitem.m_32060_();
            level.m_7967_((Entity)entityitem);
        }
    }

    public int energyPerAction() {
        return 4 + this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 35;
    }

    protected EnergyConsumptionType getEnergyConsumptionType() {
        return EnergyConsumptionType.PER_TICK;
    }

    public int getCapacityUpgrade() {
        return this.getUpgradeTier(TierItem.ItemType.CAPACITY_UPGRADE);
    }

    protected void increaseProgress() {
        ++this.ticksPassed;
    }

    public int getUpgradeTier(TierItem.ItemType itemType) {
        return this.getUpgradeTier(this.getUpgradeSlot(), itemType);
    }

    public int getUpgradeTier(int slot, TierItem.ItemType itemType) {
        TierItem tieritem;
        Item item;
        if (slot == -1) {
            return 0;
        }
        if (this.itemhandler == null) {
            return 0;
        }
        ItemStack stack = this.itemhandler.getStackInSlot(slot);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof TierItem && (tieritem = (TierItem)item).getItemType() == itemType) {
            return tieritem.getTier();
        }
        return 0;
    }

    public void onContainerUpdated(int slotIndex) {
    }

    public abstract int getEnergyInSlot();

    public abstract int getEnergyOutSlot();

    protected ItemStack getKnowledgeChip() {
        return this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
    }

    protected void addKnowledge() {
        ItemStack chip = this.getKnowledgeChip();
        ItemStack newChip = KnowledgeChip.addKnowledge(chip, this.getKnowledgePerAction(), this.tier);
        if (!(chip.m_41619_() || newChip.m_41619_() || chip.m_41720_().equals(newChip.m_41720_()))) {
            this.itemhandler.setStackInSlot(this.getKnowledgeChipSlot(), newChip);
        }
    }

    public abstract int getKnowledgeChipSlot();

    public abstract int getKnowledgePerAction();

    public int getTotalCapacity() {
        return this.getTotalCapacity(this.getUpgradeSlot());
    }

    public int getTotalCapacity(int capacityChipSlot) {
        return (int)(1000.0 * Math.pow(10.0, this.getUpgradeTier(capacityChipSlot, TierItem.ItemType.CAPACITY_UPGRADE)));
    }

    public static enum EnergyConsumptionType {
        PER_TICK,
        PER_PROCESS,
        NONE;

    }

    public static enum FluidConsumptionType {
        PER_TICK,
        PER_PROCESS,
        NONE;

    }
}

