/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyBlockEntity
extends BlockEntity
implements MenuProvider {
    protected BioEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> energyCap;
    protected final RandomSource rand = RandomSource.m_216327_();

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage) {
        super(type, pos, state);
        this.createEnergyStorage(energyStorage, false);
    }

    public void createEnergyStorage(int maxEnergy, boolean inherit) {
        BioEnergyStorage storage = new BioEnergyStorage(maxEnergy);
        if (inherit && this.energyStorage != null) {
            storage.receiveEnergy(this.energyStorage.getEnergyStored());
        }
        this.energyStorage = storage;
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
    }

    public static ContainerData createContainerData(final IntSupplier[] get, final IntConsumer[] set) {
        return new ContainerData(){

            public int m_6413_(int index) {
                return get[index].getAsInt();
            }

            public void m_8050_(int index, int value) {
                set[index].accept(value);
            }

            public int m_6499_() {
                return Math.min(get.length, set.length);
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        if (be instanceof EnergyBlockEntity) {
            EnergyBlockEntity ebe = (EnergyBlockEntity)be;
            ebe.doUpdate();
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void doUpdate() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == ForgeCapabilities.ENERGY ? this.energyCap.cast() : super.getCapability(capability, facing);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("energy", (Tag)this.energyStorage.serializeNBT());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.energyStorage.deserializeNBT(compound.m_128469_("energy"));
    }

    public String getNameString() {
        return "default";
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public int getUpgradeSlot() {
        return -1;
    }

    public abstract ContainerData getContainerData();

    public Component m_5446_() {
        return Component.m_237115_((String)("container." + this.getNameString()));
    }

    public void notifyClient() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public boolean requireSyncUponOpen() {
        return false;
    }
}

