/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.items.TierItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class ConvertEnergyInventoryFluidBlockEntity
extends EnergyInventoryFluidBlockEntity {
    public ConvertEnergyInventoryFluidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, pos, state, energyStorage, invSize, maxBiomassStorage, tier);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.energyStorage.getEnergyStored() >= this.energyPerAction() && this.hasEnoughFluid()) {
            ItemStack input = this.getInput();
            ItemStack output = this.getOutput();
            if (!input.m_41619_() && this.canProceed(input, output)) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    this.increaseProgress();
                    if (this.getEnergyConsumptionType() == EnergyInventoryBlockEntity.EnergyConsumptionType.PER_TICK) {
                        this.energyStorage.extractEnergy(this.energyPerAction(), false);
                    }
                    if (this.getFluidConsumptionType() == EnergyInventoryBlockEntity.FluidConsumptionType.PER_TICK) {
                        this.drain(this.fluidPerAction(), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else if (this.onProcessFinished(input, output)) {
                    if (this.getEnergyConsumptionType() != EnergyInventoryBlockEntity.EnergyConsumptionType.NONE) {
                        this.energyStorage.extractEnergy(this.energyPerAction(), false);
                    }
                    if (this.getFluidConsumptionType() != EnergyInventoryBlockEntity.FluidConsumptionType.NONE) {
                        this.drain(this.remainingFluid(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.resetProgress(true);
                    this.addKnowledge();
                }
            } else {
                this.resetProgress(false);
            }
        }
    }

    protected boolean hasEnoughFluid() {
        return this.currentBiomass() >= this.fluidPerAction();
    }

    protected abstract boolean canProceed(ItemStack var1, ItemStack var2);

    protected abstract ItemStack getResult(ItemStack var1, ItemStack var2);

    protected int remainingFluid() {
        return this.fluidPerAction();
    }

    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).m_41619_()) {
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    protected void resetProgress(boolean forced) {
        if (this.shouldResetProgressIfNotProcessing() || forced) {
            super.resetProgress(forced);
        }
    }

    protected boolean shouldResetProgressIfNotProcessing() {
        return true;
    }

    public int getInputSlotIndex() {
        return 0;
    }

    public int getOutputSlotIndex() {
        return 1;
    }

    public ItemStack getInput() {
        return this.itemhandler.getStackInSlot(this.getInputSlotIndex());
    }

    public ItemStack getOutput() {
        return this.itemhandler.getStackInSlot(this.getOutputSlotIndex());
    }

    public int fluidPerAction() {
        return 5 + this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 3;
    }

    protected EnergyInventoryBlockEntity.FluidConsumptionType getFluidConsumptionType() {
        return EnergyInventoryBlockEntity.FluidConsumptionType.PER_TICK;
    }
}

