/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.inventory.SeedSqueezerMenu;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SeedSqueezerBlockEntity
extends EnergyInventoryFluidBlockEntity {
    protected final ContainerData data = SeedSqueezerBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), this::currentBiomass, this::getTankCapacity, () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), this::forceSetStorage, this::setTankCapacity, value -> {
        this.ticksPassed = value;
    }});

    public SeedSqueezerBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.SEEDSQUEEZER.get()).m_49966_());
    }

    public SeedSqueezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SEEDSQUEEZER_TE.get(), pos, state, 10000, 16, 5000, 0);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, 9, handler -> handler.setConditions(stack -> stack.m_41720_() instanceof CropSeedItem));
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            int i;
            if (this.itemhandler.getStackInSlot(9).m_41619_() && (i = this.getSqueezeableItem()) != -1) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                ItemStack stack2 = stack.m_41777_();
                stack2.m_41764_(1);
                this.itemhandler.setStackInSlot(9, stack2);
                stack.m_41774_(1);
            }
            if (!this.itemhandler.getStackInSlot(9).m_41619_()) {
                ItemStack stack = this.itemhandler.getStackInSlot(9);
                if (stack.m_41613_() == 1 && stack.m_41720_() instanceof CropSeedItem) {
                    this.ticksPassed += this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) + 1;
                    if (this.ticksPassed >= this.ticksPerItem()) {
                        this.squeezeItem();
                        this.addKnowledge();
                        this.forceChangeStorage(10);
                        this.resetProgress(true);
                    }
                } else if (stack.m_41613_() > 0) {
                    if (!this.f_58857_.f_46443_) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_(), stack));
                        this.itemhandler.setStackInSlot(9, ItemStack.f_41583_);
                    }
                } else if (this.ticksPassed > 0) {
                    this.resetProgress(false);
                }
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private int getSqueezeableItem() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof CropSeedItem)) continue;
            return i;
        }
        return -1;
    }

    public void squeezeItem() {
        this.energyStorage.receiveEnergy(this.getEnergyPerItem(), false);
        this.itemhandler.setStackInSlot(9, ItemStack.f_41583_);
    }

    @Override
    public int ticksPerItem() {
        return 200;
    }

    public int getEnergyPerItem() {
        ItemStack stack = this.itemhandler.getStackInSlot(9);
        if (stack.m_41720_() instanceof CropSeedItem) {
            TraitsManager.ItemImpl manager = TraitsManager.ItemImpl.of(stack);
            return manager.getTrait(CropTraitsTypes.ENERGY_VALUE) * 20;
        }
        return 20;
    }

    @Override
    public String getNameString() {
        return "seedsqueezer";
    }

    @Override
    public int getFluidInSlot() {
        return 11;
    }

    @Override
    public int getFluidOutSlot() {
        return 12;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new SeedSqueezerMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 2;
    }

    @Override
    public int getUpgradeSlot() {
        return 10;
    }
}

