/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.Collection;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.inventory.PlantFarmMenu;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PlantFarmBlockEntity
extends EnergyInventoryFluidBlockEntity {
    private int[] progress = new int[5];
    protected final ContainerData data = PlantFarmBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), this::currentBiomass, this::getTankCapacity, () -> this.progress[0], () -> this.progress[1], () -> this.progress[2], () -> this.progress[3], () -> this.progress[4]}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), this::forceSetStorage, this::setTankCapacity, value -> {
        this.progress[0] = value;
    }, value -> {
        this.progress[1] = value;
    }, value -> {
        this.progress[2] = value;
    }, value -> {
        this.progress[3] = value;
    }, value -> {
        this.progress[4] = value;
    }});

    public PlantFarmBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.PLANTFARM.get()).m_49966_());
    }

    public PlantFarmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PLANTFARM_TE.get(), pos, state, 1000, 18, 5000, 5);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(0).setConditions(PlantFarmBlockEntity::isSeed));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, 1, 11);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        ItemStack seed = this.itemhandler.getStackInSlot(0);
        if (PlantFarmBlockEntity.isSeed(seed)) {
            for (int i = 0; i <= this.getRange(); ++i) {
                if (this.progress[i] < this.getTicks(seed)) {
                    int n = i;
                    this.progress[n] = this.progress[n] + (this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 5 + 1);
                    continue;
                }
                if (this.energyStorage.getEnergyStored() > this.energyPerAction()) {
                    NonNullList<ItemStack> drops = this.getDrops(seed);
                    if (drops.isEmpty()) continue;
                    for (ItemStack stack : drops) {
                        for (int k = 0; k < 15; ++k) {
                            if (stack.m_41619_()) continue;
                            stack = this.itemhandler.insertItem(k, stack, false);
                        }
                        if (stack.m_41619_()) continue;
                        PlantFarmBlockEntity.spawnAsEntity(this.f_58857_, this.f_58858_.m_7494_(), stack);
                    }
                    this.energyStorage.extractEnergy(this.energyPerAction(), false);
                    this.progress[i] = 0;
                    this.addKnowledge();
                    continue;
                }
                this.resetProgress(false);
                break;
            }
        } else {
            this.resetProgress(false);
        }
    }

    @Override
    protected void resetProgress(boolean forced) {
        for (int i = 0; i <= this.getRange(); ++i) {
            this.progress[i] = 0;
        }
    }

    public static boolean isSeed(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CropSeedItem) {
            return true;
        }
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            Block block = bi.m_40614_();
            return block instanceof CropBlock;
        }
        return false;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private int getTicks(ItemStack stack) {
        if (stack.m_41720_() instanceof CropSeedItem) {
            TraitsManager.ItemImpl manager = TraitsManager.ItemImpl.of(stack);
            return (90 - manager.getTrait(CropTraitsTypes.GROW_SPEED) * 6) * 20 * 7;
        }
        return 12600;
    }

    public int getTicks() {
        return this.getTicks(this.itemhandler.getStackInSlot(0));
    }

    private NonNullList<ItemStack> getDrops(ItemStack stack) {
        NonNullList drops = NonNullList.m_122779_();
        if (this.f_58857_ != null) {
            Block block;
            Item item = stack.m_41720_();
            if (item instanceof CropSeedItem) {
                TraitsManager.ItemImpl traits = TraitsManager.ItemImpl.of(stack);
                traits.type.calculateDropsReduced((NonNullList<ItemStack>)drops, traits, 7, this.f_58857_.f_46441_);
                return drops;
            }
            if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    drops.addAll((Collection)Block.m_49869_((BlockState)crop.m_52289_(crop.m_7419_()), (ServerLevel)sl, (BlockPos)this.f_58858_, null));
                }
            }
        }
        return drops;
    }

    private int getRange() {
        TierItem ti;
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(12);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof TierItem && (ti = (TierItem)item).getItemType() == TierItem.ItemType.RANGE_UPGRADE) {
            return ti.getTier();
        }
        return 0;
    }

    @Override
    public int getUpgradeSlot() {
        return 11;
    }

    @Override
    public int energyPerAction() {
        return 400;
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128385_("progress", this.progress);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.progress = compound.m_128465_("progress");
        if (this.progress.length == 0) {
            this.progress = new int[5];
        }
    }

    @Override
    public String getNameString() {
        return "plantfarm";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new PlantFarmMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 15;
    }

    @Override
    public int getEnergyOutSlot() {
        return 16;
    }

    @Override
    public int getFluidInSlot() {
        return 13;
    }

    @Override
    public int getFluidOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 17;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

