/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.MegaFurnaceMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MegaFurnaceBlockEntity
extends EnergyInventoryBlockEntity {
    public int[] ticksPassed = new int[6];
    boolean isSmelting;
    protected ItemStackHandler dummyitemhandler = new ItemStackHandler();
    protected final ContainerData data = MegaFurnaceBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed[0], () -> this.ticksPassed[1], () -> this.ticksPassed[2], () -> this.ticksPassed[3], () -> this.ticksPassed[4], () -> this.ticksPassed[5]}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed[0] = value;
    }, value -> {
        this.ticksPassed[1] = value;
    }, value -> {
        this.ticksPassed[2] = value;
    }, value -> {
        this.ticksPassed[3] = value;
    }, value -> {
        this.ticksPassed[4] = value;
    }, value -> {
        this.ticksPassed[5] = value;
    }});

    public MegaFurnaceBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.MEGAFURNACE.get()).m_49966_());
    }

    public MegaFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MEGAFURNACE_TE.get(), pos, state, 10000, 16, 3);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, 6);
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, 6, 12);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        this.isSmelting = false;
        for (int i = 0; i < 6; ++i) {
            if (this.energyStorage.getEnergyStored() > this.energyPerAction()) {
                if (this.canSmelt(i)) {
                    this.isSmelting = true;
                    int n = i;
                    this.ticksPassed[n] = this.ticksPassed[n] + 1;
                    if (this.ticksPassed[i] < this.ticksPerItem()) continue;
                    this.smeltItem(i);
                    this.ticksPassed[i] = 0;
                    this.addKnowledge();
                    continue;
                }
                if (this.ticksPassed[i] <= 0) continue;
                this.ticksPassed[i] = 0;
                continue;
            }
            if (this.canSmelt(i) || this.ticksPassed[i] <= 0) break;
            this.ticksPassed[i] = 0;
            break;
        }
        if (this.isSmelting) {
            this.energyStorage.extractEnergy(this.energyPerAction(), false);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private boolean canSmelt(int slot) {
        ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack output = this.getOutput(slot);
        if (output.m_41619_()) {
            return false;
        }
        ItemStack outputslot = this.itemhandler.getStackInSlot(slot + 6);
        if (outputslot.m_41619_()) {
            return true;
        }
        if (output.m_41720_() != outputslot.m_41720_()) {
            return false;
        }
        if (outputslot.m_41613_() + output.m_41613_() <= 64 && outputslot.m_41613_() + output.m_41613_() <= outputslot.m_41741_()) {
            return true;
        }
        return outputslot.m_41613_() + output.m_41613_() <= output.m_41741_();
    }

    public ItemStack getOutput(int slot) {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        this.dummyitemhandler.setStackInSlot(0, this.itemhandler.getStackInSlot(slot));
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.dummyitemhandler);
        Optional recipeopt = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)wrapper, this.f_58857_);
        SmeltingRecipe recipe = recipeopt.orElse(null);
        return recipe == null ? ItemStack.f_41583_ : recipe.m_8043_(this.f_58857_.m_9598_());
    }

    public void smeltItem(int slot) {
        if (this.canSmelt(slot)) {
            ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
            ItemStack itemstack1 = this.getOutput(slot);
            ItemStack itemstack2 = this.itemhandler.getStackInSlot(slot + 6);
            if (itemstack2.m_41619_()) {
                this.itemhandler.setStackInSlot(slot + 6, itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128385_("cooktime", this.ticksPassed);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ticksPassed = compound.m_128465_("cooktime");
        if (this.ticksPassed.length == 0) {
            this.ticksPassed = new int[6];
        }
    }

    @Override
    public String getNameString() {
        return "megafurnace";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MegaFurnaceMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }

    @Override
    public int getUpgradeSlot() {
        return 12;
    }
}

