/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.MachineBulbReprocessorMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class MachineBulbReprocessorBlockEntity
extends ConvertEnergyInventoryFluidBlockEntity {
    private int selectedId = 0;
    private int actualTier = 0;
    protected final ContainerData data = MachineBulbReprocessorBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), this::currentBiomass, this::getTankCapacity, () -> this.ticksPassed, () -> this.selectedId, () -> this.actualTier}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), this::forceSetStorage, this::setTankCapacity, value -> {
        this.ticksPassed = value;
    }, value -> {
        this.selectedId = value;
    }, value -> {
        this.actualTier = value;
    }});

    public MachineBulbReprocessorBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.MACHINEBULBREPROCESSOR.get()).m_49966_());
    }

    public MachineBulbReprocessorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MACHINEBULBREPROCESSOR_TE.get(), pos, state, 5000, 8, 5000, 0);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getInputSlotIndex()).setConditions(stack -> stack.m_204117_(Tags.Items.SEEDS) || stack.m_41720_() instanceof CropSeedItem));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getOutputSlotIndex()));
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (this.selectedId < 1 || this.selectedId > ModItems.MACHINE_BULBS.size()) {
            return false;
        }
        MachineBulbItem bulb = (MachineBulbItem)((Object)ModItems.MACHINE_BULBS.get(this.selectedId - 1).get());
        if (bulb.getTier() > this.actualTier) {
            return false;
        }
        return input.m_204117_(Tags.Items.SEEDS) || input.m_41720_() instanceof CropSeedItem;
    }

    @Override
    protected EnergyInventoryBlockEntity.EnergyConsumptionType getEnergyConsumptionType() {
        return EnergyInventoryBlockEntity.EnergyConsumptionType.PER_PROCESS;
    }

    @Override
    protected EnergyInventoryBlockEntity.FluidConsumptionType getFluidConsumptionType() {
        return EnergyInventoryBlockEntity.FluidConsumptionType.PER_PROCESS;
    }

    @Override
    public int fluidPerAction() {
        if (this.selectedId < 1) {
            return 0;
        }
        return ((MachineBulbItem)((Object)ModItems.MACHINE_BULBS.get(this.selectedId - 1).get())).getNeededBiomass();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        if (this.selectedId < 1) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)ModItems.MACHINE_BULBS.get(this.selectedId - 1).get());
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        this.checkTier();
    }

    public void checkTier() {
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof KnowledgeChip) {
            KnowledgeChip kc = (KnowledgeChip)item;
            this.actualTier = kc.getTier();
            return;
        }
        this.actualTier = 0;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public int energyPerAction() {
        return 1000;
    }

    @Override
    public int ticksPerItem() {
        return 300;
    }

    @Override
    public String getNameString() {
        return "machinebulbreprocessor";
    }

    @Override
    public int getFluidInSlot() {
        return 2;
    }

    @Override
    public int getFluidOutSlot() {
        return 3;
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MachineBulbReprocessorMenu(id, inv, this);
    }

    public void setSelectedId(int buttonId) {
        this.selectedId = buttonId;
    }

    @Override
    public int getKnowledgePerAction() {
        return 10;
    }
}

