/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.inventory.InfuserMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class InfuserBlockEntity
extends ConvertEnergyInventoryFluidBlockEntity {
    private int fluidTotal = 0;
    private ItemStack output = null;
    protected final ContainerData data = InfuserBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), this::currentBiomass, this::getTankCapacity, () -> this.ticksPassed, () -> this.fluidTotal}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), this::forceSetStorage, this::setTankCapacity, value -> {
        this.ticksPassed = value;
    }, value -> {
        this.fluidTotal = value;
    }});

    public InfuserBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.INFUSER.get()).m_49966_());
    }

    public InfuserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.INFUSER_TE.get(), pos, state, 1000, 8, 5000, 2);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getInputSlotIndex()));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getOutputSlotIndex()));
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (input.m_41619_()) {
            return false;
        }
        InfuserRecipe recipe = this.getOutputRecipe();
        if (recipe == null) {
            return false;
        }
        if (this.output == null || this.output.m_41619_()) {
            this.output = recipe.getOutput().m_41777_();
            this.fluidTotal = recipe.getBiomass();
        }
        return ItemStack.m_41656_((ItemStack)recipe.getOutput(), (ItemStack)this.output);
    }

    @Override
    protected void resetProgress(boolean forced) {
        super.resetProgress(forced);
        this.output = null;
        this.fluidTotal = 0;
    }

    @Override
    public int ticksPerItem() {
        return this.fluidTotal > 0 ? this.fluidTotal : 100;
    }

    @Override
    protected void increaseProgress() {
        this.ticksPassed += this.fluidPerAction();
    }

    @Override
    protected int remainingFluid() {
        return this.fluidTotal - this.ticksPassed;
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        return this.getOutputRecipe() == null ? ItemStack.f_41583_ : this.getOutputRecipe().m_8043_(this.f_58857_.m_9598_()).m_41777_();
    }

    @Override
    protected boolean shouldResetProgressIfNotProcessing() {
        return false;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Nullable
    private InfuserRecipe getOutputRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.INFUSING.get(), (Container)new SimpleContainer(new ItemStack[]{this.getInput()}), this.f_58857_).orElse(null);
    }

    @Override
    public String getNameString() {
        return "infuser";
    }

    @Override
    public int getFluidInSlot() {
        return 3;
    }

    @Override
    public int getFluidOutSlot() {
        return 4;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new InfuserMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 5;
    }

    @Override
    public int getEnergyOutSlot() {
        return 6;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 7;
    }

    @Override
    public int getKnowledgePerAction() {
        return 150;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }
}

