/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.inventory.IdentifierMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class IdentifierBlockEntity
extends EnergyInventoryBlockEntity {
    protected final ContainerData data = IdentifierBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }});

    public IdentifierBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.IDENTIFIER.get()).m_49966_());
    }

    public IdentifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.IDENTIFIER_TE.get(), pos, state, 10000, 22, 1);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, 9, handler -> handler.setConditions(stack -> stack.m_41720_() instanceof CropSeedItem));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, 9, 18);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.energyStorage.getEnergyStored() > this.energyPerAction()) {
            if (this.canIdentify()) {
                this.energyStorage.extractEnergy(this.energyPerAction(), false);
                ++this.ticksPassed;
                if (this.ticksPassed >= this.ticksPerItem()) {
                    this.identifyItem();
                    this.ticksPassed = 0;
                }
            } else {
                this.ticksPassed = 0;
            }
        } else if (!this.canIdentify() && this.ticksPassed > 0) {
            this.ticksPassed = 0;
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private boolean canIdentify() {
        if (!this.hasFreeOutputSlot()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                if (!nbt.m_128441_("analysed") || nbt.m_128471_("analysed")) continue;
                return true;
            }
            return CropTypes.getBySeed(stack).isPresent();
        }
        return false;
    }

    public void identifyItem() {
        if (this.canIdentify()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                CompoundTag nbt = stack.m_41783_();
                if (nbt != null) {
                    if (!nbt.m_128441_("analysed") || nbt.m_128471_("analysed")) continue;
                    nbt.m_128379_("analysed", true);
                    stack.m_41751_(nbt);
                    this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), stack);
                    this.itemhandler.setStackInSlot(i, ItemStack.f_41583_);
                    this.addKnowledge();
                    break;
                }
                int finalI = i;
                CropTypes.getBySeed(stack).ifPresent(entry -> {
                    TraitsManager.ItemImpl newtraits = TraitsManager.ItemImpl.of(stack);
                    newtraits.type = entry;
                    newtraits.analysed = true;
                    newtraits.save();
                    ItemStack result = TraitsManager.ItemImpl.of((ItemStack)new ItemStack((ItemLike)((ItemLike)entry.getConfig().getPrimarySeed().getItem().get()), (int)stack.m_41613_()), (CompoundTag)newtraits.serializeNBT()).stack;
                    this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), result);
                    this.itemhandler.setStackInSlot(finalI, ItemStack.f_41583_);
                    this.addKnowledge();
                });
            }
        }
    }

    public boolean hasFreeOutputSlot() {
        return this.getFreeOutputSlot() != -1;
    }

    public int getFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getNameString() {
        return "identifier";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new IdentifierMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 19;
    }

    @Override
    public int getEnergyOutSlot() {
        return 20;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 21;
    }

    @Override
    public int getKnowledgePerAction() {
        return 5;
    }

    @Override
    public int getUpgradeSlot() {
        return 18;
    }
}

