/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.HashSet;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.baseclasses.BaseElectricFence;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.blocks.machines.EnergySupplierBlock;
import net.kaneka.planttech2.inventory.EnergySupplierMenu;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergySupplierBlockEntity
extends EnergyInventoryBlockEntity {
    protected final ContainerData data = EnergySupplierBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }});

    public EnergySupplierBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.ENERGY_SUPPLIER.get()).m_49966_());
    }

    public EnergySupplierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ENERGY_SUPPLIER_TE.get(), pos, state, 1000, 3, 2);
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        super.onContainerUpdated(slotIndex);
        if (slotIndex == this.getUpgradeSlot()) {
            this.createEnergyStorage(1000, true);
        }
    }

    @Override
    public void createEnergyStorage(int maxEnergy, boolean inherit) {
        super.createEnergyStorage((int)((double)maxEnergy * Math.pow(10.0, this.getCapacityUpgrade())), inherit);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ == null) {
            return;
        }
        ++this.ticksPassed;
        if (this.energyStorage.getEnergyStored() <= 0) {
            this.setPower(false);
        } else if (!this.getConnected().isEmpty() && this.ticksPassed >= this.ticksPerItem()) {
            this.energyStorage.extractEnergy(this.energyPerAction());
            this.setPower(true);
            this.resetProgress(true);
        }
    }

    private void setPower(boolean powered) {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof EnergySupplierBlock) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_60734_().m_49966_().m_61124_((Property)EnergySupplierBlock.SUPPLYING, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private HashSet<BlockPos> getConnected() {
        HashSet<BlockPos> list = new HashSet<BlockPos>();
        if (this.f_58857_ != null) {
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = this.f_58858_.m_121945_(direction);
                if (!(this.f_58857_.m_8055_(blockPos).m_60734_() instanceof BaseElectricFence)) continue;
                list.add(blockPos);
            }
        }
        return list;
    }

    @Override
    public int energyPerAction() {
        return 1;
    }

    @Override
    public int ticksPerItem() {
        return 10;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public String getNameString() {
        return "energysupplier";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new EnergySupplierMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 0;
    }

    @Override
    public int getEnergyOutSlot() {
        return 1;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 0;
    }

    @Override
    public int getKnowledgePerAction() {
        return 0;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }
}

