/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.inventory.DNAExtractorMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DNAExtractorBlockEntity
extends EnergyInventoryBlockEntity {
    protected final ContainerData data = DNAExtractorBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }});

    public DNAExtractorBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.DNA_EXTRACTOR.get()).m_49966_());
    }

    public DNAExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DNAEXTRACTOR_TE.get(), pos, state, 1000, 7, 4);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(0).setConditions(stack -> stack.m_41720_() instanceof CropSeedItem), DNAExtractorBlockEntity.ofDNAContainer(1, true));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(2));
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.energyStorage.getEnergyStored() > this.energyPerAction()) {
            ItemStack stack1 = this.itemhandler.getStackInSlot(0);
            ItemStack stack2 = this.itemhandler.getStackInSlot(1);
            ItemStack stack3 = this.itemhandler.getStackInSlot(2);
            if (!stack1.m_41619_() && !stack2.m_41619_() && stack1.m_41720_() instanceof CropSeedItem && stack2.m_41720_() == ModItems.DNA_CONTAINER_EMPTY.get() && stack1.m_41782_()) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    ++this.ticksPassed;
                    this.energyStorage.extractEnergy(this.energyPerAction(), false);
                } else {
                    CompoundTag nbt = TraitsManager.ItemImpl.of(stack1).serializeNBT();
                    nbt.m_128473_("analysed");
                    ItemStack result = TraitsManager.ItemImpl.of((ItemStack)new ItemStack((ItemLike)((ItemLike)ModItems.DNA_CONTAINER.get())), (CompoundTag)nbt).stack;
                    if (stack3.m_41619_()) {
                        this.itemhandler.setStackInSlot(2, result);
                        this.endProcess();
                        this.addKnowledge();
                    } else if (ItemStack.m_150942_((ItemStack)result, (ItemStack)stack3)) {
                        stack3.m_41769_(1);
                        this.addKnowledge();
                        this.endProcess();
                    }
                }
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private void endProcess() {
        this.ticksPassed = 0;
        this.itemhandler.getStackInSlot(0).m_41774_(1);
        this.itemhandler.getStackInSlot(1).m_41774_(1);
    }

    @Override
    public String getNameString() {
        return "dnaextractor";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new DNAExtractorMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }

    @Override
    public int getUpgradeSlot() {
        return 3;
    }
}

