/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryBlockEntity;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.inventory.DNACombinerMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DNACombinerBlockEntity
extends ConvertEnergyInventoryBlockEntity {
    protected final ContainerData data = DNACombinerBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }});

    public DNACombinerBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.DNA_COMBINER.get()).m_49966_());
    }

    public DNACombinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DNACOMBINER_TE.get(), pos, state, 1000, 8, 4);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, DNACombinerBlockEntity.ofDNAContainer(0, false), DNACombinerBlockEntity.ofDNAContainer(1, false), DNACombinerBlockEntity.ofDNAContainer(2, true));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getOutputSlotIndex()));
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        return !input.m_41619_() && !this.getInput2().m_41619_() && !this.getInput3().m_41619_();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        CompoundTag nbt = this.getCombinedNBT(this.getInput2(), this.getInput3());
        ItemStack stack = new ItemStack((ItemLike)ModItems.DNA_CONTAINER.get());
        stack.m_41751_(nbt);
        return stack;
    }

    private ItemStack getInput2() {
        return this.itemhandler.getStackInSlot(0);
    }

    private ItemStack getInput3() {
        return this.itemhandler.getStackInSlot(1);
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private CompoundTag getCombinedNBT(ItemStack stack, ItemStack stack2) {
        TraitsManager.ItemImpl trait = TraitsManager.ItemImpl.of(stack);
        TraitsManager.ItemImpl trait2 = TraitsManager.ItemImpl.of(stack2);
        TraitsManager.TypedImpl combined = new TraitsManager.TypedImpl();
        combined.type = trait.type == trait2.type ? trait.type : (trait.type != null ? trait.type : trait2.type);
        for (CropTraitsTypes cropTrait : CropTraitsTypes.values()) {
            boolean hasT = trait.hasTrait(cropTrait);
            boolean hasT2 = trait2.hasTrait(cropTrait);
            int t = trait.getTrait(cropTrait);
            int t2 = trait2.getTrait(cropTrait);
            if (hasT && hasT2) {
                combined.setTrait(cropTrait, Math.min(t, t2));
                continue;
            }
            if (hasT) {
                combined.setTrait(cropTrait, t);
                continue;
            }
            if (!hasT2) continue;
            combined.setTrait(cropTrait, t2);
        }
        return combined.serializeNBT();
    }

    @Override
    public String getNameString() {
        return "dnacombiner";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new DNACombinerMenu(id, inv, this);
    }

    @Override
    public int getInputSlotIndex() {
        return 2;
    }

    @Override
    public int getOutputSlotIndex() {
        return 3;
    }

    @Override
    public int getEnergyInSlot() {
        return 5;
    }

    @Override
    public int getEnergyOutSlot() {
        return 6;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 7;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }

    @Override
    public int getUpgradeSlot() {
        return 4;
    }
}

