/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.CompressorMenu;
import net.kaneka.planttech2.inventory.PT2ItemStackHandler;
import net.kaneka.planttech2.items.ParticleItem;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CompressorBlockEntity
extends ConvertEnergyInventoryBlockEntity {
    private int selectedId = -1;
    private List<Pair<ItemStack, ItemStack>> recipeList = new ArrayList<Pair<ItemStack, ItemStack>>();
    private Item previousInput = null;
    protected final ContainerData data = CompressorBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed, () -> this.selectedId}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }, this::setSelectedId});

    public CompressorBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.COMPRESSOR.get()).m_49966_());
    }

    public CompressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COMPRESSOR_TE.get(), pos, state, 1000, 26, 1);
    }

    @Override
    protected PT2ItemStackHandler createInsertables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getInputSlotIndex()).setConditions(stack -> stack.m_41720_() instanceof ParticleItem));
    }

    @Override
    protected PT2ItemStackHandler createExtractables() {
        return new PT2ItemStackHandler(this.itemhandler, PT2ItemStackHandler.Handler.of(this.getOutputSlotIndex()));
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        boolean recipeDone = false;
        boolean inputDone = false;
        if (this.recipeList == null || this.previousInput != input.m_41720_()) {
            this.initRecipeList();
        }
        if (this.getSelectedId() >= 0) {
            if (!this.recipeList.isEmpty() && this.recipeList.size() > this.getSelectedId()) {
                Pair<ItemStack, ItemStack> recipe = this.recipeList.get(this.getSelectedId());
                if (recipe.getB().m_41720_() == Items.f_42127_) {
                    this.setSelectedId(-1);
                    return false;
                }
                recipeDone = true;
                ItemStack ingredient = recipe.getA();
                boolean bl = inputDone = ingredient.m_41720_() == input.m_41720_() && ingredient.m_41613_() <= input.m_41613_();
                if (inputDone) {
                    this.previousInput = input.m_41720_();
                }
            } else {
                this.setSelectedId(-1);
            }
        }
        return this.getSelectedId() >= 0 && recipeDone && inputDone;
    }

    private int getSelectedId() {
        return this.selectedId - 1;
    }

    @Override
    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).m_41619_()) {
            input.m_41774_(this.recipeList.get(this.getSelectedId()).getA().m_41613_());
            return true;
        }
        return false;
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        return this.recipeList.get(this.getSelectedId()).getB().m_41777_();
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId + 1;
        this.notifyClient();
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        if (this.f_58857_ != null && (this.previousInput == null || this.previousInput.m_5456_() != this.itemhandler.getStackInSlot(0).m_41720_())) {
            this.initRecipeList();
        }
    }

    public void initRecipeList() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            this.itemhandler.setStackInSlot(i + 3, ItemStack.f_41583_);
        }
        this.selectedId = -1;
        this.previousInput = null;
        this.recipeList = new ArrayList<Pair<ItemStack, ItemStack>>();
        ItemStack input = this.itemhandler.getStackInSlot(0);
        if (!input.m_41619_() && this.f_58857_ != null) {
            for (CompressorRecipe recipe : this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.COMPRESSING.get())) {
                if (recipe.getInput().m_41720_() != input.m_41720_()) continue;
                for (ItemStack output : recipe.getOutput().m_43908_()) {
                    if (this.recipeList.size() > 18) continue;
                    this.itemhandler.setStackInSlot(this.recipeList.size() + 3, output.m_41777_());
                    this.recipeList.add(Pair.of(recipe.getInput().m_41777_(), output.m_41777_()));
                }
                this.previousInput = input.m_41720_();
            }
        }
        this.resetProgress(false);
    }

    @Override
    public String getNameString() {
        return "compressor";
    }

    @Override
    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 3; ++i) {
            stacks.add(this.itemhandler.getStackInSlot(i).m_41777_());
        }
        return stacks;
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("selectedId", this.getSelectedId());
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("selectedId")) {
            this.setSelectedId(compound.m_128451_("selectedId"));
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new CompressorMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 23;
    }

    @Override
    public int getEnergyOutSlot() {
        return 24;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 25;
    }

    @Override
    public int getKnowledgePerAction() {
        return 2;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }

    @Override
    public boolean requireSyncUponOpen() {
        return true;
    }
}

