/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.ChipalyzerMenu;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.ChipalyzerRecipe;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChipalyzerBlockEntity
extends ConvertEnergyInventoryBlockEntity {
    protected List<ChipalyzerRecipe> recipes = null;
    protected final ContainerData data = ChipalyzerBlockEntity.createContainerData(new IntSupplier[]{() -> this.energyStorage.getEnergyStored(), () -> this.energyStorage.getMaxEnergyStored(), () -> this.ticksPassed}, new IntConsumer[]{value -> this.energyStorage.setEnergyStored(value), value -> this.energyStorage.setEnergyMaxStored(value), value -> {
        this.ticksPassed = value;
    }});

    public ChipalyzerBlockEntity() {
        this(BlockPos.f_121853_, ((Block)ModBlocks.CHIPALYZER.get()).m_49966_());
    }

    public ChipalyzerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHIPALYZER_TE.get(), pos, state, 1000, 7, 2);
    }

    @Override
    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        boolean finished = super.onProcessFinished(input, output);
        if (finished) {
            this.getChip().m_41774_(1);
        }
        return finished;
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        return !this.getChip().m_41619_() && !this.getRecipeList(this.getChip(), input, false).isEmpty();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        List<ChipalyzerRecipe> recipe = this.getRecipeList(this.getChip(), input, false);
        return recipe.get(this.rand.m_188503_(recipe.size())).m_8043_(this.f_58857_.m_9598_()).m_41777_();
    }

    private ItemStack getChip() {
        return this.itemhandler.getStackInSlot(0);
    }

    private List<ChipalyzerRecipe> getRecipeList(ItemStack chip, ItemStack stack, boolean forceUpdate) {
        if (stack.m_41619_() || this.f_58857_ == null) {
            return Collections.emptyList();
        }
        if (this.recipes == null || forceUpdate) {
            ArrayList<ChipalyzerRecipe> list = new ArrayList<ChipalyzerRecipe>();
            for (ChipalyzerRecipe recipe : this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.CHIPALYZER.get())) {
                ItemStack fake = chip.m_41777_();
                fake.m_41764_(1);
                if (!ItemStack.m_41728_((ItemStack)recipe.getChip(), (ItemStack)fake) || !recipe.compare(chip, stack)) continue;
                list.add(recipe);
            }
            this.recipes = list;
            return list;
        }
        return this.recipes;
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        this.getRecipeList(this.getChip(), this.getInput(), true);
    }

    @Override
    public int getInputSlotIndex() {
        return 1;
    }

    @Override
    public int getOutputSlotIndex() {
        return 2;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public String getNameString() {
        return "chipalyzer";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new ChipalyzerMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    @Override
    public int getKnowledgePerAction() {
        return 100;
    }

    @Override
    public int getUpgradeSlot() {
        return 3;
    }
}

