/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.cable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.cable.CableInfo;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class CableBlockEntity
extends BlockEntity {
    public CableInfo cableInfo = new CableInfo();
    public final int maxTransferRate = 60;

    public CableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CABLE_TE.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)t;
            cable.tick();
        }
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isMaster()) {
            this.transferEnergy();
        }
    }

    private void transferEnergy() {
        AtomicInteger energyRequired = new AtomicInteger();
        AtomicInteger energySupplied = new AtomicInteger();
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.getEnergyCap(consumer.blockPos, consumer.direction.m_122424_()).ifPresent(cap -> {
                if (cap.canReceive()) {
                    energyRequired.addAndGet(Math.min(cap.getMaxEnergyStored() - cap.getEnergyStored(), this.getMaxTransferRate()));
                }
            });
        }
        for (CableInfo.Connection consumer : this.info().producers) {
            this.getEnergyCap(consumer.blockPos, consumer.direction.m_122424_()).ifPresent(cap -> {
                if (cap.canExtract()) {
                    energySupplied.addAndGet(Math.min(cap.getEnergyStored(), this.getMaxTransferRate()));
                }
            });
        }
        AtomicInteger energyRequired2 = new AtomicInteger(Math.min(energyRequired.get(), energySupplied.get()));
        AtomicInteger energySupplied2 = new AtomicInteger(energyRequired2.get());
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.getEnergyCap(consumer.blockPos, consumer.direction.m_122424_()).ifPresent(cap -> {
                int amount;
                if (cap.canReceive() && (amount = Math.min(Math.min(energyRequired2.get(), this.getMaxTransferRate()), cap.getMaxEnergyStored() - cap.getEnergyStored())) > 0) {
                    energyRequired2.addAndGet(-amount);
                    cap.receiveEnergy(amount, false);
                }
            });
        }
        for (CableInfo.Connection consumer : this.info().producers) {
            this.getEnergyCap(consumer.blockPos, consumer.direction.m_122424_()).ifPresent(cap -> {
                int amount;
                if (cap.canExtract() && (amount = Math.min(Math.min(energySupplied2.get(), this.getMaxTransferRate()), cap.getEnergyStored())) > 0) {
                    energySupplied2.addAndGet(-amount);
                    cap.extractEnergy(amount, false);
                }
            });
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("cableinfo", (Tag)this.cableInfo.write());
    }

    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        this.cableInfo = new CableInfo(p_155245_.m_128469_("cableinfo"));
    }

    public void initCable() {
        this.checkConnections();
        ArrayList<BlockPos> masters = new ArrayList<BlockPos>();
        this.getAllConnected(cable -> {
            BlockPos masterPos = cable.getMasterPos();
            if (!masters.contains(masterPos)) {
                masters.add(masterPos);
            }
        });
        if (!masters.isEmpty()) {
            if (masters.size() == 1) {
                CableBlockEntity master = this.getCableTE(masters.get(0));
                if (master != null) {
                    master.addCableToNetwork(this);
                }
                return;
            }
            CableBlockEntity largestNetwork = this.getLargestNetwork(masters);
            if (largestNetwork != null) {
                largestNetwork.addCableToNetwork(this);
                masters.remove(largestNetwork.m_58899_());
                masters.forEach(pos -> largestNetwork.mergeNetworks(this.getCableTE((BlockPos)pos)));
                return;
            }
        }
        this.createNetwork();
        this.getMasterCable().addMachinesFrom(this);
        this.m_6596_();
    }

    public void addCableToNetwork(CableBlockEntity cable) {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.add(cable.m_58899_());
        cable.updateMaster(this);
        this.addMachinesFrom(cable);
        this.m_6596_();
    }

    public List<BlockPos> getAllConnections(BlockPos master) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(master);
        return this.getAllConnections(positions);
    }

    public List<BlockPos> getAllConnections(HashSet<BlockPos> connected) {
        return this.getAllConnections(new ArrayList<BlockPos>(connected));
    }

    public List<BlockPos> getAllConnections(ArrayList<BlockPos> connected) {
        for (Direction direction : Direction.values()) {
            CableBlockEntity cable;
            BlockPos pos = this.m_58899_().m_121945_(direction);
            if (connected.contains(pos) || (cable = this.getCableTE(pos)) == null) continue;
            connected.add(pos);
            cable.getAllConnections(connected);
        }
        return connected;
    }

    public void refresh() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        this.clear(true);
        this.setIsMaster(true);
        this.getAllConnections(this.m_58899_()).forEach(pos -> {
            CableBlockEntity cable;
            if (!pos.equals((Object)this.m_58899_()) && (cable = this.getCableTE((BlockPos)pos)) != null) {
                this.info().slaves.add((BlockPos)pos);
                cable.updateMaster(this);
                this.addMachinesFrom(cable);
            }
        });
        this.addMachinesFrom(this);
        this.m_6596_();
    }

    public void addMachinesFrom(CableBlockEntity cable) {
        int[] connections = cable.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            CableInfo.Connection connection = new CableInfo.Connection(cable.m_58899_().m_121945_(Direction.m_122376_((int)i)), Direction.m_122376_((int)i));
            if (connections[i] < 2) {
                this.removeConsumer(connection);
                this.removeProducer(connection);
            }
            if (connections[i] == 2) {
                this.addConsumer(connection);
            }
            if (connections[i] != 3) continue;
            this.addProducer(connection);
        }
    }

    public void createNetwork() {
        if (this.f_58857_ == null) {
            return;
        }
        this.setIsMaster(true);
        this.refresh();
    }

    @Nullable
    public CableBlockEntity getLargestNetwork(ArrayList<BlockPos> masterPositions) {
        BlockPos largest = BlockPos.f_121853_;
        for (BlockPos pos : masterPositions) {
            CableBlockEntity largestCable = this.getCableTE(largest);
            CableBlockEntity targetCable = this.getCableTE(pos);
            if (largestCable != null) {
                if (targetCable == null || largestCable.info().slaves.size() >= targetCable.info().slaves.size()) continue;
                largest = pos;
                continue;
            }
            if (targetCable == null) continue;
            largest = pos;
        }
        return largest.equals((Object)BlockPos.f_121853_) ? null : this.getCableTE(largest);
    }

    public void checkConnections() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (te != null) {
                if (te instanceof CableBlockEntity) {
                    if (this.getConnection(direction) == 1) continue;
                    this.setConnection(direction, 1);
                    continue;
                }
                if (!te.getCapability(ForgeCapabilities.ENERGY, direction).isPresent() || this.getConnection(direction) >= 2) continue;
                this.setConnection(direction, 2);
                continue;
            }
            if (this.getConnection(direction) == 0) continue;
            this.setConnection(direction, 0);
        }
        this.m_6596_();
    }

    public void removeCable() {
        if (this.getMasterCable() != null) {
            this.getMasterCable().forceReplaceMaster();
            this.getMasterCable().getSlaves().remove(this.m_58899_());
        }
    }

    public void forceReplaceMaster() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.info().slaves.isEmpty()) {
            return;
        }
        for (BlockPos slave : this.info().slaves) {
            CableBlockEntity cable2 = this.getCableTE(slave);
            if (cable2 == null) continue;
            cable2.clear(true);
        }
        this.getAllConnected(cable -> {
            if (cable.getMasterPos().equals((Object)BlockPos.f_121853_)) {
                cable.createNetwork();
            }
        });
        this.m_6596_();
    }

    public void findNewMaster() {
        CableBlockEntity cable;
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        ArrayList<BlockPos> slaves = new ArrayList<BlockPos>(this.info().slaves);
        if (!slaves.isEmpty() && (cable = this.getCableTE(slaves.get(0))) != null) {
            cable.setAsMaster(this);
        }
    }

    public void mergeNetworks(CableBlockEntity otherMaster) {
        if (this.f_58857_ == null || !this.info().isMaster || otherMaster == null) {
            return;
        }
        CableInfo i = otherMaster.info();
        this.info().slaves.addAll(i.slaves);
        this.info().producers.addAll(i.producers);
        this.info().consumers.addAll(i.consumers);
        this.info().storages.addAll(i.storages);
        otherMaster.clear(true);
        this.info().slaves.add(otherMaster.m_58899_());
        this.updateSlavesMasterInfo();
    }

    public void setAsMaster(@Nullable CableBlockEntity oldMaster) {
        if (this.f_58857_ == null) {
            return;
        }
        this.setIsMaster(true);
        if (oldMaster != null) {
            CableInfo i = oldMaster.info();
            this.info().masterPos = oldMaster.m_58899_();
            this.info().slaves = i.slaves;
            this.info().producers = i.producers;
            this.info().consumers = i.consumers;
            this.info().storages = i.storages;
            this.updateSlavesMasterInfo();
        }
    }

    public void updateMaster(CableBlockEntity master) {
        this.updateMaster(master.m_58899_());
    }

    public void updateMaster(BlockPos master) {
        this.info().masterPos = master;
        this.info().isMaster = false;
    }

    public void updateSlavesMasterInfo() {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.forEach(slave -> {
            CableBlockEntity cable = this.getCableTE((BlockPos)slave);
            if (cable != null) {
                cable.updateMaster(this);
            }
        });
        this.m_6596_();
    }

    public boolean getAllConnected(Consumer<CableBlockEntity> message) {
        boolean changed = false;
        for (Direction direction : Direction.values()) {
            CableBlockEntity cable = this.getCableTE(this.m_58899_().m_121945_(direction));
            if (cable == null) continue;
            message.accept(cable);
            changed = true;
        }
        return changed;
    }

    private LazyOptional<IEnergyStorage> getEnergyCap(BlockPos pos, Direction facing) {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return LazyOptional.empty();
        }
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (this.f_58857_ instanceof ServerLevel && te != null) {
            return te.getCapability(ForgeCapabilities.ENERGY, facing);
        }
        return LazyOptional.empty();
    }

    public int getMaxTransferRate() {
        return 60;
    }

    public ArrayList<BlockPos> getPositionsOf(HashSet<CableInfo.Connection> connections) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        connections.forEach(connection -> positions.add(connection.blockPos));
        return positions;
    }

    public void setConnection(Direction facing, int i) {
        this.getConnections()[facing.m_122411_()] = i;
        if (this.getMasterCable() != null) {
            this.getMasterCable().addMachinesFrom(this);
        }
    }

    public int getConnection(Direction direction) {
        return this.getConnections()[direction.m_122411_()];
    }

    public void rotateConnection(Direction direction) {
        this.rotateConnection(direction.m_122411_());
    }

    public void rotateConnection(int direction) {
        int next = this.getConnections()[direction] + 1;
        if (next > 3) {
            next = 2;
        }
        this.setConnection(Direction.m_122376_((int)direction), next);
    }

    public ArrayList<BlockPos> getAllCables() {
        ArrayList<BlockPos> cables = new ArrayList<BlockPos>(this.info().slaves);
        cables.add(this.info().masterPos);
        return cables;
    }

    public void addConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().consumers, connection)) {
            this.info().consumers.add(connection);
            this.removeProducer(connection);
        }
    }

    public void addProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().producers, connection)) {
            this.info().producers.add(connection);
            this.removeConsumer(connection);
        }
    }

    public void removeConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().consumers, connection);
    }

    public void removeProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().producers, connection);
    }

    public boolean contains(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        return connections.stream().anyMatch(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public void remove(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        connections.removeIf(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public boolean equals(CableInfo.Connection connection, CableInfo.Connection connection2) {
        return connection.blockPos.equals((Object)connection2.blockPos) && connection.direction == connection2.direction;
    }

    public CableInfo info() {
        return this.cableInfo;
    }

    public void setIsMaster(boolean value) {
        this.info().isMaster = value;
        this.info().masterPos = this.m_58899_();
        this.info().slaves.remove(this.m_58899_());
    }

    public boolean isMaster() {
        return this.info().isMaster;
    }

    public BlockPos getMasterPos() {
        return this.info().masterPos;
    }

    public HashSet<BlockPos> getSlaves() {
        return this.info().slaves;
    }

    public HashSet<CableInfo.Connection> getConsumers() {
        return this.info().consumers;
    }

    public HashSet<CableInfo.Connection> getProducers() {
        return this.info().producers;
    }

    public HashSet<CableInfo.Connection> getStorages() {
        return this.info().storages;
    }

    public int[] getConnections() {
        return this.info().connections;
    }

    public void clear(boolean keepConnection) {
        this.cableInfo = this.cableInfo.clear(keepConnection);
        this.checkConnections();
    }

    @Nullable
    public CableBlockEntity getMasterCable() {
        return this.getCableTE(this.getMasterPos());
    }

    @Nullable
    public CableBlockEntity getCableTE(BlockPos pos) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(pos);
        return tileEntity instanceof CableBlockEntity ? (CableBlockEntity)tileEntity : null;
    }
}

