/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity;

import java.util.List;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.entities.passive.plant_mite.PlantMiteEntity;
import net.kaneka.planttech2.entities.passive.snail.SnailEntity;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.registries.ModBlockEntities;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CropsBlockEntity
extends BlockEntity {
    private long startTick = 0L;
    private TraitsManager.TypedImpl traits = new TraitsManager.TypedImpl();
    private boolean isSick = false;
    private int sickCheckTick = 0;
    private int lastSnailSpawn = 0;
    private int lastMiteSpawn = 0;
    public final Pair<CropTraitsTypes, Integer> chanceBoosts = Pair.of(null, 0);

    public CropsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CROPS_TE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        if (be instanceof CropsBlockEntity) {
            Block block;
            CropsBlockEntity cbe = (CropsBlockEntity)be;
            long time = level.m_46467_() - cbe.startTick;
            boolean update = false;
            if ((Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) < 7) {
                if (time % ((90L - (long)cbe.traits.getTrait(CropTraitsTypes.GROW_SPEED) * 6L) * 20L) == 0L) {
                    update = true;
                }
            } else if (time % ((80L - (long)cbe.traits.getTrait(CropTraitsTypes.SPREADING_SPEED) * 6L) * 20L) == 0L) {
                update = true;
            }
            if (update && (block = level.m_8055_(cbe.f_58858_).m_60734_()) instanceof CropBaseBlock) {
                CropBaseBlock cbb = (CropBaseBlock)block;
                cbb.updateCrop(level, cbe.f_58858_);
            }
            if (cbe.lastSnailSpawn-- <= 0) {
                cbe.lastSnailSpawn = 40 + level.f_46441_.m_188503_(100);
                float spawnChance = 0.001f;
                if (level.m_46758_(pos)) {
                    spawnChance += 0.004f;
                }
                if (level.m_46462_()) {
                    spawnChance += 0.003f;
                }
                if (level.f_46441_.m_188501_() <= spawnChance) {
                    SnailEntity snail = new SnailEntity((EntityType<SnailEntity>)((EntityType)ModEntityTypes.SNAIL.get()), level);
                    snail.setRandomVariant();
                    snail.m_146884_(Vec3.m_272021_((Vec3i)pos, (double)level.f_46441_.m_188501_(), (double)(level.f_46441_.m_188501_() * 0.5f), (double)level.f_46441_.m_188501_()));
                    snail.m_146922_(level.f_46441_.m_188501_() * 360.0f);
                    level.m_7967_((Entity)snail);
                }
            }
            if (cbe.lastMiteSpawn-- <= 0) {
                cbe.lastMiteSpawn = 20 + level.f_46441_.m_188503_(100);
                float spawnChance = 0.001f;
                if (level.f_46441_.m_188501_() <= spawnChance) {
                    PlantMiteEntity mite = new PlantMiteEntity((EntityType<PlantMiteEntity>)((EntityType)ModEntityTypes.PLANT_MITE.get()), level);
                    mite.m_146884_(Vec3.m_272021_((Vec3i)pos, (double)level.f_46441_.m_188501_(), (double)(level.f_46441_.m_188501_() * 0.5f), (double)level.f_46441_.m_188501_()));
                    mite.m_146922_(level.f_46441_.m_188501_() * 360.0f);
                    level.m_7967_((Entity)mite);
                }
            }
            if (cbe.sickCheckTick-- <= 0) {
                cbe.sickCheckTick = 2400 + level.f_46441_.m_188503_(2400);
                if (!cbe.isSick()) {
                    cbe.tryInfect();
                } else if (level.f_46441_.m_188499_()) {
                    if ((Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) > 1) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)CropBaseBlock.GROWSTATE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)CropBaseBlock.GROWSTATE) - 1)));
                    }
                } else {
                    Direction.Plane.HORIZONTAL.m_122557_().forEach(d -> {
                        BlockEntity patt4235$temp = level.m_7702_(pos.m_121945_(d));
                        if (patt4235$temp instanceof CropsBlockEntity) {
                            CropsBlockEntity crop = (CropsBlockEntity)patt4235$temp;
                            crop.tryInfect();
                        }
                    });
                }
            }
        }
    }

    public boolean isSick() {
        return this.isSick;
    }

    public void setSick(boolean sick) {
        this.isSick = sick;
        if (this.f_58857_ instanceof ServerLevel) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void tryInfect() {
        if (this.f_58857_.f_46441_.m_188501_() <= (float)(CropTraitsTypes.GENE_STRENGTH.getMax() - this.getTraits().getTrait(CropTraitsTypes.GENE_STRENGTH)) * 0.001f) {
            this.setSick(true);
        }
    }

    public void setTraits(TraitsManager.TypedImpl traits) {
        this.traits = traits;
    }

    public boolean isAnalysed() {
        return this.traits.analysed;
    }

    public TraitsManager.TypedImpl setAnalysedAndGetTraits() {
        this.traits.analysed = true;
        return this.getTraits();
    }

    public TraitsManager.TypedImpl getTraits() {
        return this.traits;
    }

    public void setStartTick() {
        this.startTick = this.f_58857_.m_46467_();
    }

    public List<ItemStack> addDrops(List<ItemStack> drops, int growstate) {
        return this.traits.type.calculateDrops(drops, this.traits, growstate, this.f_58857_.f_46441_);
    }

    public void dropsRemoveOneSeed(NonNullList<ItemStack> drops, int growstate) {
        this.traits.type.calculateDropsReduced(drops, this.traits, growstate, this.f_58857_.f_46441_);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128356_("starttick", this.startTick);
        compound.m_128391_(this.traits.serializeNBT());
        compound.m_128405_("lastSnailSpawn", this.lastSnailSpawn);
        compound.m_128405_("lastMiteSpawn", this.lastMiteSpawn);
        compound.m_128379_("isSick", this.isSick);
        compound.m_128405_("sickCheckTick", this.sickCheckTick);
        if (this.chanceBoosts.getA() != null) {
            compound.m_128359_("chanceBoostsA", this.chanceBoosts.getA().name());
            compound.m_128405_("chanceBoostsB", this.chanceBoosts.getB().intValue());
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.startTick = compound.m_128454_("starttick");
        this.traits.deserializeNBT(compound);
        this.lastSnailSpawn = compound.m_128451_("lastSnailSpawn");
        this.lastMiteSpawn = compound.m_128451_("lastMiteSpawn");
        this.isSick = compound.m_128471_("isSick");
        this.sickCheckTick = compound.m_128451_("sickCheckTick");
        if (compound.m_128441_("chanceBoostsA")) {
            this.chanceBoosts.set(CropTraitsTypes.valueOf(compound.m_128461_("chanceBoostsA")), compound.m_128451_("chanceBoostsB"));
        }
    }
}

