/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.baseclasses;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CustomFenceBlock
extends Block {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(facingProperty -> ((Direction)facingProperty.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected VoxelShape[] collisionShapes;
    protected VoxelShape[] shapes;
    private final Object2IntMap<BlockState> statePaletteMap = new Object2IntOpenHashMap();

    public CustomFenceBlock(BlockBehaviour.Properties property) {
        super(property);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.collisionShapes = this.makeShapes(1.0f, 1.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
    }

    public boolean canConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = state.m_204336_(BlockTags.f_13039_);
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        boolean flag2 = block instanceof CustomFenceBlock;
        return !CustomFenceBlock.m_152463_((BlockState)state) && isSideSolid || flag || flag1 || flag2;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockState blockstate = iblockreader.m_8055_(blockpos1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos3);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate, Block.m_49863_((LevelReader)iblockreader, (BlockPos)blockpos1, (Direction)Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(blockstate1, Block.m_49863_((LevelReader)iblockreader, (BlockPos)blockpos2, (Direction)Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(blockstate2, Block.m_49863_((LevelReader)iblockreader, (BlockPos)blockpos3, (Direction)Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(blockstate3, Block.m_49863_((LevelReader)iblockreader, (BlockPos)blockpos4, (Direction)Direction.EAST), Direction.EAST)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirrorIn);
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState, Block.m_49863_((LevelReader)level, (BlockPos)facingPos, (Direction)facing.m_122424_()), facing.m_122424_()))) : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected int getIndex(BlockState state) {
        return this.statePaletteMap.computeIntIfAbsent((Object)state, stateIn -> {
            int i = 0;
            if (((Boolean)stateIn.m_61143_((Property)NORTH)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.NORTH);
            }
            if (((Boolean)stateIn.m_61143_((Property)EAST)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.EAST);
            }
            if (((Boolean)stateIn.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.SOUTH);
            }
            if (((Boolean)stateIn.m_61143_((Property)WEST)).booleanValue()) {
                i |= CustomFenceBlock.getMask(Direction.WEST);
            }
            return i;
        });
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH});
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)nodeHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)extensionBottom, (double)0.0, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)16.0, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }
}

