/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.kaneka.planttech2.addons.Pair;
import net.kaneka.planttech2.blocks.ModBlockEntityBlock;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.enums.CropTraitsTypes;
import net.kaneka.planttech2.hashmaps.TraitsManager;
import net.kaneka.planttech2.items.AdvancedAnalyserItem;
import net.kaneka.planttech2.items.AnalyserItem;
import net.kaneka.planttech2.items.CropRemover;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropBaseBlock
extends ModBlockEntityBlock {
    public static final IntegerProperty GROWSTATE = IntegerProperty.m_61631_((String)"growstate", (int)0, (int)7);
    public static final BooleanProperty COPPER = BooleanProperty.m_61465_((String)"copper");
    private final CropTypes cropType;

    public CropBaseBlock(CropTypes cropType) {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60910_().m_60978_(0.5f));
        this.cropType = cropType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COPPER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return p_60558_.m_7142_((Item)ModItems.RAKE.get()) ? Shapes.m_83040_() : super.m_5940_(p_60555_, p_60556_, p_60557_, p_60558_);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        CropsBlockEntity crop;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CropsBlockEntity && (crop = (CropsBlockEntity)blockEntity).isSick()) {
            for (int i = 0; i < 4; ++i) {
                if (!(rand.m_188501_() <= 0.05f)) continue;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + rand.m_188501_()), (double)((float)pos.m_123342_() + rand.m_188501_()), (double)((float)pos.m_123343_() + rand.m_188501_()), 0.0, 0.0, 0.0);
            }
        }
    }

    public void updateCrop(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        int growth = (Integer)state.m_61143_((Property)GROWSTATE);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CropsBlockEntity) {
            CropsBlockEntity crop = (CropsBlockEntity)blockEntity;
            if (growth < 7 && this.canGrow(level, pos, crop.getTraits())) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(growth + 1)));
            } else {
                for (BlockPos neighbor : this.getNeighborBlockPosRandom(pos)) {
                    BlockState neightborState = level.m_8055_(neighbor);
                    if (neightborState.m_60734_() != ModBlocks.CROPBARS.get()) continue;
                    for (BlockPos neightbor2 : this.getNeighborBlockPosRandom(neighbor)) {
                        BlockEntity blockEntity2;
                        if (neightbor2.equals((Object)pos) || !((blockEntity2 = level.m_7702_(neightbor2)) instanceof CropsBlockEntity)) continue;
                        CropsBlockEntity partner = (CropsBlockEntity)blockEntity2;
                        TraitsManager.TypedImpl newTrait = crop.getTraits().calculateNewTraits(partner.getTraits(), crop.chanceBoosts.getA(), crop.chanceBoosts.getB());
                        crop.chanceBoosts.set(null, 0);
                        level.m_46597_(neighbor, (BlockState)newTrait.type.getCropBlock().m_49966_().m_61124_((Property)COPPER, (Comparable)((Boolean)neightborState.m_61143_((Property)COPPER))));
                        BlockEntity blockEntity3 = level.m_7702_(neighbor);
                        if (!(blockEntity3 instanceof CropsBlockEntity)) continue;
                        CropsBlockEntity crop2 = (CropsBlockEntity)blockEntity3;
                        crop2.setTraits(newTrait);
                        return;
                    }
                    if (level.m_8055_(neighbor).m_60734_() != ModBlocks.CROPBARS.get()) continue;
                    level.m_46597_(neighbor, (BlockState)crop.getTraits().type.getCropBlock().m_49966_().m_61124_((Property)COPPER, (Comparable)((Boolean)neightborState.m_61143_((Property)COPPER))));
                    BlockEntity blockEntity4 = level.m_7702_(neighbor);
                    if (!(blockEntity4 instanceof CropsBlockEntity)) continue;
                    CropsBlockEntity crop2 = (CropsBlockEntity)blockEntity4;
                    crop2.setTraits(crop.getTraits().copy());
                    return;
                }
            }
        }
    }

    public void updateCreative(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
        if (growstate < 7) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(7)));
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.m_122012_());
        neighbors.add(pos.m_122029_());
        neighbors.add(pos.m_122019_());
        neighbors.add(pos.m_122024_());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private boolean canGrow(Level level, BlockPos pos, TraitsManager.TypedImpl traits) {
        if (!this.enoughLight(level, pos, traits.getTrait(CropTraitsTypes.LIGHT_SENSITIVITY))) {
            return false;
        }
        if (!CropBaseBlock.enoughWater(level, pos, traits.getTrait(CropTraitsTypes.WATER_SENSITIVITY))) {
            return false;
        }
        if (!CropBaseBlock.rightSoil(level, pos, traits.type)) {
            return false;
        }
        return CropBaseBlock.rightTemperature(level, pos, traits.type, traits.getTrait(CropTraitsTypes.TEMPERATURE_TOLERANCE));
    }

    public String[] canGrowString(Level level, BlockPos pos) {
        String[] messages = new String[5];
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CropsBlockEntity) {
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            TraitsManager.TypedImpl traits = cbe.getTraits();
            if (!this.enoughLight(level, pos, traits.getTrait(CropTraitsTypes.LIGHT_SENSITIVITY))) {
                messages[1] = "planttech2.tip.crop.no_light";
            }
            if (!CropBaseBlock.enoughWater(level, pos, traits.getTrait(CropTraitsTypes.WATER_SENSITIVITY))) {
                messages[2] = "planttech2.tip.crop.no_water";
            }
            if (!CropBaseBlock.rightSoil(level, pos, traits.type)) {
                messages[3] = "planttech2.tip.crop.no_soil";
            }
            if (!CropBaseBlock.rightTemperature(level, pos, traits.type, traits.getTrait(CropTraitsTypes.TEMPERATURE_TOLERANCE))) {
                messages[4] = "planttech2.tip.crop.no_temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughLight(Level level, BlockPos pos, int lightsensitivity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return false;
        }
        return level.m_46849_(pos, 0) >= 14 - lightsensitivity;
    }

    public static boolean enoughWater(Level level, BlockPos pos, int waterSensitivity) {
        for (BlockPos blockpos$mutableblockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-(++waterSensitivity), -1, -waterSensitivity), (BlockPos)pos.m_7918_(waterSensitivity, -1, waterSensitivity))) {
            BlockState state = level.m_8055_(blockpos$mutableblockpos);
            if (!state.m_60819_().m_205070_(FluidTags.f_13131_) && (!state.m_61138_((Property)BlockStateProperties.f_61362_) || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean rightSoil(Level level, BlockPos pos, CropTypes type) {
        Block block = type.getConfig().getSoil().get();
        Block soil = level.m_8055_(pos.m_7495_()).m_60734_();
        return soil == block || soil == ModBlocks.UNIVERSAL_SOIL_INFUSED.get() || soil == Blocks.f_50440_ && block == Blocks.f_50493_;
    }

    public static boolean rightTemperature(Level level, BlockPos pos, CropTypes type, int tolerance) {
        return type.getConfig().getTemperature().inRange(((Biome)level.m_204166_(pos).m_203334_()).getModifiedClimateSettings().f_47681_(), (float)tolerance * 0.45f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWSTATE}).m_61104_(new Property[]{COPPER});
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest && !player.m_7500_() || super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        level.m_46961_(pos, false);
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && !levelIn.f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            if (((Map)ModItems.CATALYSTS.get()).containsKey(stack.m_41720_())) {
                BlockEntity blockEntity = levelIn.m_7702_(pos);
                if (blockEntity instanceof CropsBlockEntity) {
                    CropsBlockEntity te = (CropsBlockEntity)blockEntity;
                    Pair<CropTraitsTypes, Integer> pair = te.chanceBoosts;
                    Pair type = (Pair)((Map)ModItems.CATALYSTS.get()).get(stack.m_41720_());
                    if (pair.getA() == null || pair.getA() == ((Pair)type.getB()).getA()) {
                        pair.setA((CropTraitsTypes)((Object)((Pair)type.getB()).getA()));
                        if (pair.getB() < 20) {
                            pair.mapB(b -> Math.min(20, b + (Integer)((Pair)type.getB()).getB() * 2 + 1));
                            if (!player.m_7500_()) {
                                stack.m_41774_(1);
                            }
                            player.m_213846_((Component)Component.m_237110_((String)"planttech2.block.crop.catalyst_used", (Object[])new Object[]{pair.getB() + "%", pair.getA().getDisplayName()}));
                            return InteractionResult.SUCCESS;
                        }
                        player.m_213846_((Component)Component.m_237115_((String)"planttech2.block.crop.catalyst_use_failed"));
                        return InteractionResult.FAIL;
                    }
                    player.m_213846_((Component)Component.m_237110_((String)"planttech2.block.crop.catalyst_use_exists", (Object[])new Object[]{pair.getA().getDisplayName()}));
                    return InteractionResult.FAIL;
                }
            } else {
                int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
                if (growstate > 6) {
                    ItemStack holdItem = player.m_21120_(InteractionHand.MAIN_HAND);
                    if (!holdItem.m_41619_() && (holdItem.m_41720_() instanceof AnalyserItem || holdItem.m_41720_() instanceof AdvancedAnalyserItem || holdItem.m_41720_() instanceof CropRemover)) {
                        return InteractionResult.CONSUME;
                    }
                    NonNullList drops = NonNullList.m_122779_();
                    BlockEntity blockEntity = levelIn.m_7702_(pos);
                    if (blockEntity instanceof CropsBlockEntity) {
                        CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                        cbe.dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                        for (ItemStack stack2 : drops) {
                            CropBaseBlock.m_49840_((Level)levelIn, (BlockPos)pos, (ItemStack)stack2);
                        }
                        levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(0)));
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.m_6227_(state, levelIn, pos, player, hand, ray);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        int age = (Integer)state.m_61143_((Property)GROWSTATE);
        Vec3 vec3d = (Vec3)builder.m_287159_(LootContextParams.f_81460_);
        if (vec3d != null) {
            BlockPos pos = BlockPos.m_274446_((Position)vec3d);
            BlockEntity blockEntity = builder.m_287258_().m_7702_(pos);
            if (blockEntity instanceof CropsBlockEntity) {
                CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                cbe.addDrops(drops, age);
                drops.add(new ItemStack((ItemLike)ModBlocks.CROPBARS.get()));
            }
        }
        return drops;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof Bee && world.f_46441_.m_188501_() <= 0.005f) {
            this.updateCrop(world, pos);
        }
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public CropTypes getCropType() {
        return this.cropType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CropsBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return level.m_5776_() ? null : CropsBlockEntity::tick;
    }

    public static class ColorHandler
    implements BlockColor {
        public int m_92566_(BlockState state, BlockAndTintGetter blockDisplayReader, BlockPos pos, int tintindex) {
            if (tintindex == 0) {
                return ((CropBaseBlock)state.m_60734_()).getCropType().getSeedColor();
            }
            return -1;
        }
    }
}

